<?php
include_once("c_autonomous_terminals_upload_mo.php");
include_once(_DIR_TO_ENGINE.'/admin/i_admin_system.php') ;
class c_page_cab_autonomous_terminals_upload_mo_setting extends c_page_cab_autonomous_terminals_upload_mo
{
    public $h1='QR codes для настройки терминалов' ;

    function block_main()
    {
        $this->page_title() ;
        $this->info();

        if (!$this->filter['view']) {
            $this->show_qr_code();
            $this->value_from_QR_code();
        } else {
            $this->button_close_pdf();
            $this->show_qr_code_in_pdf();
        }
    }

    function info()
    { ?>
        <p>Для настройки автономных терминалов на отправку данных серверу нужно:</p>
        <ul>
            <li>Распечатать или отсканировать на телефон QR code;</li>
            <li>Показать QR code каждому терминалу, для его настройки.</li>
        </ul>
        <p>Если данные стандартного QR code не подходят для отправки данных с автономного терминала, то необходимо задать параметры для QR code в ручном режиме. После появится QR code для печати с заданными параметрами.</p>
        <?
    }

    function value_from_QR_code()
    { ?>
        <div class="sky-form no_box_shadow">
            <button class="button v2 left" cmd="autonomous_terminals/hand_value_from_QR_code">Задать параметры QR code в ручную</button>
        </div><?
    }

    function button_close_pdf()
    { ?>
        <div class="sky-form no_box_shadow">
            <?if ($this->filter['view']) {?>
                <a class="button v2 left" href="/cab/autonomous_terminals/upload/mo/setting/" style="display:inline-flex;border-radius:3px;">Назад</a>
            <?}?>
        </div><?
    }

    function show_qr_code()
    { ?>
        <table><?
            list($protocol,$ip) = $this->get_protocol_and_ip('standart');
            $this->table_row('стандартный QR code',$protocol,$ip,'standart');
            if ($GLOBALS['LS_autonom_term_server_ip']) {
                list($protocol,$ip) = $this->get_protocol_and_ip('hand');
                $this->table_row('QR code с задаными параметрами',$protocol,$ip,'hand');
            }?>
        </table>
        <style>
            img.qrcode {width: 300px;}
            td {padding-right: 16px;}
        </style>
        <?
    }

    function get_protocol_and_ip($type)
    {
        if ($type == 'standart') {
            $protocol = (_MAIN_PROTOCOL == 'https://')? 1:0;
            $ip = $_SERVER['HTTP_HOST'];
            if (!$ip) {
                $ip = $_SERVER['SERVER_NAME'];
                if ($_SERVER['SERVER_PORT'] and $_SERVER['SERVER_PORT'] != 80 and $_SERVER['SERVER_PORT'] != 443) {
                    $ip .= ':'.$_SERVER['SERVER_PORT'];
                }
            }
        } else {
            $protocol = $GLOBALS['LS_autonom_term_server_protocol'];
            $ip = $GLOBALS['LS_autonom_term_server_ip'];
            if ($GLOBALS['LS_autonom_term_server_port'] and $GLOBALS['LS_autonom_term_server_port'] != 80 and $GLOBALS['LS_autonom_term_server_port'] != 443) {
                $ip .= ':' . $GLOBALS['LS_autonom_term_server_port'];
            }
        }
        return [$protocol,$ip];
    }

    function table_row($name,$protocol,$ip,$filter_v='')
    {
        ?>
        <tr>
            <td>
                <div>
                    <h2 class="center"><?echo $name?></h2>
                    <img class=qrcode src="<?echo _PATH_TO_SITE?>/services/qrcode/<?echo $protocol.','.$ip.',T-'.$GLOBALS['LS_api_key_for_authorization']?>/" />
                </div>
            </td>
            <td style="font-size: 18px;">
                <table>
                    <tr><td>Протокол: </td><td><?if ($protocol) echo 'https://'; else echo 'http://';?></td></tr>
                    <tr><td>Адрес сервера: </td><td><?echo $ip;?></td></tr>
                </table>
                <?if ($filter_v) {?>
                    <form id="sky-form" class="sky-form no_box_shadow" method="POST">
                        <input type="hidden" name="filter[QR_code]" value="<?echo $filter_v?>">
                        <div id="panel_buttons">
                            <button class="button v2 left" cmd="report/view_as_pdf" mode="HTML2PDF">открыть для печати</button>
                        </div>
                    </form>
                <?}?>
            </td>
        </tr>
        <?
    }

    function show_qr_code_in_pdf()
    {
        list($protocol,$ip) = $this->get_protocol_and_ip($this->filter['QR_code']);
        ob_start() ;
        $this->qr_code_pdf($protocol,$ip) ;
        $html=ob_get_clean() ;
        $file_name='temp_'.md5(rand(1,100000)) ;
        $doc_file_name=$this->create_PDF_file($file_name,$this->title,$html,'',['protocol'=>$protocol,'ip'=>$ip]) ;
        $doc_file_path=_TEMP_PATH.$doc_file_name;
        ?><iframe src="<?echo $doc_file_path?>"  style="width:100%; height:700px;margin-top:20px;" frameborder="0"></iframe><?
    }

    function qr_code_pdf($protocol,$ip)
    { ?>
        <div id="panel_connection_view">
            <table class="connection_info">
                <tr><td>Протокол: </td><td><?if ($protocol) echo 'https://'; else echo 'http://';?></td></tr>
                <tr><td>Адрес сервера: </td><td><?echo $ip;?></td></tr>
                <tr>
                    <td colspan="2" class="img">
                        <div class="photo"></div>
                    </td>
                </tr>
            </table>
        </div>
        <style>
            div#panel_connection_view{width:480px;position:relative;}
            div#panel_connection_view table.connection_info{width:100%;}
            div#panel_connection_view table.connection_info td.img{width:180px; text-align:center;}
        </style><?
    }

    function create_PDF_file($doc_name,$report_title,$html,$report_info='',$options=array())
    {
        require_once(_DIR_TO_ROOT.'/AddOns/tcpdf/tcpdf.php');

        // create new PDF document
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('ESMO');
        $pdf->SetTitle($report_title);
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->SetMargins(5, 5, 5,5);
        $pdf->SetHeaderMargin(0);
        $pdf->SetFooterMargin(0);

        $pdf->SetAutoPageBreak(TRUE, 0);
        $pdf->setImageScale(2);
        // set font
        $pdf->SetCellPadding(0);
        $pdf->SetFont('dejavusans', '', 9.5); // любой шрифт из папки /AddOns/tcpdf/fonts/

        // add a page
        $pdf->AddPage('L', 'A7');

        $pdf->writeHTML($html, true, false, true, false, '');

        // QRCODE,H : QR-CODE Best error correction
        $style = array('border' => false,'padding' => 0,'fgcolor' => array(0,0,0),'bgcolor' => false);
        $qrcode = $options['protocol'].','.$options['ip'].',T-'.$GLOBALS['LS_api_key_for_authorization'];
        $pdf->write2DBarcode($qrcode, 'QRCODE,H', 7, 20, 32, 32, $style, 'N');

        //Close and output PDF document
        $doc_file_name=$doc_name.'.pdf' ;
        $doc_dir=_TEMP_DIR.$doc_file_name ;

        $pdf->Output($doc_dir, 'F');

        return($doc_file_name) ;
    }

}