<?php
include_once(_DIR_EXT.'/HTML/c_page_TXT.php') ;
class c_page_cab_autonomous_terminals_upload_mo_from_file_json extends c_page_TXT
{
    public $file_data ;
    public $setting ;
    public $session_uid ;

    function c_page_json() {}
    function body()
    { $res=array() ; ob_start() ;
        if (_sizeof($_FILES)) $res=$this->upload_doc() ;
        $res['report']=ob_get_clean() ;
        $text_json_out=json_encode($res,JSON_UNESCAPED_UNICODE) ;
        echo $text_json_out ;
    }

    function upload_doc()
    {
        ?><strong>Загрузка файла со списком сотрудников во временную таблицу</strong><?
        if (_sizeof($_FILES)) {
            foreach($_FILES as $file_info) {
                $this->setting['file_ext'] = $this->type_file($file_info['type']); //только формат файла
                if ($this->setting['file_ext']) {
                    $result_upload = $this->upload_file($file_info, $this->setting['file_ext']);
                    if ($result_upload) $terminal_info = $this->checking_for_terminals();
                    if ($terminal_info) {
                        echo 'Найден терминал с id='.$terminal_info['id'].'; pkey='.$terminal_info['pkey'];

                        include_once(_DIR_EXT.'/autonomous_terminals/i_mo_import.php');
                        $mo_import = new i_mo_import();
                        $result = $mo_import->import_temp_table_into_db($this->file_data);

                        if ($result) {
                            echo 'Добавлено строк: ' . $result['relation_adding'] . '<br>';
                            echo 'Информация:' . '<br><ul style="margin-left: 30px;"><li>' . implode('</li><li>', $result['comment']) . '</li></ul>';
                        } else echo 'result is empty';
                    }
                } else { echo 'Формат файла не распознан. Выберите файл с форматом .xml или .json'; }
            }
        } else { echo '<p class="red">Файл не был выбран</p>' ; }
    }

    function type_file($content_type)
    {
        if ($content_type == 'application/json') return '.json';
        else if ($content_type == 'application/atom+xml' or $content_type == 'application/soap+xml' or
            $content_type == 'application/xhtml+xml' or $content_type == 'application/xml-dtd' or
            $content_type == 'application/xop+xml' or $content_type == 'application/xml' or
            $content_type == 'text/xml') return '.xml';
        else return false;
    }

    function upload_file($file,$temp_file_ext)
    {
        ?><p>Загружаем данные из файла "<strong><?echo $file['name']?></strong>" во временную таблицу</p><?
        if (!$this->session_uid) $this->session_uid = ENGINE()->generate_UID() ;
        $target_fname=_TEMP_DIR.$this->session_uid.$temp_file_ext ;
        $this->setting['upload_fname']=$this->upload_to_file($target_fname,$file) ;
        $source_DB = $this->upload_source_file_to_array($temp_file_ext);

        if ($source_DB) {
            echo '<p>Файл '.$file['name'].' был успешно загружен</p>';
            return true;
        } else { return false; }
    }

    function upload_to_file($fdir,$file_info)
    {
        echo 'Источник данных - файл для загрузки "<strong>'.$file_info['name'].'</strong>"<br>' ;
        $temp_fdir='' ;
        $result=move_uploaded_file($file_info['tmp_name'],$fdir) ;
        if ($result) {
            $temp_fdir=hide_server_dir($fdir) ;
            echo 'Данные сохранены во временном файле: <a href="'.$temp_fdir.'" target="blank">'.$temp_fdir.'</a><br>' ;
        } else {
            echo '<div class=alert>Не удалось загрузить файл: '.$file_info['name'].'</div>';?><h3>upload info</h3><?
            damp_array($file_info,1,-1) ;
            $perm=ENGINE()->get_file_perms_info(_DIR_TO_ROOT.'/temp/',array('symbol'=>1)) ;
            ?><h3>/temp/ permissions</h3><?
            damp_array($perm,1,-1) ;
        }
        return($temp_fdir) ;
    }

    function upload_source_file_to_array($temp_file_ext)
    {
        if ($temp_file_ext == '.xml') $this->file_data = AUTONOMOUS_TERMINALS()->import_data_xml($this->setting['upload_fname']);
        else $this->file_data = AUTONOMOUS_TERMINALS()->import_data_json($this->setting['upload_fname']);
        return $this->file_data;
    }

    function checking_for_terminals()
    {
        $new_terminal = $this->file_data[0];

        //проверяем что есть такой терминал
        if ($new_terminal['terminal_type'] == "kt") $terminal_info = DEVICE()->get_terminal('clss=241 and id='.$new_terminal['terminal_id'],['device'=>true]);
        else $terminal_info = ESMO()->get_terminal_by_id($new_terminal['terminal_id']);

        if (!$terminal_info) {
            //предлагаем создать терминал
            ?><div class="sky-form no_box_shadow">
            <form action="" method="POST" enctype="multipart/form-data">
                <input name="upload_fname" value="<?echo $this->setting['upload_fname'];?>" type="hidden">
                <input name="file_ext" value="<?echo $this->setting['file_ext'];?>" type="hidden">
                <input name="terminals_id" value="<?echo $new_terminal['terminal_id']?>" type="hidden">
                <input name="terminals_type" value="<?echo $new_terminal['terminal_type']?>" type="hidden">
                <p>Создать терминал с ID <?echo $new_terminal['terminal_id']?>?</p>
                <input name="cmd" type="submit" class="button v2" cmd="upload_file" value="Да" style="float:none;display:inline;">&nbsp;&nbsp;&nbsp;<button class="button v1" style="float:none;display:inline;" cmd="">Нет</button>
                <br><br>
            </form>
            </div><?
        }
        return $terminal_info;
    }

}
