<?php
include_once("c_setting_update.php");
class c_page_cab_setting_moduls extends c_page_cab_setting_update
{
  public $h1='Конфигуратор модулей ЭСМО' ;

  function block_main()
    {
        $this->page_title() ;
        if (!file_exists(_DIR_TO_ROOT.'/ini/ini.yaml')) { ?>
            <div class="sky-form no_box_shadow left-column">
               <p>Для управления модулями ЭСМО вам необходимо конвертировать файл конфигурации ЭСМО в формат yaml. Старый файл конфигурации будет сохранен в резервной копии.</p>
               <button class="button v2" cmd="aspmo_setting/convert_patch_to_yaml">Конвертировать конфиг в формат yaml</button>
           </div><?
          return ;
        } ?>
        <form class="sky-form no_box_shadow"><?
            $this->add_modules();
            $this->add_plugins();
            $this->add_local_modules(); ?>
            <button class="button v2" cmd="aspmo_setting/save_setting">Сохранить</button>
        </form>
        <style>
            div.block_moduls, div.block_plugins {overflow:hidden;}
            div.block_moduls.left {width:50%;float:left;}
            div.block_plugins.right {width:50%;float:right;}
            div.block_moduls h2, div.block_plugins h2 {padding:10px 0;text-align:center;}
            div.module_element {width:12.5%;display:inline-block;text-align:center;float:left;padding:5px 0;}
            div.right div.module_element, div.left div.module_element {width:25%;}
            div.module_element input[type="checkbox"] {display: none;}
            div.block_moduls div.module_element label[for] {background-color:#afcfff;}
            div.block_plugins div.module_element label[for] {background-color:#b0f7e3;}
            div.module_element label[for] {line-height:80px;display:block;border-radius:10px;margin:0 5px;opacity:0.8;cursor: pointer}
            div.module_element label strong {height:100%;line-height:normal;display:inline-block;vertical-align:middle;padding:0 8px;}
            div.block_moduls div.module_element input[type="checkbox"]:checked + label[for] {background-color:#2da5da;}
            div.block_plugins div.module_element input[type="checkbox"]:checked + label[for] {background-color:#177d56;}
            div.module_element input[type="checkbox"]:checked + label[for] strong {color:white;}
        </style>
        <?
    }

    function add_modules()
    { ?>
        <div class="block_moduls">
            <h2>Подключаемые модули</h2>
            <?
            $this->form_checkbox_left('<strong>Active Directory</strong>','Модуль управления учетными записями ЭСМО через службу Active Directory','IS[modules][AD]',$GLOBALS['_SETTING']['modules']['AD']) ;
            $this->form_checkbox_left('<strong>ЭЦП</strong>','','IS[modules][ecp]',$GLOBALS['_SETTING']['modules']['ecp']) ;
            $this->form_checkbox_left('<strong>Контроль трезвости</strong>','','IS[modules][skd|kt]',$GLOBALS['_SETTING']['modules']['kt']) ;
            $this->form_checkbox_left('<strong>Пупиллометрия</strong>','','IS[modules][pp]',$GLOBALS['_SETTING']['modules']['pp']) ;
            $this->form_checkbox_left('<strong>Цеховой терапевт</strong>','','IS[modules][terapevt]',$GLOBALS['_SETTING']['modules']['terapevt']) ;
            $this->form_checkbox_left('<strong>Клиенты</strong>','','IS[modules][client]',$GLOBALS['_SETTING']['modules']['client']) ;
            $this->form_checkbox_left('<strong>Предприятие</strong>','Инструктажи, ПМО, Контроль сдачи документов, Прием документов','IS[modules][event|enterprise]',$GLOBALS['_SETTING']['modules']['enterprise']) ;
//            $this->form_checkbox_left('<strong>Обучение персонала</strong>','Контроль прохождения обучения по направлениям необходимым для допуска на рабочее место','IS[modules][event|education]',$GLOBALS['_SETTING']['modules']['education']) ; // 'Контроль прохождения обучения по направлениям Электробезопасность, Охрана труда, Пожарно-технический минимум, Промышленная безопасность
            $this->form_checkbox_left('<strong>Охрана труда</strong>','','IS[modules][ot]',$GLOBALS['_SETTING']['modules']['ot']) ;
            $this->form_checkbox_left('<strong>Контроль знаний</strong>','','IS[modules][quiz]',$GLOBALS['_SETTING']['modules']['quiz']) ;
            $this->form_checkbox_left('<strong>Опросы</strong>','','IS[modules][poll]',$GLOBALS['_SETTING']['modules']['poll']) ;
            $this->form_checkbox_left('<strong>Доведение медиа-контента</strong>','','IS[modules][media_content]',$GLOBALS['_SETTING']['modules']['media_content']) ;
            $this->form_checkbox_left('<strong>Рабочее место ламповщика</strong>','','IS[modules][mine]',$GLOBALS['_SETTING']['modules']['mine']) ;
            $this->form_checkbox_left('<strong>Печать нарядов</strong>','Модуль печати нарядов','IS[modules][print_order]',$GLOBALS['_SETTING']['modules']['print_order']) ;
            $this->form_checkbox_left('<strong>ТО</strong>','Модуль тех. осмотров','IS[modules][to]',$GLOBALS['_SETTING']['modules']['to']) ;
            $this->form_checkbox_left('<strong>СКУД</strong>','','IS[modules][skd]',$GLOBALS['_SETTING']['modules']['skd']) ;
            $this->form_checkbox_left('<strong>ПЛ</strong>','','IS[modules][pl]',$GLOBALS['_SETTING']['modules']['pl']) ;
            $this->form_checkbox_left('<strong>Уведомления по неисправностям</strong>','','IS[modules][notify]',$GLOBALS['_SETTING']['modules']['notify']) ;
            ?>
        </div><?
        }

    function add_plugins()
    { ?>
        <div class="block_plugins">
            <h2>Подключаемые плагины</h2>
             <?
//            $this->form_checkbox_left('<strong>Внедрение ЭСМО</strong>','Модуль внедрения ЭСМО','IS[plugins][esmo_intro]',$GLOBALS['_SETTING']['plugins']['esmo_intro'],1) ;
            $this->form_checkbox_left('<strong>Интеграция ЭСМО</strong>','Модуль загрузки/выгрузки данных в ЭСМО','IS[plugins][esmo_gateway]',$GLOBALS['_SETTING']['plugins']['esmo_gateway'],1) ;
            $this->form_checkbox_left('<strong>Рабочее место руководителя</strong>','Модуль объедиенной статистики для руководителя','IS[plugins][esmo_master]',$GLOBALS['_SETTING']['plugins']['esmo_master'],1) ;
            $this->form_checkbox_left('<strong>МО - Фрамингемская шкала</strong>','','IS[plugins][framingham]',$GLOBALS['_SETTING']['plugins']['framingham'],1) ;
            $this->form_checkbox_left('<strong>МО - Шкала SCORE</strong>','','IS[plugins][score]',$GLOBALS['_SETTING']['plugins']['score'],1) ;
            $this->form_checkbox_left('<strong>FaceID</strong>','','IS[plugins][faceid]',$GLOBALS['_SETTING']['plugins']['faceid'],1) ;
            $this->form_checkbox_left('<strong>MO сервер</strong>','Плагин сбора данных по МО','IS[plugins][mo_serv]',$GLOBALS['_SETTING']['plugins']['mo_serv'],'i_mo_serv') ;
            $this->form_checkbox_left('<strong>MO нода</strong>','Плагин отправки данных по МО','IS[plugins][mo_node]',$GLOBALS['_SETTING']['plugins']['mo_node'],'i_mo_node') ;
            $this->form_checkbox_left('<strong>Автономные медосмотры</strong>','Плагин загрузки данных с автономных терминалов','IS[plugins][autonomous_terminals]',$GLOBALS['_SETTING']['plugins']['autonomous_terminals']) ;
            $this->form_checkbox_left('<strong>Санобработка</strong>','Плагин перевода терминала в режим санобработки при выявлении повышенной температуры','IS[plugins][sanitar]',$GLOBALS['_SETTING']['plugins']['sanitar'],'i_sanitar') ;
            $this->form_checkbox_left('<strong>Отправка отчетов</strong>','Плагин отправки отчетов на email','IS[plugins][send_report]',$GLOBALS['_SETTING']['plugins']['send_report'],'i_send_report') ;
            $this->form_checkbox_left('<strong>Тестирование ЭСМО</strong>','Плагин нагрузочного тестирования ЭСМО','IS[plugins][testing]',$GLOBALS['_SETTING']['plugins']['testing'],'i_testing') ;
            $this->form_checkbox_left('<strong>Наряды на работу</strong>','Плагин выдачи и учета нарядов на работу','IS[plugins][narad]',$GLOBALS['_SETTING']['plugins']['narad'],'i_narad') ;
            $this->form_checkbox_left('<strong>ПМО</strong>','Плагин переодического медицинского осмотра','IS[plugins][pmo]',$GLOBALS['_SETTING']['plugins']['pmo'],'i_pmo') ;
            $this->form_checkbox_left('<strong>ОПО</strong>','Плагин обязательного пcихиатрического освидетельствования','IS[plugins][opo]',$GLOBALS['_SETTING']['plugins']['opo'],'i_opo') ;
            ?>
        </div><?
    }

    function add_local_modules()
    {
             $local_dir=_DIR_TO_ROOT.'/'.$GLOBALS['_SETTING']['dist']['local_version'] ; $dir_list_plugins=array() ;
        if (isset($GLOBALS['_SETTING']['dist']['local_version']) and is_dir($local_dir)) {
            $mod_info = $this->get_info_for_modul($local_dir); ?>
            <div class="block_moduls left">
                <h2>Локальные модули</h2><?
              $dir_list=get_dir_list($local_dir.'/engine_moduls/') ;
                if (isset($dir_list['plugins'])) {
                    if (is_dir($local_dir.'/engine_moduls/plugins/')) {
                        $list_files=get_dir_files_list($local_dir.'/engine_moduls/plugins/') ;
                  $dir_list_plugins=$list_files['files'] ;
                }
                unset($dir_list['plugins']) ;
              }
                if (_sizeof($dir_list)) foreach($dir_list as $dir_name) {
                    $name = basename($dir_name);
                    if ($mod_info[$name]) $this->form_checkbox_left('<strong>'.$mod_info[$name]['name'].'</strong>',$mod_info[$name]['comment'],$mod_info[$name]['is'],$mod_info[$name]['globals']) ;
                    else $this->form_checkbox_left('<strong>'.$name.'</strong>','','IS[modules_local]['.$name.']',$GLOBALS['_SETTING']['modules_local'][$name]) ;
                }
                if (_sizeof($dir_list_plugins)) foreach($dir_list_plugins as $fname) {
                    if (preg_match('/i_(.+?)\.php/is',$fname,$match)) {
                        if ($mod_info[$match[1]]) $this->form_checkbox_left('<strong>'.$mod_info[$match[1]]['name'].'</strong>',$mod_info[$match[1]]['comment'],$mod_info[$match[1]]['is'],$mod_info[$match[1]]['globals']) ;
                        else $this->form_checkbox_left('<strong>'.$match[1].'</strong>','','IS[plugins_local]['.$match[1].']',$GLOBALS['_SETTING']['plugins_local'][$match[1]]) ;
                    }
                } ?>
            </div>

            <div class="block_plugins right">
            <h2>Локальные расширения</h2><?
            $local_ext=$local_dir.'/ext/' ;
            if (is_dir($local_ext)) {
                $dir_list=get_dir_list($local_ext) ;
                if (_sizeof($dir_list)) foreach($dir_list as $dir_name) {
                    $name = basename($dir_name);
                    if ($mod_info[$name]) $this->form_checkbox_left('<strong>'.$mod_info[$name]['name'].'</strong>',$mod_info[$name]['comment'],$mod_info[$name]['is'],$mod_info[$name]['globals']) ;
                    else $this->form_checkbox_left('<strong>'.$name.'</strong>','','IS[ext_local]['.$name.']',$GLOBALS['_SETTING']['ext_local'][$name]) ;
                }
            }
            ?></div><?
        }
    }

    function get_info_for_modul($local_dir)
              {
        $modul_info=[];
        if (file_exists($local_dir.'/info.json')) {
            $JSON_source = file_get_contents($local_dir . '/info.json');
            $json = json_decode($JSON_source, true);
            foreach ($json as $item) if ($item['file_name']) {
                if (!$item['name']) $item['name'] = $item['file_name'];
                if (!$item['comment']) $item['comment'] = '';
                if (!$item['is']) $item['is'] = 'IS[plugins_local]['.$item['file_name'].']';
                if (!$item['globals']) $item['globals'] = $GLOBALS['_SETTING']['plugins_local'][$item['file_name']];
                if (stripos($item['file_name'],'|')) {
                    $file_names = explode('|',$item['file_name']);
                    foreach ($file_names as $file_name) $modul_info[$file_name] = $item;
                } else $modul_info[$item['file_name']] = $item;
              }
             }
        return $modul_info;
             }

    function form_checkbox_left($title,$comment,$var_name,$value=0,$check_value=1)
    {
        $el_var_name=(strpos($var_name,'[')!==false)? $var_name:'setting['.$var_name.']' ; ?>
        <div class="module_element">
            <input type="hidden" name="<?echo $el_var_name?>" value="0">
            <input type="checkbox" name="<?echo $el_var_name?>" value="<?echo $check_value?>" id="<?echo $var_name;?>" <?if ($value) echo 'checked';?>/>
            <label for="<?echo $var_name;?>" name="<?echo $el_var_name?>" type="checkbox"><p title="<?echo $comment;?>"><?echo $title;?></p></label>
        </div><?
     }


}



?>
