<?
// сервис обрабатывает загруженный json-файл с ролями и правами доступа для этих ролей
// если ID загружаемой роли уже занят
//  1 - если ID < 100, то роль и права перезаписываются
//  2 - если ID >= 100, то создается новая роль с суфиксом _NEW
// если ID загружаемой роли еще не занят, то создается новая роль с этим ID
include_once(_DIR_TO_MODULES.'/engine/i_backgroup_process.php') ;
include_once(_DIR_TO_MODULES.'/engine/i_setup.php') ;
include_once(_DIR_TO_ENGINE . '/AddOns/pclzip.lib.php');
class c_services_aspmo_setting_upload_roles extends i_backgroup_process_exec
{
    public $arr_changes = [];
    public $arr_added = [];

	function exec()
    { ob_start() ;
      if (_sizeof($this->setting['files'])) foreach($this->setting['files'] as $fname)
      {
        $this->upload_from_json($fname) ;
      }
      FILE_LOG()->append('END') ;
      $text=ob_get_clean() ;
      LOGS()->reg_log('upload_roles','Импорт ролей из файла json',array('data'=>$this->setting['files'],'save_to_file'=>$text)) ;
      echo $text ;
    }

	function upload_from_json($fname)
    {    FILE_LOG()->append('Открываем файл '._TEMP_DIR.$fname.'') ;
         echo 'Открываем файл  <strong>'._TEMP_DIR.$fname.'</strong><br><br>' ;
         $fcontent = file_get_contents(_TEMP_DIR.$fname);
         if ($fcontent){
             $roles = json_decode($fcontent,true);
             $old_roles = execSQL('select id,obj_name,index_page,use_auch_as_smena,smena_monopole_mode,report_template,autologout from '.TM_ROLES.' where id in ('.implode(',',array_keys($roles)).')');
//                 damp_array($old_roles);
             $ad = 0; $i=0;
             if (_sizeof($roles)) foreach ($roles as $id=>$rol){
                 echo '<br>';
                 if (in_array($id,array_column($old_roles,'id'))) {
                     switch ($id){
                         //если уже существует роль с таким id и id<100 => вносим изменения по этой роли
                         case ($id < 100):
                             $this->check_changes($rol,$old_roles[$id]);
                             if (_sizeof($this->arr_changes[$id])) {
                                 $data = [];
                                 foreach ($this->arr_changes[$id] as $field=>$value) $data[$field] = $rol[$field];
                                 update_rec_in_table(TM_ROLES, $data, 'id='.$id);
                             }
                             $this->add_permit($id,$rol['permit'],['before_delete_permit'=>1]);

                             FILE_LOG()->append('Роль ID '.$id.' '.$rol['obj_name'].' уже есть - обновляем запись в таблице ролей') ;
                             echo 'Роль ID '.$id.'-'.$rol['obj_name'].' уже есть - обновляем запись в таблице ролей<br>' ;
                             break;
                         //в остальных случаях создаем новую роль с суффиксом new
                         default:
                             $new_id = $this->add_roll($rol);
                             $this->add_permit($new_id,$rol['permit']);
                             $ad++;

                             FILE_LOG()->append('Роль ID '.$id.' '.$rol['obj_name'].' уже есть. Создаем новую роль ID '.$new_id) ;
                             echo 'Роль ID '.$id.'-'.$rol['obj_name'].' уже есть. Создаем новую роль ID '.$new_id.'<br>' ;
                             break;
                     }
                 } else { // если роли с таким id еще не существует, то создаем новую запись
                     $new_id = $this->add_roll($rol);
                     $this->add_permit($new_id,$rol['permit']);
                     $ad++;

                     FILE_LOG()->append('Роль ID '.$id.' '.$rol['obj_name'].' не найдена. Создаем новую роль ID '.$new_id) ;
                     echo 'Роль ID '.$id.'-'.$rol['obj_name'].' не найдена. Создаем новую роль ID '.$new_id.'<br>' ;
                 }
                 $i++;
                 echo '<br>';
             }
             FILE_LOG()->append('Обработано всего '.$i.' записей') ;
             echo '<br>Обработано всего <b>'.$i.'</b> записей<br>' ;

             FILE_LOG()->append('Создано '.$ad.'</b> новых записей') ;
             echo 'Создано <b>'.$ad.' новых записей<br>' ;

             //выводим изменения
             if (_sizeof($this->arr_changes)) {
                 FILE_LOG()->append('Изменений внесено в '._sizeof($this->arr_changes).' записей') ;
                 echo 'Изменений внесено в <b>'._sizeof($this->arr_changes).'</b> записей<br>' ;
                 damp_array($this->arr_changes,1,-1);
             } else {
                 FILE_LOG()->append('Изменений не произведено') ;
                 echo 'Изменений не произведено<br>' ;
             }
         } else {
             FILE_LOG()->append('Не удалось получить содержимое файла '._TEMP_DIR.$fname.'') ;
             echo 'Не удалось получить содержимое файла  <strong>'._TEMP_DIR.$fname.'</strong><br>' ;
         }
    }

    function check_changes($new_rol,$old_rol){
        if (isset($new_rol['obj_name']) && $new_rol['obj_name'] != $old_rol['obj_name']) $this->arr_changes[$old_rol['id']]['obj_name'] = $old_rol['obj_name'].' => '.$new_rol['obj_name'];
        if (isset($new_rol['index_page']) && $new_rol['index_page'] != $old_rol['index_page']) $this->arr_changes[$old_rol['id']]['index_page'] = $old_rol['index_page'].' => '.$new_rol['index_page'];
        if (isset($new_rol['use_auch_as_smena']) && $new_rol['use_auch_as_smena'] != $old_rol['use_auch_as_smena']) $this->arr_changes[$old_rol['id']]['use_auch_as_smena'] = $old_rol['use_auch_as_smena'].' => '.$new_rol['use_auch_as_smena'];
        if (isset($new_rol['smena_monopole_mode']) && $new_rol['smena_monopole_mode'] != $old_rol['smena_monopole_mode']) $this->arr_changes[$old_rol['id']]['smena_monopole_mode'] = $old_rol['smena_monopole_mode'].' => '.$new_rol['smena_monopole_mode'];
        if (isset($new_rol['report_template']) && $new_rol['report_template'] != $old_rol['report_template']) $this->arr_changes[$old_rol['id']]['report_template'] = $old_rol['report_template'].' => '.$new_rol['report_template'];
        if (isset($new_rol['autologout']) && $new_rol['autologout'] != $old_rol['autologout']) $this->arr_changes[$old_rol['id']]['autologout'] = $old_rol['autologout'].' => '.$new_rol['autologout'];
    }

    function add_roll($data, $options=array()){
        $last_id=execSQL_value('select max(id) from '.TM_ROLES) ;
        $last_id++ ;
        if ($last_id<100) $last_id=100 ;
        $rec_rol = [];
        $rec_rol['use_auch_as_smena'] = ($data['use_auch_as_smena']) ? 1:0;
        $rec_rol['smena_monopole_mode'] = ($data['smena_monopole_mode']) ? 1:0;
        $rec_rol['autologout'] = ($data['autologout']) ? 1:0;
        $rec_rol['report_template'] = ($data['report_template']) ? $data['report_template']:'';
        $name_rol = $this->new_name($data, $options);
        $index_page = ($data['index_page']) ? $data['index_page'] : '';
        SETUP()->reg_rol($last_id,$name_rol,$index_page,$rec_rol) ;
        return $last_id;
    }

    function new_name($data, $options=array()){
        $name_rol = ($options['suffix_new']) ? $data['obj_name'].$options['suffix_new'] : $data['obj_name'];
        $check_name = execSQL_van('select obj_name from '.TM_ROLES.' where obj_name="'.$name_rol.'"');
        if (!$check_name) return $name_rol;
        else {
            $data['obj_name'] = $name_rol;
            $options['suffix_new'] = '_NEW';
            return $this->new_name($data,$options);
        }

    }

    function add_permit($rol_id, $permit, $options = array()){
        if ($options['before_delete_permit']) {
            $count = execSQL_update('delete from '.TM_PERMIT.' where rol_id='.$rol_id) ;
        }
        if (_sizeof($permit)) foreach ($permit as $key=>$per) adding_rec_to_table(TM_PERMIT,['obj_name'=>$per['obj_name'],'clss'=>$per['clss'],'rol_id'=>$rol_id]);

        if ($options['before_delete_permit']) {
            FILE_LOG()->append('Перезаписаны права доступа для роли '.$rol_id) ;
            echo 'Перезаписаны права доступа для роли '.$rol_id.'</strong><br>' ;
        } else {
            FILE_LOG()->append('Добавлены права доступа для роли '.$rol_id) ;
            echo 'Добавлены права доступа для роли '.$rol_id.'</strong><br>' ;
        }
    }
}

?>
