<?php
include_once("c_client_drivers_upload_from_post.php");
class c_page_cab_client_drivers_upload_from_post_docs extends c_page_cab_client_drivers_upload_from_post
{
    public $h1='Загрузка списка водителей - документация для разработчиков' ;

    function block_main()
    { $this->page_title() ;
      ?><br><h2>Описание тегов XML-файла</h2>
        <table class="basic fz_normal left">
            <tr><td>Drivers</td><td></td><td>Контейнер списка водителей. Должен находиться в корне документа</td></tr>
            <tr><td>Driver</td><td></td><td>Контейнер описания водителя. Должен находиться в контейнере Drivers</td></tr>
            <tr><td>Uuid</td><td>string(32)</td><td>Ваш уникальный идентификатор водителя.</td></tr>
            <tr><td>Name</td><td>string(256)</td><td>ФИО водителя</td></tr>
            <tr><td>Phone</td><td>string(12)</td><td>Телефон водителя</td></tr>
            <tr><td>DriverLicense</td><td>string(32)</td><td>Серия, номер водительского удостоверения водителя</td></tr>
            <tr><td>DateMedSpravka</td><td>string(32)</td><td>Дата выдачи мед.справки, формат ДД.ММ.ГГГГ</td></tr>
            <tr><td>Dr</td><td>string(10)</td><td>Дата рождения водителя, формат ДД.ММ.ГГГГ</td></tr>
            <tr><td>Pol</td><td>string(1)</td><td>Пол водителя, М/Ж</td></tr>
            <tr><td>Structure</td><td>string(256)</td><td>Название автопарка</td></tr>
            <tr><td>Images_url</td><td></td><td>Контейнер списка фото. Должен находиться в контейнере Driver</td></tr>
            <tr><td>Image</td><td>string(256)</td><td>URL фото водителя.</td></tr>
        </table>
        <br><h2>Алгоритм загрузки списка водителей</h2>
        <ul>
            <li>Uuid водителя  - уникальный идентификатор в вашей системе. В работе системе ЭСМО используется только для синхронизации данных на шлюзе, поле обязательно для заполнения.</li>
            <li>При загрузке данных водители идентифицируются по Uuid.</li>
            <li>Если водитель найден, информация по нему будет обновлена.</li>
            <li>Если водитель не найден, будет создана новая запись.</li>
            <li>Если указано новое для организации название автопарка, новый автопарк будет добавлен в организацию автоматически.</li>
            <li>Для водителя указывается одно фото в контейнере Images_url.</li>
            <li>Загрузка фото на сервер производиться асинхронно, так как при большом объему записей обработка фото может занять значительное время.</li>
            <li>Фото идентифицируется по названию файла, если при последующей передаче данных будет передано новое имя фото, старое фото будет удалено.</li>
            <li>Асинхронный процесс загрузки фото загрузит новые изображения примерно в течении 5 мин после загрузки XML, но конкретное время определяется длиной общей очереди всех клентов.</li>
        </ul>
        <br><h2>Описание ответа шлюза</h2>
                <p>Ответ шлюза приходит в формате tag=value, в случае ошибки будет возвращен только один тег ошибки</p>
                <p>В случае успешной загрузки, будет возвращен набор тегов с описанием кол-ва добавленных и новых записей. Теги при этому будут разделены переносом строки.</p>
                <table class="basic fz_normal left">
                    <tr><td>Ошибки</td><td>error=member_not_found</td><td>неверный client_id</td></tr>
                    <tr><td></td><td>error=member_is_not_client</td><td>указанный аккаунт не является клиентом системы ЭСМО</td></tr>
                    <tr><td></td><td>error=client_disabled</td><td>Аккаунт клиента заблокирован</td></tr>
                    <tr><td></td><td>error=not_valid_XML_source</td><td>Неверный формат XML, ошибка при разборе файла</td></tr>
                    <tr><td>Успешный импорт</td><td>driver_count=XXX</td><td>Число обработанных контейнеров с описаниеми водителей</td></tr>
                    <tr><td></td><td>driver_update=XXX</td><td>Число обновленных записей по водителям</td></tr>
                    <tr><td></td><td>driver_adding=XXX</td><td>Число новых записей по водителям</td></tr>
                    <tr><td></td><td>driver_enabled=XXX</td><td>Общее число активных водителей после импорта</td></tr>
                    <tr><td></td><td>driver_disabled=XXX</td><td>Общее число заблокированных водителей после импорта</td></tr>
                    <tr><td></td><td>strusture_add=XXX</td><td>Число добавленных автопарков</td></tr>
                    <tr><td></td><td>img_exist=XXX</td><td>Число изображений, уже добавленных ранее к водителям</td></tr>
                    <tr><td></td><td>img_to_upload=XXX</td><td>Число изображений, поставленных в очередь на загрузку</td></tr>
                    <tr><td></td><td>img_to_delete=XXX</td><td>Число изображений на удаление (отсутствующих в контейнерах водителей)</td></tr>
                </table>
      <?

    }



}



?>