<?php
include_once("c_client_cars_upload_from_post.php");
class c_page_cab_client_cars_upload_from_post_docs extends c_page_cab_client_cars_upload_from_post
{
    public $h1='Загрузка списка автомобилей - документация для разработчиков' ;

    function block_main()
    { $this->page_title() ;
      ?><br><h2>Описание тегов XML-файла</h2>
                <table class="basic fz_normal left">
                    <tr><td>Cars</td><td></td><td>Контейнер списка автомобилей. Должен находиться в корне документа</td></tr>
                    <tr><td>Car</td><td></td><td>Контейнер описания автомобиля. Должен находиться в контейнере Cars</td></tr>
                    <tr><td>Uid</td><td>string(32)</td><td>Ваш уникальный идентификатор автомобиля.</td></tr>
                    <tr><td>Marka</td><td>string(32)</td><td>Марка автомобиля</td></tr>
                    <tr><td>Model</td><td>string(32)</td><td>Модель автомобиля</td></tr>
                    <tr><td>License</td><td>string(32)</td><td>Серия и номер лицензции</td></tr>
                    <tr><td>Year</td><td>string(32)</td><td>Год выпуска авто</td></tr>
                    <tr><td>CarNumber</td><td>string(32)</td><td>Гос.рег.знак</td></tr>
                    <tr><td>OSAGO</td><td>string(10)</td><td>срок действия полиса ОСАГО, формат ДД.ММ.ГГГГ</td></tr>
                    <tr><td>STS</td><td>string(10)</td><td>срок действия СТС, формат ДД.ММ.ГГГГ</td></tr>
                    <tr><td>TO</td><td>string(10)</td><td>дата окончания ГТО, формат ДД.ММ.ГГГГ</td></tr>
                    <tr><td>Ext_info</td><td></td><td>Контейнер дополнительного описания авто. Должен находиться в контейнере Car. Теги внутри контейнера являются произвольными, и том виде как описаны, будут показы в карточке авто.</td></tr>
                    <tr><td>Images_url</td><td></td><td>Контейнер списка фото. Должен находиться в контейнере Car</td></tr>
                    <tr><td>Image</td><td>string(256)</td><td>URL фото автомобиля.</td></tr>
                </table>
                <br><h2>Алгоритм загрузки списка водителей</h2>
                <ul>
                    <li>Uid авто - уникальный идентификатор в вашей системе. В работе системе ЭСМО используется только для синхронизации данных на шлюзе, поле обязательно для заполнения.</li>
                    <li>При загрузке данных автомобили идентифицируются по UID.</li>
                    <li>Если автомобиль найден, информация по нему будет обновлена.</li>
                    <li>Если автомобиль не найден, будет создана новая запись.</li>
                    <li>Отсутствующие в списке авто, будут удалены, если они были загружены ранее.</li>
                    <li>Для автомобиля указывается до трех фото в контейнере Images_url.</li>
                    <li>Требования к фото - размер не более 640px по ширине, 480px по высоте, формат jpg</li>
                    <li>Загрузка фото на сервер производиться асинхронно, так как при большом объему записей обработка фото может занять значительное время.</li>
                    <li>Фото идентифицируется по названию файла, если при последующей передаче данных будет передано новое имя фото, старое фото будет удалено.</li>
                    <li>Асинхронный процесс загрузки фото загрузит новые изображения примерно в течении 5 мин после загрузки XML, но конкретное время определяется длиной общей очереди всех клентов.</li>
                </ul>
                <br><h2>Описание ответа шлюза</h2>
                        <p>Ответ шлюза приходит в формате tag=value, в случае ошибки будет возвращен только один тег ошибки</p>
                        <p>В случае успешной загрузки, будет возвращен набор тегов с описанием кол-ва добавленных и новых записей. Теги при этому будут разделены переносом строки.</p>
                        <table class="basic fz_normal left">
                            <tr><td>Ошибки</td><td>error=member_not_found</td><td>неверный client_id</td></tr>
                            <tr><td></td><td>error=member_is_not_client</td><td>указанный аккаунт не является клиентом системы ЭСМО</td></tr>
                            <tr><td></td><td>error=client_disabled</td><td>Аккаунт клиента заблокирован</td></tr>
                            <tr><td></td><td>error=not_valid_XML_source</td><td>Неверный формат XML, ошибка при разборе файла</td></tr>
                            <tr><td>Успешный импорт</td><td>cars_count=XXX</td><td>Число обработанных контейнеров с описаниеми автомобилей</td></tr>
                            <tr><td></td><td>cars_update=XXX</td><td>Число обновленных записей по автомобилям</td></tr>
                            <tr><td></td><td>cars_adding=XXX</td><td>Число новых записей по автомобилям</td></tr>
                            <tr><td></td><td>cars_enabled=XXX</td><td>Общее число активных автомобилей после импорта</td></tr>
                            <tr><td></td><td>cars_disabled=XXX</td><td>Общее число заблокированных водителей после импорта</td></tr>
                            <tr><td></td><td>cars_coflict=XXX</td><td>Число автомобилей, которые не удалось добавить из-за неуникального рег.номера</td></tr>
                            <tr><td></td><td>img_exist=XXX</td><td>Число изображений, уже добавленных ранее к автомобилям</td></tr>
                            <tr><td></td><td>img_to_upload=XXX</td><td>Число изображений, поставленных в очередь на загрузку</td></tr>
                            <tr><td></td><td>img_to_delete=XXX</td><td>Число изображений на удаление (отсутствующих в контейнерах автомобилей)</td></tr>
                        </table>
         <?
    }



}



?>