<?php
include_once(_DIR_TO_CLASS.'/c_page.php');

class c_page_cab_smenaout extends c_page
{
	public $h1='Окончание смены - подготовка журнала за смену';

	/**
	 * Метод отрисовки карточки дашборда
	 * @param string $icon - иконка (emoji)
	 * @param string $label - подпись карточки
	 * @param string $value - основное значение
	 * @param string $subvalue - дополнительное значение (опционально)
	 * @param string $card_class - дополнительный CSS класс для карточки
	 * @param string $extra_content - дополнительный HTML контент после subvalue (для прогресс-бара и т.д.)
	 */
	function render_dashboard_card($icon, $label, $value, $subvalue='', $card_class='', $extra_content='')
	{
		?>
		<div class="dashboard-card <? echo $card_class ?>">
			<div class="card-icon-large"><? echo $icon ?></div>
			<div class="card-content">
				<div class="card-label"><? echo $label ?></div>
				<div class="card-value"><? echo $value ?></div>
				<?php if ($subvalue): ?>
					<div class="card-subvalue"><? echo $subvalue ?></div>
				<?php endif; ?>
				<?php if ($extra_content): ?>
					<? echo $extra_content ?>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}

	/**
	 * Метод отрисовки всех карточек дашборда
	 */
	function render_dashboard_cards()
	{
		// Карточка сотрудника
		$this->render_dashboard_card('👤', 'Сотрудник', MEMBER()->working, MEMBER()->name, 'user-card');

		// Карточка рабочей группы
		$this->render_dashboard_card('👥', 'Рабочая группа', MEMBER()->cur_group_name, '', 'group-card');

		// Карточка статуса
		$status_html='<div class="status-indicator">
											 <span class="pulse-dot"></span>
										 </div>';

		$this->render_dashboard_card('📊', 'Статус смены', '<span class="status-active">Активна</span>', '', 'status-card', $status_html);

		// Карточка начала смены
		$start_time=strtotime(MEMBER()->_smena_in);
		$this->render_dashboard_card('🚀', 'Начало смены', date('H:i', $start_time), date('d.m.Y', $start_time), 'time-card start-time');

		// Карточка окончания смены
		$this->render_dashboard_card('🏁', 'Окончание смены', date('H:i'), date('d.m.Y'), 'time-card end-time');

		// Карточка длительности смены
		$start=strtotime(MEMBER()->_smena_in);
		$end=time();
		$duration_seconds=$end-$start;
		$hours=floor($duration_seconds/3600);
		$minutes=floor(($duration_seconds%3600)/60);
		$progress_percent=min(100, ($hours/12)*100);

		$progress_html='<div class="card-progress">
                         <div class="progress-bar" style="width: '.$progress_percent.'%"></div>
                       </div>';

		$this->render_dashboard_card('⏱️', 'Длительность смены', $hours.'ч '.$minutes.'м', '', 'duration-card', $progress_html);

	}

	function block_main()
	{
		ACCOUNTS()->update_member_info(MEMBER());
		$this->page_title();
		reboot_engine();
		//damp_array($member) ;

		?>
		<div id="panel_report_prepare">
		<link rel="stylesheet" type="text/css" href="<? echo _PATH_TO_EXT ?>/interface/jQuery-Countdown-Timer-Digital-Clock-Plugin-timeTo/timeTo.css" charset="utf-8">
		<script src="<? echo _PATH_TO_EXT ?>/interface/jQuery-Countdown-Timer-Digital-Clock-Plugin-timeTo/jquery.time-to.js" defer></script>

		<!-- Заголовок страницы -->
		<div class="page-header">
			<div class="header-icon">🕐</div>
			<div class="header-content">
				<h1 class="header-title">Окончание смены</h1>
				<p class="header-subtitle">Подготовка журнала за смену</p>
			</div>
		</div>

		<!-- Дашборд информации о смене -->
		<div class="dashboard-container">
			<?php $this->render_dashboard_cards(); ?>
		</div>

		<form><input type="hidden" name="report_code" value="<? echo $_SESSION['ARR_roll'][MEMBER()->rol]['report_template'] ?>">
			<input type="hidden" name="pdf_options" value="-O Landscape">
			<input type="hidden" name="filter[data_from]" value="<? echo MEMBER()->_smena_in ?>">
			<input type="hidden" name="filter[data_to]" value="<? echo date('d.m.Y H:i:s', time()) ?>">
			<input type="hidden" name="filter[doctor_id]" value="<? echo MEMBER()->id ?>">
			<!--<input type="hidden" name="filter[group_id]" value="<? echo MEMBER()->cur_group_id ?>">-->
			<input type="hidden" name="filter[dopusk][1]" value="1">
			<input type="hidden" name="filter[dopusk][2]" value="1">
			<input type="hidden" name="dont_use_member_personal_filter" value="1">

			<?
			// добавляем проверку неподписанных титулов
			$options=[] ;
			if ($GLOBALS['LS_pl_allow_active_doctor_sign_all']) $options['group_id']=MEMBER()->cur_group_id ; else $options['doctor_id']=MEMBER()->id ;
			$recs_titul_to_sign=PL()->get_packets_to_sign($options);
			if (sizeof($recs_titul_to_sign))
			{
				?>
				<div class="warning-box">
					<div class="warning-icon">⚠️</div>
					<div class="warning-content">
						<h3 class="warning-title">Требуется подписание титулов путевых листов</h3>
						<p class="warning-text">
							Перед окончанием смены необходимо подписать титулы ПЛ:
							<strong class="warning-count"><? echo sizeof($recs_titul_to_sign) ?> шт.</strong>
						</p>
						<button class="button v1 warning-button" window_title="MO_MONITOR" href="/cab/monitor/pl/?from_smenaout=1" style="position:relative;left:-20px;">Перейти к подписанию титулов</button>
					</div>
				</div>
				<?
			}
			else
			{
				?>
				<div class="success-box">
					<div class="success-icon">✅</div>
					<div class="success-content">
						<h3 class="success-title">Готовы к завершению</h3>
						<p class="success-text">
							Для окончания смены создайте и подпишите журнал за смену
						</p>
						<?
						$class_panel_button='hidden';
						if ($GLOBALS['LS_mo_now_enabled'] and 0)
						{
							$this->panel_timeout();
						}// ESMO()->copy_mo_from_now(0); убираем синхронизацию данных от аккаунта фельдшера
						else
						{
							$class_panel_button='';
						};
						?>
						<button id="smena_podpis_button" class="button v2 success-button <? echo $class_panel_button ?>" cmd="docs/doc_create">
							📄 Создать журнал
						</button>
					</div>
				</div>
				<?
			}

			?></form>

		<style type="text/css">
        /* Общие стили контейнера */
        div#panel_report_prepare {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            /*background: #f8f9fa;*/
        }

        div#panel_report_prepare button.hidden {
            display: none;
        }

        /* Заголовок страницы */
        .page-header {
            background: linear-gradient(135deg, #2c5282 0%, #2d3748 100%);
            border-radius: 8px;
            border-left: 5px solid #3182ce;
            padding: 25px 30px;
            margin-bottom: 30px;
            color: white;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .header-icon {
            font-size: 42px;
            line-height: 1;
            opacity: 0.9;
        }

        .header-content {
            flex: 1;
        }

        .header-title {
            margin: 0 0 6px 0;
            font-size: 24px;
            font-weight: 600;
            letter-spacing: -0.5px;
        }

        .header-subtitle {
            margin: 0;
            font-size: 14px;
            opacity: 0.85;
            font-weight: 400;
        }

        /* Дашборд контейнер */
        .dashboard-container {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            margin-bottom: 30px;
        }

        /* Карточки дашборда */
        .dashboard-card {
            background: white;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            border: 1px solid #e2e8f0;
            display: flex;
            flex-direction: column;
            transition: all 0.2s ease;
            position: relative;
            min-height: 140px;
        }

        .dashboard-card:hover {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            border-color: #cbd5e0;
        }

        .dashboard-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            border-radius: 8px 8px 0 0;
        }

        .card-icon-large {
            font-size: 32px;
            line-height: 1;
            margin-bottom: 12px;
            opacity: 0.7;
        }

        .card-content {
            flex: 1;
            display: flex;
            flex-direction: column;
        }

        .card-label {
            font-size: 11px;
            font-weight: 600;
            color: #718096;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 8px;
        }

        .card-value {
            font-size: 20px;
            font-weight: 600;
            color: #2d3748;
            line-height: 1.3;
            margin-bottom: 4px;
            word-wrap: break-word;
            overflow-wrap: break-word;
        }

        .card-subvalue {
            font-size: 13px;
            font-weight: 400;
            color: #718096;
            margin-top: 2px;
        }

        /* Специфичные стили для карточек */
        .user-card::before {
            background: #3182ce;
        }

        .group-card::before {
            background: #805ad5;
        }

        .start-time::before {
            background: #38a169;
        }

        .end-time::before {
            background: #dd6b20;
        }

        .duration-card::before {
            background: #0987a0;
        }

        .status-card::before {
            background: #d53f8c;
        }

        /* Прогресс-бар для длительности */
        .card-progress {
            width: 100%;
            height: 6px;
            background: #e2e8f0;
            border-radius: 3px;
            overflow: hidden;
            margin-top: 10px;
        }

        .progress-bar {
            height: 100%;
            background: #0987a0;
            border-radius: 3px;
            transition: width 1s ease-out;
        }

        /* Статус индикатор */
        .status-active {
            color: #38a169 !important;
            font-weight: 600 !important;
        }

        .status-indicator {
            margin-top: auto;
            padding-top: 8px;
        }

        .pulse-dot {
            display: inline-block;
            width: 10px;
            height: 10px;
            background: #38a169;
            border-radius: 50%;
            position: relative;
            animation: pulseGlow 2s ease-in-out infinite;
        }

        .pulse-dot::before {
            content: '';
            position: absolute;
            top: -3px;
            left: -3px;
            right: -3px;
            bottom: -3px;
            background: #38a169;
            border-radius: 50%;
            opacity: 0.3;
            animation: pulseRing 2s ease-in-out infinite;
        }

        @keyframes pulseGlow {
            0%, 100% {
                opacity: 1;
                transform: scale(1);
            }
            50% {
                opacity: 0.7;
                transform: scale(1.1);
            }
        }

        @keyframes pulseRing {
            0% {
                transform: scale(1);
                opacity: 0.3;
            }
            50% {
                transform: scale(1.5);
                opacity: 0;
            }
            100% {
                transform: scale(1);
                opacity: 0;
            }
        }

        /* Блок предупреждения */
        .warning-box {
            background: #fef3c7;
            border: 2px solid #f59e0b;
            border-left: 5px solid #d97706;
            border-radius: 8px;
            padding: 20px 25px;
            margin: 25px 0;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
            display: flex;
            align-items: flex-start;
            gap: 18px;
        }

        .warning-icon {
            font-size: 36px;
            line-height: 1;
            flex-shrink: 0;
        }

        .warning-content {
            flex: 1;
        }

        .warning-title {
            margin: 0 0 10px 0;
            color: #92400e;
            font-size: 17px;
            font-weight: 600;
        }

        .warning-text {
            margin: 0 0 18px 0;
            color: #78350f;
            font-size: 14px;
            line-height: 1.5;
        }

        .warning-count {
            color: #c2410c;
            font-size: 16px;
            font-weight: 700;
            padding: 3px 10px;
            background: white;
            border-radius: 4px;
            display: inline-block;
            margin-left: 4px;
            border: 1px solid #f59e0b;
        }

        .warning-button {
            background: #f59e0b !important;
            border: none !important;
            color: #fff !important;
            padding: 12px 24px !important;
            font-size: 14px !important;
            font-weight: 600 !important;
            border-radius: 6px !important;
            cursor: pointer !important;
            transition: all 0.2s ease !important;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1) !important;
            float: none !important;
            display: inline-flex !important;
            align-items: center !important;
            gap: 8px !important;
        }

        .warning-button:hover {
            background: #d97706 !important;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15) !important;
        }

        .warning-button:active {
            transform: translateY(1px);
        }

        /* Блок успеха */
        .success-box {
            background: #d1fae5;
            border: 2px solid #10b981;
            border-left: 5px solid #059669;
            border-radius: 8px;
            padding: 20px 25px;
            margin: 25px 0;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
            display: flex;
            align-items: flex-start;
            gap: 18px;
        }

        .success-icon {
            font-size: 36px;
            line-height: 1;
            flex-shrink: 0;
        }

        .success-content {
            flex: 1;
        }

        .success-title {
            margin: 0 0 10px 0;
            color: #065f46;
            font-size: 17px;
            font-weight: 600;
        }

        .success-text {
            margin: 0 0 18px 0;
            color: #047857;
            font-size: 14px;
            line-height: 1.5;
        }

        .success-button {
            background: #10b981 !important;
            border: none !important;
            color: #fff !important;
            padding: 12px 24px !important;
            font-size: 14px !important;
            font-weight: 600 !important;
            border-radius: 6px !important;
            cursor: pointer !important;
            transition: all 0.2s ease !important;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1) !important;
            float: none !important;
            display: inline-flex !important;
            align-items: center !important;
            gap: 8px !important;
        }

        .success-button:hover {
            background: #059669 !important;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15) !important;
        }

        .success-button:active {
            transform: translateY(1px);
        }

        /* Блок загрузки */
        .loading-box {
            background: #e0e7ff;
            border: 2px solid #6366f1;
            border-left: 5px solid #4f46e5;
            border-radius: 8px;
            padding: 30px;
            margin: 25px 0;
            text-align: center;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        }

        .loading-spinner {
            margin-bottom: 18px;
        }

        .loading-spinner img {
            width: 48px;
            height: 48px;
        }

        .loading-title {
            margin: 0 0 10px 0;
            color: #3730a3;
            font-size: 17px;
            font-weight: 600;
        }

        .loading-text {
            margin: 0 0 18px 0;
            color: #4338ca;
            font-size: 14px;
            line-height: 1.5;
        }

        .countdown-timer {
            font-size: 24px;
            font-weight: 600;
            color: #3730a3;
            padding: 12px 20px;
            background: white;
            border-radius: 6px;
            display: inline-block;
            min-width: 100px;
            box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
        }


        /* Адаптивность */
        @media (max-width: 1200px) {
            div#panel_report_prepare {
                max-width: 100%;
                padding: 20px 15px;
            }
        }

        @media (max-width: 1024px) {
            .dashboard-container {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 768px) {
            .dashboard-container {
                grid-template-columns: 1fr;
                gap: 15px;
            }

            .dashboard-card {
                min-height: 120px;
            }

            .page-header {
                padding: 20px;
            }

            .header-title {
                font-size: 20px;
            }

            .card-value {
                font-size: 18px;
            }
        }

        @media (max-width: 640px) {
            .warning-box,
            .success-box,
            .loading-box {
                padding: 18px;
                flex-direction: column;
                text-align: center;
            }
        }
		</style>
		</div><?
	}

	function panel_timeout()
	{

		?>
		<div id="panel_timeout" class="loading-box">
			<div class="loading-spinner">
				<img src="/images/loading17.gif" alt="Загрузка">
			</div>
			<h3 class="loading-title">Подготовка данных</h3>
			<p class="loading-text">Ожидайте, производится подготовка данных для формирования отчета за смену</p>
			<div id="countdown" class="countdown-timer"></div>
		</div>
		<script type="text/javascript">
        // Сообщение терминалу что страница готова.
        $j(document).ready(function () {
            function show_panel_button() {   // останавливаем таймер
                $j('#countdown').timeTo('stop');

                $j('#panel_timeout').hide();
                $j('#smena_podpis_button').show();
            }

            function start_timer() {
                $j('#countdown').timeTo({
                    seconds: 1, // перенос данных из основной в оперативную таблицу производится раз в минуту, делаем с запасом - 70 сек
                    countdown: true,
                    displayHours: 0,
                    callback: show_panel_button
                });
            }

            start_timer();
        });
		</script><?
	}

	function panel_account_info()
	{
		if (MEMBER()->id)
		{ ?>
			<div id=panel_account_info>
			<? echo $_SESSION['ARR_roll'][MEMBER()->info['rol']]['obj_name'] ?>&nbsp;
			<span class=name><? echo MEMBER()->name ?></span>
			<a href="" class="v2" cmd="account/account_logout">Выход</a>
			</div><?
		}
	}

	function panel_terminal_status(){ }


}

?>
