<?php
$__functions['init'][]='_terapevt_site_vars' ;
$__functions['boot_site'][]='_terapevt_site_boot' ;

function terapevt() {return($_SESSION['terapevt_system']);$_SESSION['terapevt_system']=new c_terapevt_system();return($_SESSION['terapevt_system']);} ;


function _terapevt_site_vars()
{
    $_SESSION['arr_terapevt_periodMO']=array(1=>'Месяц',2=>'Неделя',3=>'Квартал');

}

function _terapevt_site_boot($options)
{
  create_system_modul_obj('terapevt',$options) ;

}


class c_terapevt_system
{
    public $table_bill ;
    public $terapevt_list ;
    public $system_title ;

    function __construct($create_options=array())
    {  $this->system_title ='Цеховой терапевт';
        ENGINE()->reg_ext('esmo_ct','Цеховой терапевт') ;
    }


  function declare_menu_items_2($page)
  { // только для клиента

      $page->menu['/cab/esmo_ct/']=array('title'=>'РМЦТ',
                                         'allow_access_to_rol'=>2,
                                         'class'=>'fas fa-notes-medical'
                                        ) ;


  }

    var $rsso_name=array(0=>'Очень низкий', 1=>'Низкий', 2=>'Средний', 3=>'Высокий', 4=>'Очень высокий');
    var $priem_status=array(1=>'Вызван на прием',
                    2=>'Прием идет',
                    3=>'Прием завершен',
                    7=>'Прием отменен'
        )  ;
    var $anam=array('rost'=>'Рост',
                    'weight'=>'Вес',
                    'comment'=>'Комментарий'
        ) ;
    var $factors=array('age'=>'Возраст (мужчины от 55 лет, женщины от 65 лет)',
                    'ssz'=>'Семейный анамнез ранних сердечно-сосудистых заболеваний (у женщин менее 65 лет, у мужчин менее 55 лет)',
                    'smoking'=>'Курение',
                    'work'=>'Вредные производственные факторы',
                    'obesity'=>'Ожирение',
                    'lifestyle'=>'Малоподвижный образ жизни',
                    'dyslipidemia'=>'Дислипидемия',
                    'protein'=>'С-реактивный белок'
    ) ;
    var $factors2=array('pom'=>'Поражения органов-мишеней (ПОМ)',
                    'sd'=>'Сахарный диабет (СД)',
                    'mc'=>'Метаболический синдром (МС)',
                    'aks'=>'Ассоциированные (сопуствующие) клинические состояния (АКС)'
    ) ;
    var $recomendation=array('AD'=>'Прием препаратов, корректирующих артериальное давление',
                    'HL'=>'Прием препаратов, корректирующих уровень холестерина',
                    'VT'=>'Прием витаминов'
    ) ;
    var $recomendation2=array('smoking'=>'Отказ от курения',
                    'recovery'=>'Оздоровление образа жизни',
                    'analysis'=>'Углубленное исследование'
    ) ;
    var $select_period=array(1=>'день',
                    2=>'неделя',
                    3=>'месяц',
                    7=>'год'
    ) ;

    function get_period_name($time_start, $type, $options=array())
    {
        switch ($type) {
            case 1:
                $period = get_month_year($time_start,'month year');
                break;
            case 2:
                $no_year_word = array('no_year_word'=>true);
                $ts=getdate($time_start);
                $time_end=mktime(0,0,0,$ts['mon'],$ts['mday']+7,$ts['year'])-1;
                $ts2=getdate($time_end);
                if ($ts['mon'] == $ts2['mon'])
                {
                    $period = date('d',$time_start).' - '.get_month_year($time_end,'day month year',$no_year_word);
                } elseif ($ts['year'] == $ts2['year'])
                {
                    $period = get_month_year($time_start,'day month').' - '.get_month_year($time_end,'day month year',$no_year_word);
                } else
                    $period = get_month_year($time_start,'day month year',$no_year_word).' - '.get_month_year($time_end,'day month year',$no_year_word);
                break;
            case 3:
                $ts=getdate($time_start);
                switch ($ts['mon']) {
                    case '1': $period = 'I'; break;
                    case '4': $period = 'II'; break;
                    case '7': $period = 'III'; break;
                    case '10': $period = 'IV'; break;
                }
                $period = $period . ' квартал '.$ts['year'];
                break;
        }
        return ($period);
    }

    function get_proc($a,$b,$percent=false,$round=0)
    {   //trace() ;
        if (!$percent) {
            if (($a == 0) && ($b == 0)) {
                $c=0;
            } elseif (($a == 0) && ($b != 0)) {
                $c=100;
            } else $c=round(($b-$a)/$a*100,$round) ;
        } else {
            $c=$b-$a;
        }
        if ($c>=0) $c='+'.$c.'%' ;
        else      $c=$c.'%' ;
        return($c) ;
    }

    function get_indicator_period_stats($t1,$t2,$minMO){
        $recs_mo=$this->get_average_med_data_for_period($minMO,$t1,$t2);
        $ts=getdate($t1) ;
        $t1_Mag=mktime(0,0,0,$ts['mon']-12,1,$ts['year']) ;
        $recs_mo_cnt_uag=$this->get_UAG_cnt_data_for_perdiod($t1_Mag,$t1);
        $result['T']=count($recs_mo);
        $result['Tag']=0;
        $result['Tuag']=0;
        if (_sizeof($recs_mo)) foreach ($recs_mo as $key=>$rec) {
            if ($rec['ssd']>=140 or $rec['sdd']>=90) $result['Tag']++;
            if ($recs_mo_cnt_uag[$key]['M']>=3)
                if ($recs_mo_cnt_uag[$key]['Mag']/$recs_mo_cnt_uag[$key]['M']>=0.5) $result['Tuag']++;
        }
        $result['Kag']= ($result['T']!=0)? round($result['Tag']/$result['T']*100,2):0 ;

        return $result;
    }


    function update_ct_indicator($period_id, $debug_print=true){
        if ($debug_print) $options=array('debug'=>1);
        else $options=[];
        $ts=getdate();
        switch ($period_id){
            case 2:    $now_t1=mktime(0,0,0,$ts['mon'],$ts['mday']-7,$ts['year']) ;
                $now_t2=mktime(0,0,0,$ts['mon'],$ts['mday'],$ts['year'])-1 ;
                $prev_t1=mktime(0,0,0,$ts['mon'],$ts['mday']-14,$ts['year']) ;
                $prev_t2=$now_t1-1 ;
                $minCntMO=$GLOBALS['LS_ct_WeekMO'];
                $period_name='неделя';
                break;
            case 1:    $now_t1=mktime(0,0,0,$ts['mon']-1,$ts['mday'],$ts['year']) ;
                $now_t2=mktime(0,0,0,$ts['mon'],$ts['mday'],$ts['year'])-1 ;
                $prev_t1=mktime(0,0,0,$ts['mon']-2,$ts['mday'],$ts['year']) ;
                $prev_t2=$now_t1-1 ;
                $minCntMO=$GLOBALS['LS_ct_MonthMO'];
                $period_name='месяц';
                break;
            case 3:    $now_t1=mktime(0,0,0,$ts['mon']-3,$ts['mday'],$ts['year']) ;
                $now_t2=mktime(0,0,0,$ts['mon'],$ts['mday'],$ts['year'])-1 ;
                $prev_t1=mktime(0,0,0,$ts['mon']-6,$ts['mday'],$ts['year']) ;
                $prev_t2=$now_t1-1 ;
                $minCntMO=$GLOBALS['LS_ct_QuarterMO'];
                $period_name='квартал';
                break;
        }

        if ($debug_print) echo "<h2>Обновление индикаторов для периода - ".$period_name."</h2>";

        $now=$this->get_indicator_period_stats($now_t1,$now_t2,$minCntMO);
        if ($debug_print) echo "Текущий период от ".date('d.m.Y H:i',$now_t1)." до ".date('d.m.Y H:i',$now_t2)."<br>";
        if ($debug_print) echo "Кол-во сотрудинков ".$now['T'].", Группа риска ".$now['Tag'].", Постоянная АГ ".$now['Tuag']."<br><br>";

        $prev=$this->get_indicator_period_stats($prev_t1,$prev_t2,$minCntMO);
        if ($debug_print) echo "Текущий период от ".date('d.m.Y H:i',$prev_t1)." до ".date('d.m.Y H:i',$prev_t2)."<br>";
        if ($debug_print) echo "Кол-во сотрудинков ".$prev['T'].", Группа риска ".$prev['Tag'].", Постоянная АГ ".$prev['Tuag']."<br><br>";

        if ($now['T']) {
            if (_sizeof(execSQL('select * from obj_site_ct_stats where clss=264 and type='.$period_id.' and period_type=0',$options))) {
                update_rec_in_table('obj_site_ct_stats',array('cnt_personals'=>$now['T'],'cnt_gr'=>$now['Tag'],'cnt_stable_gr'=>$now['Tuag']),'clss=264 and type='.$period_id.' and period_type=0',$options) ;
            } else {
                execSQL_update('insert into obj_site_ct_stats (clss,type,period_type,cnt_personals,cnt_gr,cnt_stable_gr) values(264,'.$period_id.',0,'.$now['T'].','.$now['Tag'].','.$now['Tuag'].')',$options);
            }
        }
        if ($prev['T']) {
            if (_sizeof(execSQL('select * from obj_site_ct_stats where clss=264 and type='.$period_id.' and period_type=1',$options))) {
                update_rec_in_table('obj_site_ct_stats',array('cnt_personals'=>$prev['T'],'cnt_gr'=>$prev['Tag'],'cnt_stable_gr'=>$prev['Tuag']),'clss=264 and type='.$period_id.' and period_type=1',$options) ;
            } else {
                execSQL_update('insert into obj_site_ct_stats (clss,type,period_type,cnt_personals,cnt_gr,cnt_stable_gr) values(264,'.$period_id.',1,'.$prev['T'].','.$prev['Tag'].','.$prev['Tuag'].')',$options);
            }
        }
    }

    function get_last_period_of_stats($type){
        $mo_info=execSQL_van('select min(c_data) as min_data,max(c_data) as max_data from obj_site_mo_session') ;
        $info=array() ;
        $stats_info=execSQL_van('select max(c_data) as max_data from obj_site_ct_stats where clss=261 and type='.$type) ;
        $t1=($stats_info['max_data'])? $stats_info['max_data']:$mo_info['min_data'] ;
        $t2=$mo_info['max_data'] ;
        $info['MO min data:']=date('d.m.Y H:i:s',$mo_info['min_data']) ;
        $info['MO max data:']=date('d.m.Y H:i:s',$mo_info['max_data']) ;
        $info['STATS max data:']=date('d.m.Y H:i:s',$stats_info['max_data']) ;
        $info['FROM:']=date('d.m.Y H:i:s',$t1) ;
        $info['TO:']=date('d.m.Y H:i:s',$t2) ;
        //damp_array($info,1,-1) ;
        //t1 - дата начала текущего периода (или дата первого медосмотра)
        //t2 - дата последнего медосмотра
        return(array($t1,$t2)) ;
    }

    function save_stats($type,$t1,$t2)
    {
        switch ($type) {
            case 1: $minCntMO=$GLOBALS['LS_ct_MonthMO'];  break;
            case 2: $minCntMO=$GLOBALS['LS_ct_WeekMO'];  break;
            case 3: $minCntMO=$GLOBALS['LS_ct_QuarterMO'];  break;
        }

        $ts=getdate($t1) ;
        $t1_Mag=mktime(0,0,0,$ts['mon']-12,1,$ts['year']) ;
        //добавить проверку на изменение значимого кол-ва МО
        $recs_mo=$this->get_average_med_data_for_period($minCntMO,$t1,$t2);
        $recs_mo_cnt_uag=$this->get_UAG_cnt_data_for_perdiod($t1_Mag,$t1);
        $recs_mo_cnt=execSQL('select personal_id,mo_cnt as current_mo_cnt, minmo_cnt as current_minmo_cnt
                            from obj_site_ct_stats
                            where c_data='.$t1.' and type='.$type);

        if (_sizeof($recs_mo)) foreach($recs_mo as $key=>$rec)
        {
            if ($rec['ssd']<0) $rec['ssd']=0 ;
            if ($rec['sdd']<0) $rec['sdd']=0 ;
            if ($rec['sp']<0)  $rec['sp']=0 ;
            $gr=($rec['ssd']>=140 or $rec['sdd']>=90)? 1:0 ;
            if (!$recs_mo_cnt_uag[$key]['Mag']) $recs_mo_cnt_uag[$key]['Mag']=0;

            if (!$recs_mo_cnt_uag[$key]['M']) $recs_mo_cnt_uag[$key]['M']="NULL";

            if ($recs_mo_cnt_uag[$key]['M']>=3) {
                $Kuag = $recs_mo_cnt_uag[$key]['Mag']/$recs_mo_cnt_uag[$key]['M'];
            } else {
                $Kuag = "NULL";
            }
            //если обновленное кол-во МО не совпадает с текущим или значимое кол-во МО не совпадает стекущим, то обновляем данные по сотруднику
            if (($rec['cnt_mo'] != $recs_mo_cnt[$key]['current_mo_cnt']) || ($minCntMO != $recs_mo_cnt[$key]['current_minmo_cnt']))
            {   execSQL_update('delete from obj_site_ct_stats where clss=261 and c_data='.$t1.' and type='.$type.' and personal_id='.$rec['member_id']) ;
                execSQL_update('insert into obj_site_ct_stats (clss,c_data,type,personal_id,ssd,sdd,sp,gr,Mag,M,Kuag,mo_cnt,minmo_cnt) values(261,'.$t1.','.$type.','.$rec['member_id'].
                    ','.$rec['ssd'].','.$rec['sdd'].','.$rec['sp'].','.$gr.','.$recs_mo_cnt_uag[$key]['Mag'].','.$recs_mo_cnt_uag[$key]['M'].
                    ','.$Kuag.','.$rec['cnt_mo'].','.$minCntMO.')') ;
            }
        }
        return(_sizeof($recs_mo)) ;
    }

    function update_stats_and_indicator_month()
    {
        $this->update_stats(1);
        $this->update_ct_indicator(1, false);
    }

    function update_stats_and_indicator_week()
    {
        $this->update_stats(2);
        $this->update_ct_indicator(2, false);
    }

    function update_stats_and_indicator_quarter()
    {
        $this->update_stats(3);
        $this->update_ct_indicator(3, false);
    }

    function update_stats($type)
    {
        list($t_from,$t_to)=$this->get_last_period_of_stats($type) ;
        $t=$t_from ;  $arr_date=array() ;
        switch ($type){
            case 1: {
                while($t<$t_to)
                {   $ts=getdate($t) ;
                    $t1=mktime(0,0,0,$ts['mon'],1,$ts['year']) ;
                    $arr_date[date('d.m.Y',$t1)]['from']=date('d.m.Y H:i:s',$t1) ;
                    $t2=mktime(0,0,0,$ts['mon']+1,1,$ts['year'])-1 ;
                    $arr_date[date('d.m.Y',$t1)]['to']=date('d.m.Y H:i:s',$t2);
                    $t=$t2+1 ;
                    $arr_date[date('d.m.Y',$t1)]['count']=$this->save_stats($type,$t1,$t2) ;
                }
                break;
            }
            case 2: {
                while($t<$t_to)
                {   $ts=getdate($t) ;
                    $dw=($ts['wday'])? $ts['wday']-1:6 ;
                    $t1=mktime(0,0,0,$ts['mon'],$ts['mday']-$dw,$ts['year']) ;
                    $arr_date[date('d.m.Y',$t1)]['from']=date('d.m.Y H:i:s',$t1) ;
                    $t2=mktime(0,0,0,$ts['mon'],$ts['mday']-$dw+7,$ts['year'])-1 ;
                    $arr_date[date('d.m.Y',$t1)]['to']=date('d.m.Y H:i:s',$t2);
                    $t=$t2+1 ;
                    $arr_date[date('d.m.Y',$t1)]['count']=$this->save_stats($type,$t1,$t2) ;
                }
                break;
            }
            case 3: {
                while($t<$t_to)
                {   $ts=getdate($t) ;
                    switch ($ts['mon'] % 3) {
                        case 1:
                            $mon = $ts['mon']; break;
                        case 2:
                            $mon = $ts['mon']-1; break;
                        case 0:
                            $mon = $ts['mon']-2; break;
                    }
                    $t1=mktime(0,0,0,$mon,1,$ts['year']) ;
                    $arr_date[date('d.m.Y',$t1)]['from']=date('d.m.Y H:i:s',$t1) ;
                    $t2=mktime(0,0,0,$mon+3,1,$ts['year'])-1 ;
                    $arr_date[date('d.m.Y',$t1)]['to']=date('d.m.Y H:i:s',$t2);
                    $t=$t2+1 ;
                    $arr_date[date('d.m.Y',$t1)]['count']=$this->save_stats($type,$t1,$t2) ;
                }
                break;
            }
        }
    }

    function get_average_med_data_for_period($minCountME,$timeStart,$timeStop) {
        //получение кол-во МО и средних показательей ССД/СДД/Пульса сотрудников за указанный период, кроме тех у кого кол-во МО меньше заданного
        $result=execSQL('select vms.member_id,count(vms.pkey) as cnt_mo,avg(vms.systolic) as ssd,avg(vms.diastolic) as sdd, avg(vms.pulse) as sp
                        from obj_site_mo_session vms
                        where vms.status in (2,3) and (vms.tk=0 or vms.tk is null) and vms.mo_type in (1,2) and vms.terminal_id>0 and vms.c_data>='.$timeStart.' and vms.c_data<='.$timeStop. ' and vms.systolic>0 and vms.diastolic>0 and vms.pulse>0
                        group by vms.member_id
                        having count(vms.pkey)>='.$minCountME);
        return $result;
    }

    function get_UAG_cnt_data_for_perdiod($timeFrom,$timeTo) {
        //получение данных для коэф. устойчивости АГ
        //общее кол-во месячных периодов и кол-во месячных периодов в которых (ССД>=140 или СДД>=90) в заданном промежутке
        $result=execSQL('select tm.personal_id,count(tm.pkey) as M, tmag.Mag
                                from obj_site_ct_stats tm
                                left join
                                  (select personal_id,count(pkey) as Mag
                                    from obj_site_ct_stats
                                    where type=1 and c_data>='.$timeFrom.' and c_data<='.$timeTo.' and (ssd>=140 or sdd>=90)
                                    group by personal_id) tmag
                                on tmag.personal_id = tm.personal_id
                                where tm.type=1 and tm.c_data>='.$timeFrom.' and tm.c_data<='.$timeTo.' group by tm.personal_id, tmag.Mag');
        return $result;
    }

}



?>
