<?php

$__functions['init'][]='_poll_site_vars' ;
$__functions['boot_site'][]='_poll_site_boot' ;

function POLL() {
  if (isset($_SESSION['poll_system'])) {
    return($_SESSION['poll_system']);
  } else {
    $_SESSION['poll_system']=new c_poll_system();
    return($_SESSION['poll_system']);
  }
}


function _poll_site_vars()
{
    $_SESSION['init_options']['poll']['debug']=0 ;
}

function _poll_site_boot($options)
{
  create_system_modul_obj('poll',$options) ;

}


class c_poll_system
{

	public $view_session ;
    public $view_session_now ;

	// ВНИМАНИЕ! При добавлении новых статусов откр
   var $arr_session_status=array(0=>'',
                            1=>'Опросы начат',
                            2=>'Опросы пройден',
                            3=>'Опросы подписан',
                            4=>'Опросы прерван',
                           ) ;

   var $arr_session_failed_status=array(''=>'Неизвестная ошибка',
                                        'equipmentError'=>'Не удалось провести измерение',
                                        'cancelButton'=>'Отмена измерения',
                                        'cancelTimeout'=>'Превышено время отведенное на проведение МО',
                                        'intrusion'=>'Требуется подтверждение личности',
                                        'noAutorize'=>'Ошибка авторизации',
                                        'unknownTerminal'=>'Терминал не зарегистрирован в системе',
                                        'SeansDubl'=>'Сеанс МО начат на другом терминале',
	 ) ;

	var $arr_kz_method=[1=>'Через терминал МО/КЗ',
	                       2=>'Только через терминал МО',
	                       3=>'Только через терминал КЗ',
	                       4=>'по ссылке на email',
	                      ] ;



    var $arr_events_close_period=[1=>'Нет',2=>'Ежемесячное',3=>'Ежеквартальное',4=>'Ежегодное',5=>'ТЕСТ: ежедневное',6=>'ТЕСТ: ежечасное'] ;
    var $arr_events_close_status=[2=>'Пока не будет задан каждый вопрос по одному разу'] ;

    var $arr_pass_status=array(0=>'',
                              1=>'Подлежит опросу',
                              2=>'Опрос пройден частично',
                              3=>'Опрос пройден',
                              ) ;

    function __construct($create_options=array())
    {
	    ENGINE()->reg_ext('poll','Опросы')  ;
	    ENGINE()->reg_ext('events_poll','Опросы - мероприятия')  ;

	    $this->view_session ='view_poll_session' ;
        $this->view_session_now ='view_poll_sessions' ;

	    $this->table_session ='poll_session' ;
        $this->table_session_now ='poll_sessions' ;
    }

	function declare_menu_items_1($page)
       {
        $page->menu['/cab/poll/']=array('title'=>'Опросы','class'=>'fas fa-user-graduate','items'=>array('/cab/poll/'=>'Настройка'));
       }

	function get_theme_by_id($id)
	{
	  $rec=execSQL_van('select t1.*,t2.obj_name as manual,t2.pkey as text_id,t2.comment,t2.json_data,t2.ext_info 
                      from poll_themes t1
                      left join poll_themes_text t2 on t2.parent=t1.pkey
                      where t1.pkey='.$id) ;
	  $this->prepare_public_info_to_theme($rec);
	  return($rec) ;
	}

	function get_known_by_uid($id)
	{
	  $rec=execSQL_van('select t1.*,t2.obj_name as manual,t2.comment 
                      from poll_themes t1
                      left join poll_themes_text t2 on t2.parent=t1.pkey
                      where t1.uid="'.$id.'"') ;
	  //$this->prepare_public_info_to_theme($rec);
	  return($rec) ;
	}

	function get_child_sections($id,$append_self=0)
  {
      $level=execSQL_value('select level from poll_themes where pkey='.$id) ;
      $ids=execSQL_line('select pkey from poll_themes where parent'.$level.'='.$id) ;
      if ($append_self) $ids[]=$id ;
      return($ids) ;
  }

  // получаем объединнный фильтр выборки персонала по себе и дочерним объектам
  function get_union_child_filter_select_personals($section_id)
  { $filter_section=[] ;
    // получаем все фильтры всех дочерних разделов и свой
    $arr_sections_ids=POLL()->get_child_sections($section_id,1) ;
    $recs=execSQL('select pkey,filter from poll_themes where pkey in ('.implode(',',$arr_sections_ids).') and filter!=""') ;
    if (_sizeof($recs)) foreach($recs as $rec) $filter_section[$rec['pkey']]=json_decode($rec['filter'],true) ;
    return($filter_section) ;

  }

	function prepare_public_info_to_theme(&$rec)
  {
      $rec['__href']='/window/poll/theme/card/'.$rec['pkey'].'/' ;
      //  получаем условия отбора родительского раздела
      $arr=[] ;
      for ($i=1;$i<=9;$i++) if ($rec['parent'.$i]) $arr[]=$rec['parent'.$i] ;
      if (_sizeof($arr))
          { $recs=execSQL('select * from poll_themes where pkey in ('.implode(',',$arr).') order by level desc') ;
            if (_sizeof($recs)) foreach($recs as $rec_parent) if ($rec_parent['viewer_name'])
            { $rec['parent_filter']=$rec_parent['filter'] ;
              $rec['parent_usl_select']=$rec_parent['usl_select'] ;
              $rec['parent_info_filter']=$rec_parent['info_filter'] ;
              $rec['parent_viewer_name']=$rec_parent['viewer_name'] ;
              break ;
            }
          }
      //  если не заданы условия отбора сотрудников - надо взять их у родительского раздела
      if (!$rec['viewer_name'] and $rec['parent_viewer_name']) $rec['viewer_name']=$rec['parent_viewer_name'] ;
      if (!$rec['filter'] and $rec['parent_filter']) $rec['filter']=$rec['parent_filter'] ;
      if (!$rec['usl_select'] and $rec['parent_usl_select']) $rec['usl_select']=$rec['parent_usl_select'] ;
      if (!$rec['info_filter'] and $rec['parent_info_filter']) $rec['info_filter']=$rec['parent_info_filter'] ;

      $rec['_ext_info']=($rec['ext_info'])?  json_decode($rec['ext_info'],true):[];
  }

	function get_theme_name_by_id($id)
	{
	  $value=execSQL_value('select obj_name from poll_themes where pkey='.$id) ;
	  return($value) ;
	}

	function get_theme_name_by_ids($ids)
	{
	  $arr=execSQL_line('select obj_name from poll_themes where pkey in ('.$ids.')') ;
	  if (_sizeof($arr)) $value=implode(', ',$arr) ; else $value='' ;
	  return($value) ;
	}

	function get_tiket_by_id($id)
	{
	  $rec=execSQL_van('select * from poll_questions where pkey='.$id) ;
	  return($rec) ;
	}

	function get_question_by_id($id)
	{
	  $rec=execSQL_van('select * from poll_questions where pkey='.$id) ;
	  return($rec) ;
	}

	function get_questions_by_ids($ids)
	{
	  $rec=execSQL('select * from poll_questions where pkey in ('.$ids.')',0,1) ;
	  return($rec) ;
	}

	function get_answers_by_question_id($id)
    {
        $rec=execSQL('select * from poll_answers where question_id in ('.$id.') order by indx',0,1) ;
        return($rec) ;
    }

	function get_contents_by_question_id($id)
    {
        $rec=execSQL('select * from poll_content where question_id in ('.$id.') order by indx',0,1) ;
        return($rec) ;
    }

	function get_section_theme($id)
    {
        $recs=execSQL('select * from poll_themes where parent2='.$id.' order by indx') ;
        return($recs) ;
    }

	// заполняет поля parent1,parent3,parent3... для item
    function full_parent_levels_to_rec(&$data)
    {  $rec_parent_section=execSQL_van('select pkey,level,parent,parent1,parent2,parent3,parent4,parent5,parent6,parent7,parent8,parent9 from poll_themes where pkey='.$data['parent']) ;    // echo 'parent_level='.$rec_parent_section['level'].'<br>' ;
       if ($rec_parent_section['parent']) for ($i=1;$i<$rec_parent_section['level'];$i++)  $data['parent'.$i]=$rec_parent_section['parent'.$i] ;
       else $data['parent1']=1 ;
       $data['parent'.$rec_parent_section['level']]=$data['parent'] ;
       $data['level']=$rec_parent_section['level']+1 ;
    }

	function section_create($data)
	 { if (!isset($data['clss'])) $rec['clss']=472 ;
	   $rec['parent']=($data['parent'])? $data['parent']:1 ;
	   $rec['obj_name']=$data['name'] ;
     $rec['event_id']=($data['event_id'])? $data['event_id']:0;
     $rec['uid']=($data['uid'])? $data['uid']:'';
     $rec['account_id']=($data['account_id'])? $data['account_id']:0;
	   $this->full_parent_levels_to_rec($rec);
	   //damp_array($rec,1,-1);
	   $id=adding_rec_to_table('poll_themes',$rec) ;
	   // сохраняем поля manual и comment
	   $this->section_save($id,$data);
	   LOGS()->reg_log('poll_edit','Добавлена новая тема/раздел :'.$rec['obj_name'].', в раздел ID: '.$rec['parent']) ;
	   return($id) ;
	 }

	function section_save($id,$data)
	 { $rec=array() ;
	   $rec_poll=$this->get_theme_by_id($id) ;
	   if (isset($data['clss'])) $rec['clss']=$data['clss'] ;
	   if (isset($data['uid'])) $rec['uid']=$data['uid'] ;
	   if (isset($data['enabled'])) $rec['enabled']=($data['enabled'])? 1:0 ;
	   if (isset($data['account_id'])) $rec['account_id']=$data['account_id'] ;
	   if (isset($data['name'])) $rec['obj_name']=$data['name'] ;
	   if (isset($data['date_from'])) $rec['date_from']=($data['date_from'])? strtotime($data['date_from']):0;
	   if (isset($data['date_to'])) $rec['date_to']=($data['date_to'])? strtotime($data['date_to'].' 23:59:59'):0;
	   if (isset($data['group_ids'])) $rec['group_ids']=(_sizeof($data['group_ids']))? implode(',',$data['group_ids']):'';
	   if (isset($data['moment'])) $rec['moment']=($data['moment'])? $data['moment']:0;
	   if (isset($data['allow_days'])) $rec['allow_days']=($data['allow_days'])? $data['allow_days']:0;
	   if (isset($data['question_count'])) $rec['question_count']=($data['question_count'])? $data['question_count']:0;
		 if (isset($data['event_id'])) $rec['event_id']=($data['event_id'])? $data['event_id']:0;
	   // временно, до перехода на новую систему отбора сотрудников
     if (isset($data['filter'])) $rec['filter']=($data['filter'])? $data['filter']:'';
     if (isset($data['usl_select'])) $rec['usl_select']=($data['usl_select'])? $data['usl_select']:'';
     if (isset($data['info_filter'])) $rec['info_filter']=($data['info_filter'])? $data['info_filter']:'';
     if (isset($data['viewer_name'])) $rec['viewer_name']=($data['viewer_name'])? $data['viewer_name']:'';
     update_rec_in_table('poll_themes',$rec,'pkey='.$id) ;
	 }

	function question_create($parent_id,$rec)
	 { $rec['clss']=473 ;
	   //$rec['account_id']=MEMBER()->id ;
	   //$rec['c_data']=ti ;
	   $rec['parent']=$parent_id ;
       //$theme_id=execSQL_value('select parent2 from poll_themes where pkey='.$parent_id) ;
	   //$rec['theme_id']=$theme_id ;
	   //$rec['obj_name']=$question_text ;
	   //$rec['comment']=$data['comment'] ;
		 //damp_array($rec,1,-1) ;
     if (!$rec['timeout']) $rec['timeout']=0 ;
     $this->full_parent_levels_to_rec($rec);
	   $id=adding_rec_to_table('poll_questions',$rec) ;
	   return($id) ;
	 }
	function answers_create($question_id,$rec)
	 { $rec['clss']=474 ;
	   //$rec['account_id']=MEMBER()->id ;
	   //$rec['c_data']=ti ;
	   $rec['parent']=$question_id ;
	   $rec['question_id']=$question_id ;
	   //$rec['obj_name']=$answers_text ;
	   //$rec['status']=($answers_status)? 1:0 ;
	   $id=adding_rec_to_table('poll_answers',$rec) ;
	   return($id) ;
	 }

	 function known_create($section_id,$data)
	 {
	   $rec['clss']=481 ;
	   $rec['parent']=$section_id ;
	   $rec['enabled']=1 ;
	   $rec['obj_name']=$data['name'] ;
     $rec['section_id']=$data['section_id'] ;
     //$rec['select_from']=$data['select_from'] ;
     //$rec['select_to']=$data['select_to'] ;
     $this->full_parent_levels_to_rec($rec);
     //damp_array($rec,1,-1);
	   if ($data['id'])
     {   $id=$data['id'] ;
         update_rec_in_table('poll_themes',$rec,'pkey='.$id) ;
     }
	   else $id=adding_rec_to_table('poll_themes',$rec) ;

	   $rec=[] ;
     $rec['clss']=482 ;
     $rec['parent']=$id ;
     $rec['obj_name']=$data['manual'] ;
     $rec['json_data']=$data['json_data'] ;
     //damp_array($rec,1,-1);
     adding_rec_to_table('poll_themes_text',$rec) ;

	   return($id) ;
	 }

	 function known_precreate()
	 {
	   $rec['clss']=481 ;
	   $rec['parent']=0 ;
	   $rec['enabled']=0 ;
	   $id=adding_rec_to_table('poll_themes',$rec) ;

	   return($id) ;
	 }



    // возвращает в массиве размер и тип файла $file_dir
    // если передан параметр $show_info=1, выводится сообщение данными

    function get_small_file_info($file_dir,$options=array())
    {  $size_info=filesize($file_dir) ;
       if ($options['view_upload']) echo 'Размер файла <span class=green>'.format_size($size_info).'</span>' ;
       $file_type=mime_content_type($file_dir) ;
       if ($options['view_upload']) {if ($file_type) echo ', формат файла: <span class="black bold">'.$file_type.'</span><br>' ; else echo '<br>' ;}
       return(array($size_info,$file_type)) ;
    }

    // фото/видео билета храниться в директориях по номеру раздела билета, имя файла - начинается с  ID билета
	 function tiket_content_create($tiket_id,$fname)
	 { $parent=execSQL_value('select parent from poll_questions where pkey='.$tiket_id) ;
	   $source_fname=_TEMP_DIR.$fname ;
	   $target_dir=_DIR_TO_ROOT.'/storage/poll/'.$parent.'/' ;
	   $target_fname=$target_dir.safe_file_names($tiket_id.'_'.basename($fname)) ;
	   if (!file_exists($target_dir)) create_dir($target_dir) ;
	   if (file_exists($target_fname)) unlink($target_fname) ;
	   copy($source_fname,$target_fname) ;

	   $rec['clss']=475 ;
       //$rec['account_id']=MEMBER()->id ;
       $rec['parent']=$tiket_id ;
       $rec['question_id']=$tiket_id ;
       $rec['obj_name']=$fname ;
       $rec['file_name']=basename($target_fname) ;
       $rec['dir']=hide_server_dir($target_dir) ;
        list($size_info,$file_type)=$this->get_small_file_info(_TEMP_DIR.$fname) ;
       $rec['type']=$file_type ;
       $rec['size']=$size_info ;
       //$rec['comment']=$data['comment'] ;
       $id=adding_rec_to_table('poll_content',$rec) ;
       return($id) ;
	 }

	function tiket_create($parent_id,$rec_question,$recs_answers,$arr_files)
    {   $_errors=array() ; $result=array() ; $cnt_answer=0 ;$cnt_correct=0 ;
        if (!$rec_question['obj_name']) $_errors[]='Не задан текст вопроса' ;
        if (_sizeof($recs_answers)) foreach($recs_answers as $rec_answer)
        { if ($rec_answer['obj_name']) $cnt_answer++ ;
          //if ($rec_answer['status'])   $cnt_correct++ ;
        }
        //if (!$cnt_answer) $_errors[]='Не задано ни одного ответа' ;
        //if (!$cnt_correct) $_errors[]='Не указан правильный ответ' ;

        if (!_sizeof($_errors))
        { $tiket_id=$this->question_create($parent_id,$rec_question) ;
          if (_sizeof($recs_answers)) foreach($recs_answers as $rec_answer) if ($rec_answer['obj_name']) $this->answers_create($tiket_id,$rec_answer) ;
          if (_sizeof($arr_files)) foreach($arr_files as $content_temp_fname) $this->tiket_content_create($tiket_id,$content_temp_fname) ;
          $result['success']=1 ;
          $result['tiket_id']=$tiket_id ;
        }
        else $result['error']=implode('<br>',$_errors) ;
        return($result) ;
	}

    function tiket_save($tiket_id,$rec_question,$recs_answers,$arr_contents,$arr_files)
    {
        $_errors=array(); $result=array(); $cnt_answer=0; $cnt_correct=0;
        if(!$rec_question['obj_name']) $_errors[]='Не задан текст вопроса';
        if(_sizeof($recs_answers)) foreach($recs_answers as $rec_answer)
        {
            if($rec_answer['obj_name']) $cnt_answer++;
            //if($rec_answer['status']) $cnt_correct++;
        }
        if(!$cnt_answer) $_errors[]='Не задано ни одного вопроса';
        //if(!$cnt_correct) $_errors[]='Не указан правильный ответ';

        if(!_sizeof($_errors))
        {
            update_rec_in_table('poll_questions',$rec_question,'pkey='.$tiket_id);
            if(_sizeof($recs_answers)) foreach($recs_answers as $answer_id=>$rec_answer) if($answer_id>0)
            {
                if($rec_answer['obj_name']) update_rec_in_table('poll_answers',$rec_answer,'pkey='.$answer_id);
                else                        execSQL_update('delete from poll_answers where pkey='.$answer_id) ;

            }
            if(_sizeof($arr_files)) foreach($arr_files as $content_temp_fname) $this->tiket_content_create($tiket_id,$content_temp_fname);
            if(_sizeof($arr_contents)) foreach($arr_contents as $content_id=>$rec_content) if($rec_content['delete']) execSQL_update('delete from poll_content where pkey='.$content_id);
            $result['success']=1;
        }
        else $result['error']=implode('<br>',$_errors);

        return ($result);
    }

    function tiket_delete($theme_id,$section_id,$tiket_ids)
    {
        ob_start();
        $rec_theme=POLL()->get_theme_by_id($theme_id);
        echo 'Тема: <strong>'.$rec_theme['obj_name'].'</strong> [ID '.$rec_theme['pkey'].']<br>';
        $rec_section=POLL()->get_theme_by_id($section_id);
        echo 'Раздел: <strong>'.$rec_section['obj_name'].'</strong> [ID '.$rec_section['pkey'].']<br>';

        $arr_ids=explode(',',$tiket_ids);
        if(_sizeof($arr_ids)) foreach($arr_ids as $id)
        {   // удаляем дочерние объекты - вопросы ответы билеты
            echo 'Удаляем билет ID <strong>'.$id.'</strong>: ';
            $rec_tiket=POLL()->get_tiket_by_id($id);
            if($rec_tiket['pkey'])
            {
                $cnt=execSQL_update('delete from poll_answers where question_id='.$rec_tiket['pkey']);
                echo '<strong>'.$cnt.'</strong> ',get_case_by_count_1_2_5($cnt,['ответ','ответа','ответов']).' ';
                $cnt=execSQL_update('delete from poll_content where question_id='.$rec_tiket['pkey']);
                echo '<strong>'.$cnt.'</strong> ',get_case_by_count_1_2_5($cnt,['изображение','изображения','изображений']).' ';
                $cnt=execSQL_update('delete from poll_questions where pkey='.$rec_tiket['pkey']);
                echo '<strong>'.$cnt.'</strong> ',get_case_by_count_1_2_5($cnt,['билет','билета','билетов']).' ';
                echo '<span class="green">OK</span><br>';
            }
        }
        $text=ob_get_clean();
        echo $text ;

        LOGS()->reg_log('POLL',$text,array('reffers'=>[$rec_theme['_reffer'],$rec_section['_reffer']]));
    }



	function update_stats()
	 {
	     $stats=execSQL_van('select count(*) as cnt,min(c_data) as date_from,max(c_data) as date_to from poll_result') ;
		 echo 'Первый день контроля знаний: '.date('d.m.Y',$stats['date_from']).'<br>' ;
		 echo 'Последний день контроля знаний: '.date('d.m.Y',$stats['date_to']).'<br>' ;
		 echo 'Число записей по контролю знаний: '.$stats['cnt'].'<br>' ;

	//     execSQL_update('delete from poll_stats') ;
		 $last_day_of_stats=execSQL_value('select max(day) from poll_stats') ;
		 if ($last_day_of_stats)
		 {  echo 'Последний день собранной статистики: '.date('d.m.Y',$last_day_of_stats).'<br>' ;
		 	$t=getdate($last_day_of_stats) ;
		    $last_day_of_stats=mktime(0,0,0,$t['mon'],$t['mday']+1,$t['year']);  // в статистике дата ставиться началом дня
		 }

		 $data_from=($last_day_of_stats)? $last_day_of_stats:$stats['date_from'] ;


	     $t=getdate($data_from) ;
		 $from=mktime(0,0,0,$t['mon'],$t['mday'],$t['year']);
		 $t=getdate($stats['date_to']) ;
		 $to=mktime(0,0,0,$t['mon'],$t['mday'],$t['year'])-1;
		 echo 'Будет собрана статистика с : <strong>'.date('d.m.Y',$data_from).'</strong> по <strong>'.date('d.m.Y',$to).'</strong><br>' ;
		 $t=$from ;  $i=0 ;
		 $cnt=execSQL_value('select count(*) as cnt from poll_result where c_data>='.$data_from.' and c_data<'.$to) ;
		 if ($cnt)


		 while($t<=$to)
		 {  $t2=$t+60*60*24 ;
		 	echo 'Обрабатываем день <strong>'.date('d.m.Y',$t).'</strong><br>' ;
		 	$cnt=execSQL_value('select count(*) from poll_result where c_data>='.$t.' and c_data<'.$t2) ;
		 	//echo 'Будет обработано <strong>'.$cnt.'</strong> записей по контролю знаний<br>' ;

		 	$stats=execSQL('select t2.parent as dep_id,t2.working,t1.question_id,t1.correct,count(t1.pkey) as cnt_questions
								from poll_result t1
								left join obj_site_personals t2 on t2.pkey=t1.personal_id 
								where t1.c_data>='.$t.' and t1.c_data<'.$t2.'
								group by t2.parent,t2.working,t1.question_id,t1.correct
								order by t2.parent,t2.working,t1.question_id,t1.correct
								',0,1) ;
			//echo 'Получено <strong>'.$cnt.'</strong> записей статистки<br>' ;
			 $result=array() ;
		 	if (_sizeof($stats)) foreach($stats as $stat)
		    { $result[$stat['dep_id']][$stat['working']][$stat['question_id']]['all']+=$stat['cnt_questions'] ;
		      if ($stat['correct']) $result[$stat['dep_id']][$stat['working']][$stat['question_id']]['correct']+=$stat['cnt_questions'] ;
		    }

		 	//damp_array($result,1,-1) ;

		 	$cur_time=getdate($t) ;
		 	$year=mktime(0,0,0,1,1,$cur_time['year']);
		 	$month=mktime(0,0,0,$cur_time['mon'],1,$cur_time['year']);
		 	$day=mktime(0,0,0,$cur_time['mon'],$cur_time['mday'],$cur_time['year']);

		 	foreach($result as $dep_id=>$arr_workers)
		 	  foreach($arr_workers as $work_id=>$arr_questions)
		 	    foreach($arr_questions as $question_id=>$arr_result)
		          multiSQL_insert('poll_stats')->append(array( 'clss'=>477,
					                                           'indx'=>1,
					                                           'year'=>$year,
					                                           'month'=>$month,
					                                           'day'=>$day,
					                                           'dep_id'=>$dep_id,
					                                           'work_id'=>$work_id,
					                                           'question_id'=>$question_id,
					                                           'cnt_all'=>($arr_result['all'])? $arr_result['all']:0,
					                                           'cnt_correct'=>($arr_result['correct'])? $arr_result['correct']:0
				                                         )) ;



		 	$t=$t2 ;  $i++ ;
			//if ($i>4) break ;
		 }
		 else echo 'В данном периоде нет результатов ответов<br>' ;

		 multiSQL_insert('poll_stats')->flush() ;
	 }


	function theme_export($theme_id)
	{  $rec_theme=POLL()->get_theme_by_id($theme_id) ; $recs_answers=[] ; $recs_content=[] ;
	   if (!$rec_theme['pkey']) return(array('error'=>'Тема не найдена'));
	   $recs_sections=execSQL('select * from poll_themes where parent'.$rec_theme['level'].'='.$rec_theme['pkey']) ;
	   $recs_questions=execSQL('select * from poll_questions where parent'.$rec_theme['level'].'='.$rec_theme['pkey']) ;
	   if (_sizeof($recs_questions))
     { $recs_answers=execSQL('select * from poll_answers where parent in ('.implode(',',array_keys($recs_questions)).')') ;
	     $recs_content=execSQL('select * from poll_content where parent in ('.implode(',',array_keys($recs_questions)).')') ;
     }
	   $result['thema']=array('id'=>$rec_theme['pkey'],'name'=>$rec_theme['obj_name'])  ;
	   if (_sizeof($recs_sections)) foreach($recs_sections as $id=>$rec) $result['sections'][$id]=array('name'=>$rec['obj_name'],'parent'=>$rec['parent']) ;
	   if (_sizeof($recs_questions)) foreach($recs_questions as $id=>$rec) $result['tikets'][$id]=array('text'=>$rec['obj_name'],'section_id'=>$rec['parent'],'timeout'=>$rec['timeout']) ;
	   if (_sizeof($recs_answers)) foreach($recs_answers as $id=>$rec) $result['answers'][$id]=array('indx'=>$rec['indx'],'text'=>$rec['obj_name'],'tiket_id'=>$rec['parent'],'status'=>$rec['status']) ;
	   if (_sizeof($recs_content)) foreach($recs_content as $rec)
	     {   $rec_content=array('name'=>$rec['obj_name'],'tiket_id'=>$rec['parent']) ;
	         if (file_exists(_DIR_TO_ROOT.$rec['dir'].$rec['file_name'])) $rec_content['data']=base64_encode(file_get_contents(_DIR_TO_ROOT.$rec['dir'].$rec['file_name'])) ;
	         $result['contents'][]=$rec_content ;
	     }
	   $json_content=json_encode($result,JSON_UNESCAPED_UNICODE) ;
	   $fname='poll_theme_'.safe_file_names($rec_theme['obj_name']).'.json' ;
	   $fdir=_TEMP_DIR.'/'.$fname ;
	   file_put_contents($fdir,$json_content) ;

	   $result=array() ;
	   $result['Разделов']=_sizeof($recs_sections) ;
	   $result['Билетов']=_sizeof($recs_questions) ;
	   $result['Ответов']=_sizeof($recs_answers) ;
	   $result['Файлов']=_sizeof($recs_content) ;
	   $result['Файл экпорта']=$fname ;
	   $result['Размер файла']=show_size(strlen($json_content)) ;
	   return($result) ;

	}

	function theme_delete($theme_id)
	{  $rec_theme=POLL()->get_theme_by_id($theme_id) ;
	   if (!$rec_theme['pkey']) return(array('error'=>'Тема не найдена'));
	   $recs_sections=execSQL('select * from poll_themes where parent='.$rec_theme['pkey']) ;
	   $recs_questions=execSQL('select * from poll_questions where parent in (select pkey from poll_themes where parent='.$rec_theme['pkey'].')') ;
	   $recs_answers=execSQL('select * from poll_answers where parent in (select pkey from poll_questions where parent in (select pkey from poll_themes where parent='.$rec_theme['pkey'].'))') ;
	   $recs_content=execSQL('select * from poll_content where parent in (select pkey from poll_questions where parent in (select pkey from poll_themes where parent='.$rec_theme['pkey'].'))') ;

	     execSQL_update('delete from poll_themes where pkey='.$rec_theme['pkey']) ;
	   echo 'Удалена тема "'.$rec_theme['obj_name'].'"<br>' ;

	   if (_sizeof($recs_sections)) foreach($recs_sections as $rec)
	   {   execSQL_update('delete from poll_themes where pkey='.$rec['pkey']) ;
	   	   echo 'Удален раздел "'.$rec['obj_name'].'"<br>' ;
	   }

	   if (_sizeof($recs_questions)) foreach($recs_questions as $id=>$rec)
	   {
		   execSQL_update('delete from poll_questions where pkey='.$rec['pkey']) ;
		   echo 'Удален билет "'.$rec['obj_name'].'"<br>' ;
	   }

	   if (_sizeof($recs_answers)) foreach($recs_answers as $id=>$rec)
	   {
		   execSQL_update('delete from poll_answers where pkey='.$rec['pkey']) ;
		   echo 'Удален ответ на билет "'.$rec['obj_name'].'"<br>' ;
	   }
	   if (_sizeof($recs_content)) foreach($recs_content as $rec)
	   {   if (file_exists(_DIR_TO_ROOT.$rec['dir'].$rec['file_name'])) unlink(_DIR_TO_ROOT.$rec['dir'].$rec['file_name']) ;
		   execSQL_update('delete from poll_content where pkey='.$rec['pkey']) ;
		   echo 'Удален файл "'.$rec['obj_name'].'"<br>' ;
	   }
	   $result=array() ;
	   $result['Разделов']=_sizeof($recs_sections) ;
	   $result['Билетов']=_sizeof($recs_questions) ;
	   $result['Ответов']=_sizeof($recs_answers) ;
	   $result['Файлов']=_sizeof($recs_content) ;
	   ob_start() ;
	   damp_array($result,1,-1);
	   $text=ob_get_clean() ;
	   LOGS()->reg_log('Опросы','Удаление темы контроля знаний "'.$rec_theme['obj_name'].' ['.$rec_theme['pkey'].']"<br>'.$text) ;
	   return($result) ;

	}

	// добавляем запись по МО в таблицу, возвращает id записи
		   function open_poll_session($rec_session,$options=array())
		   {   $rec_session['c_data']=time() ;
		       $now=getdate($rec_session['c_data']) ;
		       $rec_session['c_data_m']=mktime($now['hours'],$now['minutes'],0,$now['mon'],$now['mday'],$now['year']) ;
		       $rec_session['c_data_h']=mktime($now['hours'],0,0,$now['mon'],$now['mday'],$now['year']) ;
		       $rec_session['c_data_d']=mktime(0,0,0,$now['mon'],$now['mday'],$now['year']) ;
		       $rec_session['e_data']=0 ;
		       $rec_session['clss']=278 ;
		       if (!$rec_session['status']) $rec_session['status']=1 ;
		       $rec_session['indx']=1 ;
		       $id=adding_rec_to_table('poll_sessions',$rec_session,array('debug'=>0)) ;

		       $arr_questions_ids=explode(',',$rec_session['quiestion_ids']) ;
		       if (_sizeof($arr_questions_ids)) foreach($arr_questions_ids as $question_id) adding_rec_to_table('poll_sessions_questions',['clss'=>479,'parent'=>$id,'question_id'=>$question_id]) ;
		       return($id) ;
		   }

	// обработка данных терминала по POLL
function poll_session_close($poll_session_id,$poll_answers,$poll_balls)
			{ ob_start() ;
				echo '<strong>poll_session_close</strong><br>' ;
				$rec_poll_session=execSQL_van('select * from poll_sessions where pkey='.$poll_session_id,2) ;
				$rec_poll_sesson_question=execSQL_row('select question_id,pkey from poll_sessions_questions where parent='.$poll_session_id) ;
				// вычисляем и сохраняем модель  прохождения МО
				if ($rec_poll_session['pkey'])
				{ // сохраняем данные измерений в запись сессии опроса
					// при опросе на терминале КЗ данные по reason, equipment, video будут вписаны в сессию при получении examresult
					$data_mo = array('e_data' => time(),
			                     'status' => 2,
			                    );
					echo 'Обновляем сессию опроса ID '.$poll_session_id.':' ; damp_array($data_mo,1,-1);
					$this->update_poll_session($poll_session_id,$data_mo);

					// сбро
					$arr_result = array();
					// необходимо оставить только те вопросы, на которые был дан ответ
					if (_sizeof($poll_answers))
					{	foreach($poll_answers as $question_id=>$rec_answer)
							foreach($rec_answer as $answer_id=>$answer_status) if ($answer_status) $arr_result[$question_id][] = $answer_id;
					}

					echo 'Вопросы, на которые был дан ответ :' ; damp_array($arr_result,1,-1);

					// фиксируем ответы
					$arr_data=[] ;
					foreach($arr_result as $question_id => $result2) if (_sizeof($result2)) foreach($result2 as $answer_id)
					{	//$theme_id = execSQL_value('select theme_id from poll_questions where pkey=' . $question_id);

						$data=array('clss' => 476,
												'personal_id' => $rec_poll_session['personal_id'],
												'mo_id' => $rec_poll_session['mo_id'],
												'poll_id' => $poll_session_id,
												'event_id' => $rec_poll_session['event_id'],
												'pass_id' => $rec_poll_session['pass_id'],
												'session_question_id' => $rec_poll_sesson_question[$question_id],
												'question_id' => $question_id,
												'answer_id' => $answer_id,
											 ) ;

						$arr_data[]=$data ;
						$id=adding_rec_to_table('poll_result',$data) ;
						echo 'Добавлена запись в poll_result: '.$id.'<br>' ;
					}

					// фиксируем баллы
					if (_sizeof($poll_balls)) foreach($poll_balls as $question_id=>$poll_ball)
					{
						$data=array('clss' => 476,
												'personal_id' => $rec_poll_session['personal_id'],
												'mo_id' => $rec_poll_session['mo_id'],
												'poll_id' => $poll_session_id,
												'event_id' => $rec_poll_session['event_id'],
												'pass_id' => $rec_poll_session['pass_id'],
												'session_question_id' => $rec_poll_sesson_question[$question_id],
												'question_id' => $question_id,
												'answer_ball' => $poll_ball,
											 ) ;

						$arr_data[]=$data ;
						$id=adding_rec_to_table('poll_result',$data) ;
						echo 'Добавлена запись в poll_result: '.$id.'<br>' ;
					}


					echo 'Сохраняем результат ответа на вопрос :' ; print_2x_arr($arr_data);

					// меняем статус участнику мероприятия
                    EVENT_POLL()->update_personal_pass_status($rec_poll_session['event_id'],$rec_poll_session['personal_id']) ;

				}
				$text=ob_get_clean() ;
				//LOG_JSON('mo_session')->reg('server_examination_result_success',$text);
				echo $text ;
				return($text) ;
		  }




	 function update_poll_session($sess_id,$rec)
	 { list($sess_id,$tkey)=explode('.',$sess_id) ;
		 ob_start()  ;
		 update_rec_in_table('poll_sessions',$rec,'pkey='.$sess_id,array('debug'=>0)) ;
		 $text=ob_get_clean() ;
		 LOG_JSON('mo_session')->reg('update_poll_session',$text) ;
	 }

	function get_poll_by_id($id,$options=array())
	 {   $rec=array() ;
	     if ($id)
	     { $rec=execSQL_van('select * from view_poll_session where pkey='.$id,array('debug'=>$options['debug'])) ;
	       //if (!$rec['pkey']) $rec=execSQL_van('select * from '.$this->view_mo_session.' where pkey='.$id,array('debug'=>$options['debug'])) ;
	       if ($rec['pkey'] and !$options['no_public_info']) $this->prepare_public_info_to_poll_session($rec,$options) ;
	     }
	     return($rec) ;
	 }


  function prepare_public_info_to_terminal(&$rec,$options=array())
   {  // переносим информацию из профиля в запись по терминалу
	   $rec['_profil']['video']=_IL('IL_term_prof')->recs[$rec['profil']]['video'] ;
       $rec['_profil_name']=_IL('IL_term_prof')->recs[$rec['profil']]['obj_name'] ;
       $rec['_group_name']=ACCOUNTS()->tree[$rec['parent']]->name ;
       $rec['__href']='/window/esmo_setting/terminal/card/'.$rec['pkey'].'/' ;
       $rec['__href_virt']=($rec['virt'])? '/term/'.$rec['id'].'/':'/term/' ;
       if ($rec['ext_info']) $rec['_ext_info']=unserialize($rec['ext_info'])  ;
       if ($rec['devices']) $rec['_devices']=unserialize($rec['devices'])  ;
       $rec['settings']['remote_endpoint']='/equipment-api-kz.php' ;
       $rec['settings']['question']=0 ;
       $rec['settings']['signature']=1 ;
   }


    // возвращает путь к фото, которое будет сохраняться или которое уже сохранено
	// если фото будет сохраняться - надо передать параметр no_check_exist_file
	//
	function get_mo_img_dir_by_id($session_id,$mode,$type,$options=array())
	   {
	   	  $dir_to_photo=ENGINE()->get_number_dir_by_id($session_id,'/public/poll_photo/') ;

	      $file_dir_default='/images/no-avatar-62.png' ;
	      $file_dir=$dir_to_photo.$session_id.'_'.$type ;

	      // при получении имени файла для его последующего сохранения должна передаваться опция no_check_exist_file, по ней будет возвращено имя файла в нужной директории
	      if ($options['no_check_exist_file'])                   $result=array('dir'=>_DIR_TO_ROOT.$file_dir,'url'=>_PATH_TO_SITE.$file_dir,'relative'=>$file_dir) ;
	      else if (file_exists(_DIR_TO_ROOT.$file_dir))          $result=array('dir'=>_DIR_TO_ROOT.$file_dir,'url'=>_PATH_TO_SITE.$file_dir,'relative'=>$file_dir) ;
	      else if (!$options['no_default_img'])                  $result=array('dir'=>_DIR_TO_ROOT.$file_dir_default,'url'=>_PATH_TO_SITE.$file_dir_default,'relative'=>$file_dir_default) ;
	      else                                                   $result=array('dir'=>'','url'=>'','relative'=>'') ;

	      if ($mode) return($result[$mode]) ;
	      else return($result) ;
	   }

	function prepare_public_info_to_poll_session(&$rec,$options=array())
   {  $t=fixed_time() ;
      $rec['__href']='/cab/poll/session/'.$rec['pkey'].'/' ;
      $rec['__href_window']='/window/poll/session/'.$rec['pkey'].'/' ;
	  $rec['__href_mo']='/cab/mo/'.$rec['mo_id'].'/' ;
	  $rec['__href_mo_window']='/window/mo/'.$rec['mo_id'].'/' ;

      $arr_ids=array() ; //$recs_account=array() ;
      if ($rec['e_data']) $rec['__dlit_mo']=$rec['e_data']-$rec['c_data'] ;
      if ($rec['creator_id'])         $arr_ids[$rec['creator_id']]=1 ;
      if ($rec['dopusk_user_id'])     $arr_ids[$rec['dopusk_user_id']]=1 ;
      //if (_sizeof($arr_ids)) $recs_account=ACCOUNTS()->get_members_by_ids(array_keys($arr_ids)) ;

      // если терминал удален из системы, поле terminal_name будет пустов
      if ($rec['terminal_id'] and !$rec['terminal_name']) $rec['terminal_name']='Терминал № '.$rec['terminal_id'] ;

      $rec['_data']=date('d.m.Y H:i',$rec['c_data']) ;
      $rec['_status_name']=$this->arr_kz_status[$rec['status']] ;
      if ($rec['reason'])       $rec['_reason']=$this->arr_kz_failed_status[$rec['reason']] ;

      // результат МО
      // либо все хорошо, либо выводим причину почему плохо
      $_arr=array() ;
      //if ($rec['status']==2)                   $_arr[]='<div class=ok>'.$rec['_status_name'].'</div>' ; // выводится отдельно
      // если есть ошибка - выводим расшифровку ошибки
      if ($rec['reason'])                      $_arr[]='<div class=red>'.$rec['_reason'].'</div>' ;
      if ($rec['equipment'])                   $_arr[]='<div class=red>'.$rec['_equipment'].'</div>' ;
      //if ($rec['question_comment'])            $_arr[]='<div class=red>'.$rec['question_comment'].'</div>' ; //  выводиться отдельно
      // если есть комментарий к автоматическому принятию решения сервером - выводим
      if ($rec['comment'])                     $_arr[]='<div class=red>'.$rec['comment'].'</div>' ;
      if (_sizeof($_arr)) $rec['_comment']=implode('',$_arr) ;

      if (!$options['no_get_MO_image'])
      {   $img_name='' ;
          if ($rec['personal_id'] and $rec['personal_img'])   $img_name=$rec['personal_img'] ;

          $imgRoot=(isset($options["img_path_relative"]) && $options["img_path_relative"])? "":_PATH_TO_SITE ;
          $img_mode=(isset($options["img_path_relative"]) && $options["img_path_relative"])? 'relative':'url' ;

          if ($img_name) $rec['_personal_img']=$imgRoot.'/public/personals/400/'.$img_name ; else  $rec['_personal_img']=$imgRoot.'/images/no-avatar-62.png' ;
          $rec['_personal_img_auth']=($rec['mo_id'])? ESMO()->get_mo_img_dir_by_id($rec['mo_id'],$img_mode,'auth.jpg'):$this->get_mo_img_dir_by_id($rec['pkey'],$img_mode,'auth.jpg') ;
          //$rec['_personal_img_DTW']=$this->get_mo_DTW_img_dir_by_id($rec['pkey'],$img_mode) ;
      // есть по текущему МО нет подписи - смотрим в прошлом МО
          //if (!$rec['_personal_img_DTW'] and $rec['mo1_id']) $rec['_personal_img_DTW']=$this->get_mo_DTW_img_dir_by_id($rec['mo1_id'],$img_mode) ;
          // поле _personal_img_DTW_gen не используется
          //$rec['_personal_img_DTW_gen']=$this->get_mo_img_dir_by_id($rec['pkey'],$img_mode,'DTW_150.png',array('no_default_img'=>1)) ;
      }

       $rec['_work_name']=_IL('IL_works')->recs[$rec['working']]['obj_name'] ;

       // включать показ печати по допуску
       if ($options['view_sertificate_stamp'] and $rec['dopusk']==1 and !$rec['tk'])
       {  include_once(_DIR_EXT.'/image_print/i_image_print.php') ;
          if (class_exists($options['view_sertificate_stamp']))
          { $IM = new $options['view_sertificate_stamp']($rec) ;
            $rec['_sertificate_stamp_base64']=base64_encode($IM->get_image_content()) ;
          }
       }

       // включен модуль разбора инцидентов
       if ($GLOBALS['LS_trassir_enable']) {
          if ($rec['terminal_id']) {
              $cnt_cameras=execSQL_value('select count(pkey) from obj_site_trassir_camera_terminal where terminal_id='.$rec['terminal_id'].' or group_id='.$rec['group_id']);
              if ($cnt_cameras) $rec['_use_in_trassir']=1;
          }
          if ($rec['hand_check_user_id']) {
              $cnt_cameras=execSQL_value('select count(pkey) from obj_site_trassir_camera_terminal where hand_check_group_id='.$rec['group_id']);
              if ($cnt_cameras) $rec['_use_in_trassir']=1;
          }
       }
   }


	// тоже что и прошлая функция, но для поиска файла подписи
   // по хранению файл подписи было три версии
   // 1. /public/mo_photo/000_DTW.png
   // 2. /public/mo_photo/XXX/000_DTW.png
   // 3. /public/mo_sign_image/XXX/000_DTW.png
   function get_mo_DTW_img_dir_by_id($session_id,$mode,$options=array())
   {
      $dir_to_photo=ENGINE()->get_number_dir_by_id($session_id,'/public/poll_sign_image/') ;
	  $file_dir=$dir_to_photo.$session_id.'_DTW.png' ;

      // при получении имени файла для его последующего сохранения должна передаваться опция no_check_exist_file, по ней будет возвращено имя файла в нужной директории
      if ($options['no_check_exist_file'])                   $result=array('dir'=>_DIR_TO_ROOT.$file_dir,'url'=>_PATH_TO_SITE.$file_dir,'relative'=>$file_dir) ;
      else if (file_exists(_DIR_TO_ROOT.$file_dir))          $result=array('dir'=>_DIR_TO_ROOT.$file_dir,'url'=>_PATH_TO_SITE.$file_dir,'relative'=>$file_dir) ;
      else                                                   $result=array('dir'=>'','url'=>'','relative'=>'') ;

      //damp_array($result);
      if ($mode) return($result[$mode]) ;

      else return($result) ;
   }

   // тоже что и прошлая функция, но для поиска DATA подписи
   // по хранению файл подписи было три версии
   // 1. /public/mo_sign/000_DTW.png
   // 2. /public/mo_sign/XXX/000_DTW.png
   function get_mo_DTW_data_dir_by_id($session_id,$mode,$options=array())
   {  $dir_to_photo=ENGINE()->get_number_dir_by_id($session_id,'/public/poll_sign_data/') ;
	  $file_dir=$dir_to_photo.$session_id.'.data' ;

      // при получении имени файла для его последующего сохранения должна передаваться опция no_check_exist_file, по ней будет возвращено имя файла в нужной директории
      if ($options['no_check_exist_file'])                   $result=array('dir'=>_DIR_TO_ROOT.$file_dir,'url'=>_PATH_TO_SITE.$file_dir,'relative'=>$file_dir) ;
      else if (file_exists(_DIR_TO_ROOT.$file_dir))          $result=array('dir'=>_DIR_TO_ROOT.$file_dir,'url'=>_PATH_TO_SITE.$file_dir,'relative'=>$file_dir) ;
      else                                                   $result=array('dir'=>'','url'=>'','relative'=>'') ;

      if ($mode) return($result[$mode]) ;
      else return($result) ;
   }

    function poll_clear_status()
    {   include_once(_DIR_EXT.'/events_poll/i_event_poll.php') ;
        $recs_events=execSQL('select * from obj_site_events_schedule where ext like "%poll%" and status!=5 and enabled=1');
        $obj_event=new i_event_poll() ;
        echo 'Будет проверено '._sizeof($recs_events).' мероприятий по КЗ<br>';
        //$rec_events=execSQL('select * from obj_site_events_schedule where ext like "%poll%"',2) ;
        //$rec_events=execSQL('select * from obj_site_events_schedule where pkey=2',2) ;
        if(_sizeof($recs_events)) foreach($recs_events as $rec_event)
        {
            $ext_info=unserialize($rec_event['ext_info']);
            if($ext_info['close_period']>1)
            {
                $now=getdate();
                $time_from=0;
                switch($ext_info['close_period'])
                {
                    case 2: $time_from=mktime(0,0,0,$now['mon'],1,$now['year']); break; // c первого числа этого месяца
                    case 3: $time_from=mktime(0,0,0,$now['mon']-3,1,$now['year']); break; // с первого числа три месяца назад
                    case 4: $time_from=mktime(0,0,0,1,1,$now['year']); break; // с первого числа этого года
                    case 5: $time_from=mktime(0,0,0,$now['mon'],$now['mday'],$now['year']); break;// с нуля часов сегодня
                    case 6: $time_from=mktime($now['hours'],0,0,$now['mon'],$now['mday'],$now['year']); break;// с нуля минут сегодня текущий час
                }
                echo 'Мероприятие: '.$rec_event['obj_name'].', период мероприятия: <strong>'.POLL()->arr_events_close_period[$ext_info['close_period']].'</strong><br>';
                echo 'Выполяем сброс статуса у участников, которые получили зачет ранее <strong>'.date('d.m.Y H:i',$time_from).'</strong><br>';
                $usl_time=($time_from)? ' having last_time<'.$time_from:'';
                if($usl_time)
                { // сбрасываем статус у сотрудников мероприятия, которые получили status=3 ранее чем $time_from
                    $recs=execSQL('select t1.*,
                                   (select max(t2.c_data) from obj_site_events_pass_status t2 where t2.event_id=t1.event_id and t2.personal_id=t1.personal_id and t2.status_new=3)  as last_time
                                   from obj_site_events_pass t1 
                                   where t1.event_id='.$rec_event['pkey'].' and t1.status=3 '.$usl_time.'
                                ',2);

                    if(_sizeof($recs)) foreach($recs as $rec_event_pass_status)
                    {
                        echo 'Производим сброс статуса у сотрудника <strong>'.$rec_event_pass_status['personal_id'].'</strong>, зачет получен <strong>'.date('d.m.Y H:i',$rec_event_pass_status['c_data']).'</strong><br>';
                        EVENTS()->set_event_personal_data($rec_event_pass_status['event_id'],$rec_event_pass_status['personal_id'],array('status'=>1),'Сброс статуса в связи с окончанием периода мероприятия КЗ',array('old_status'=>3));
                    }
                    else echo 'Участников не найдено<br>';
                }
            }
        }
    }


    function  get_arr_groups_select_options($options=array())
         {   $options_list=array() ;
             $arr_groups=execSQL('select pkey,parent,obj_name from poll_themes where enabled=1 order by parent,obj_name') ;
             //damp_array($arr_groups) ;
             //print_2x_arr($arr_groups) ;
             $arr_groups2=$arr_groups ;
             convert_list_to_tree($arr_groups2,$arr_tree) ;
             $this->convert_tree_to_select_options_arr($arr_tree,$arr_groups,$options_list) ;
             return($options_list) ;
         }

         function convert_tree_to_select_options_arr($arr_tree,&$recs,&$options_list,$level=0)
         {  $pref=($level)? str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;",$level-1).'|--':"" ;
           $level++ ;
           if (_sizeof($arr_tree)) foreach ($arr_tree as $id=>$arr_childs)
           {   $options_list[$id]=$pref.$recs[$id]['obj_name'] ;
               if (_sizeof($arr_childs)) $this->convert_tree_to_select_options_arr($arr_childs,$recs,$options_list,$level) ;
           }
         }


	 function send_email_invite()
    {   include_once(_DIR_TO_MODULES.'/poll/i_poll_logic.php') ;
        // получаем мероприятия КЗ, которые доводят КЗ через email
        // !!! добавить учет срока действия мероприятия
        $recs_events=execSQL('select * from obj_site_events_schedule
                              where ext="events_poll/i_event_poll" and enabled=1 and status!=5  
                                ') ;
        ?><table class="basic fz_small full auto"><tr><td>Сотрудник</td><td>Подготовка вопросов</td><td>Регистрация в мероприятии</td><td>Отправка почты</td></tr><?
        if (_sizeof($recs_events)) foreach($recs_events as $rec_event)
        { $ext_info=unserialize($rec_event['ext_info']) ;
          if ($ext_info['method']==4)
          { ?><tr><th colspan="4"><?echo '<strong>'.$rec_event['obj_name'].'</strong>' ;?></th></tr><?
            $recs_personals=execSQL('select * from '.$rec_event['viewer_name']) ;

            if (_sizeof($recs_personals)) foreach($recs_personals as $rec_personal)
            {
                PERSONAL()->prepare_public_info_to_personal($rec_personal) ;
                // получаем сессию КЗ для сотрудника и формируем письмо
                ?><tr><?
                ?><td><?echo 'Сотрудник ID '.$rec_personal['pkey'].'<br><strong><a href="'.$rec_personal['__href_window'].'" class="new_window">'.$rec_personal['obj_name'].'</a></strong><br>'.$rec_personal['_org_name'].'<br>'.$rec_personal['_otdel_name'].'<br>'.$rec_personal['_work_name'] ;  ?></td><?
                $obj_poll_logic=new i_poll_logic() ;
                $obj_poll_logic->rec_personal=$rec_personal ;
                ?><td class="left"><?
                //ob_start() ;
                $arr_quelle=$obj_poll_logic->get_personal_questions_quelle(['check_result'=>0,'question_count'=>$ext_info['question_count']]) ;
                //ob_get_clean() ;
                //damp_array($arr_quelle,1,-1) ;
                ?><br><?
                if ($arr_quelle['quiestion_ids'])
                 { echo '<div class=green><strong>Вопросы, которые будут заданы сотруднику: </strong>'.$arr_quelle['quiestion_ids'].'</div><br>' ;
                   // только для отладки
                   echo 'Темы вопросов:<br>' ;
                     $recs=execSQL('select * from poll_questions where pkey in ('.$arr_quelle['quiestion_ids'].')') ;
                     $arr_parent_ids=[] ;
                     foreach($recs as $rec) for($i=1;$i<=9;$i++) if ($rec['parent'.$i]) $arr_parent_ids[$rec['parent'.$i]]=1 ;
                     $arr_parents_names=execSQL_row('select pkey,obj_name from poll_themes where pkey in ('.implode(',',array_keys($arr_parent_ids)).')') ;
                     if (_sizeof($recs)) foreach($recs as $rec)
                     { $arr_names=[] ;
                       for($i=1;$i<=9;$i++) if ($rec['parent'.$i]) $arr_names[$rec['parent'.$i]]=$arr_parents_names[$rec['parent'.$i]] ;
                       echo $rec['pkey'].': '.implode(' / ',$arr_names).'<br>' ;
                     }

                 }
                else echo '<div class="red">Вопросы для КЗ отсутствуют</div>' ;

                ?></td><?
                if ($arr_quelle['quiestion_ids'])
                {   ?><td class="left"><?

                    $session_info=['personal_id'=>$rec_personal['pkey'],
                                   'terminal_id'=>0,
                                   'terminal_pkey'=>0,
                                   'group_id'=>0,
                                   'reader'=>'email',
                                  ] ;
                    $result=[] ;
                    $rec_event['quiestion_ids']=$arr_quelle['quiestion_ids'] ;

                    $obj_event=EVENTS()->get_event_obj_by_ext($rec_event['ext']) ;
                    // регистрируем участие сотрудника в мероприятии
                    // регистрация возможна только на незанятие места (after_auth,during_systolic,before_sign)
                    // также тут будет вписано записи в таблицу media_content_view
                    $poll_session_id=$obj_event->register_personal_pass($rec_event,$session_info,$result) ;
                    ?></td><?
                    //damp_array($session_info,1,-1);
                    //damp_array($result,1,-1);
                    ?><td class="left"><?
                    if ($poll_session_id)
                    {   echo $text='Сформирована ссылка на прохождение опроса '.date('d.m.Y').':<br><a href="'._PATH_TO_SITE.'/services/poll/session/'.$poll_session_id.'/" target="_blank">Пройти опрос</a><br><br>' ;
                    echo 'Email: <strong>'.$rec_personal['email'].'</strong><br>' ;
                    if ($rec_personal['email'])
                    {
                      $result=MAILS()->send_mail($rec_personal['email'],'Опрос',$text,['debug'=>1]) ;
                      damp_array($result,1,-1);
                    }
                    else echo '<div class=red>Не задан email для отправки уведомдения</div>' ;
                    } else echo '<div class=red>register_personal_pass не вернул $poll_session_id</div>' ;

                    ?></td><?
                }
                else {?><td></td><td></td><?}
                ?></tr><?
            }
            // получаем всех сотрудников, которым необходимо сделать рассылку


          }

        }
        ?></table><?
    }
}



?>
