<?
namespace esmo\pl;
use i_db_object;
class i_pl_packets extends i_db_object
{
    static $table_name = 'pl_packets';
    static $table_title = 'ПЛ - лог пакетов';

    static $clss = 783;
    static $class_descr=['name'=>'ПЛ - лог пакетов',
                         'parent'=>0,
                         'fields'=>['packet_mode'=>['type'=>'int(11)','default'=>1,'index'=>'packet_mode'], // 1 - входящий, 2 - исходящий
                                    'packet_type'=>['type'=>'int','default'=>0,'index'=>'packet_type'],
                                    'ip'=>'varchar(20)',
                                    'result_status'=>'int',
                                    'file_uid'=>'varchar(255)',
                                    'knd'=>'int',
                                    'titul_date_from'=>['type'=>'int','default'=>0,'index'=>'titul_date_from'],
                                    'titul_date_to'=>['type'=>'int','default'=>0,'index'=>'titul_date_to'],
                            		'pl_number'=>'varchar(32)',
                            		'trip_type'=>'int',
                            		'pl_uid'=>'varchar(40)',
                            		'mo_type2_necessarily'=>'int',
                            		'pl_date'=>'int',
                            		'car_number'=>'varchar(10)',
                            		'car_id'=>'int',
                            		'pl_id'=>'int',
                                    'status'=>['type'=>'int','default'=>0,'index'=>'status'],
                            		'xml_size'=>'int',
                            		'xml_md'=>'varchar(32)',
                            		'sign_size'=>'int',
                            		'error'=>'int',
                            		'sign_uid'=>'varchar(32)',
                                    'titul1_id'=>['type'=>'int','default'=>0,'index'=>'titul1_id'],
                                   ],

        ] ;

    public static function prepare_rec_by_form($form_data)
    {
        //damp_array($form_data);
         $data=[];
         $data['clss']=static::$clss;
         $data['indx']=0;
         if (isset($form_data['packet_mode'])) $data['packet_mode']=$form_data['packet_mode'];
         if (isset($form_data['packet_type'])) $data['packet_type']=$form_data['packet_type'];
         if (isset($form_data['ip'])) $data['ip']=$form_data['ip'];
         if (isset($form_data['result_status'])) $data['result_status']=$form_data['result_status'];
         if (isset($form_data['file_uid'])) $data['file_uid']=$form_data['file_uid'];
         if (isset($form_data['knd'])) $data['knd']=($form_data['knd']) ?: 0;
         if (isset($form_data['titul_date_from'])) $data['titul_date_from']=($form_data['titul_date_from']) ?: 0;
         if (isset($form_data['titul_date_to'])) $data['titul_date_to']=($form_data['titul_date_to']) ?: 0;
         if (isset($form_data['pl_number'])) $data['pl_number']=($form_data['pl_number']) ?: '';
         if (isset($form_data['trip_type'])) $data['trip_type']=($form_data['trip_type']) ?: 0;
         if (isset($form_data['pl_uid'])) $data['pl_uid']=($form_data['pl_uid']) ?: '';
         if (isset($form_data['sign_uid'])) $data['sign_uid']=($form_data['sign_uid']) ?: '';
         if (isset($form_data['mo_type2_necessarily'])) $data['mo_type2_necessarily']=($form_data['mo_type2_necessarily']) ?: 0;
         if (isset($form_data['pl_date'])) $data['pl_date']=($form_data['pl_date']) ? 1:0;
         if (isset($form_data['pl_id'])) $data['pl_id']=($form_data['pl_id']) ?:0;
         if (isset($form_data['car_id'])) $data['car_id']=($form_data['car_id']) ?:0;
         if (isset($form_data['car_number'])) $data['car_number']=($form_data['car_number']) ?:'';
         if (isset($form_data['xml_size'])) $data['xml_size']=($form_data['xml_size']) ?:0;
         if (isset($form_data['xml_md'])) $data['xml_md']=($form_data['xml_md']) ?:'';
         if (isset($form_data['sign_size'])) $data['sign_size']=($form_data['sign_size']) ?:0;
         if (isset($form_data['status'])) $data['status']=($form_data['status']) ?:0;
         if (isset($form_data['error'])) $data['error']=($form_data['error']) ?:0;
         if (isset($form_data['titul1_id'])) $data['titul1_id']=($form_data['titul1_id']) ?:0;
         if (isset($form_data['comment'])) $data['obj_name']=(sizeof($form_data['comment']))? json_encode($form_data['comment'],JSON_UNESCAPED_UNICODE):'' ;
         return ($data);
     }


    public static function get_rec_by_id($pkey,$options=[])
   	{ $_usl=[] ;
   		$_usl[]='pk.pkey='.$pkey ;
   		$usl=implode(' and ',$_usl) ;
   		$rec=execSQL_van('select pk.*
   		                  from '.static::$table_name.' pk
   		                  left join pl_put_list pl on pl.pkey=pk.pl_id 
   		                  where '.$usl);
   		return($rec) ;
   	}

    public static function create($form_data,$options=[])
    {
       $result=parent::create($form_data,$options) ;
       if ($result['result']) \esmo\pl\i_pl_log::reg($result['id'], 'Регистрация титула');
       else \esmo\pl\i_pl_log::reg(0, 'Ошибка регистрации титула');
       return($result);
    }

    public static function save($pkey,$form_data,$options=[])
   	{
       $options['check_changes']=1 ;
   	   $result=parent::save($pkey,$form_data,$options) ;
       if ($result['result'] and sizeof($result['changes'])) \esmo\pl\i_pl_log::reg($pkey, 'Изменение титула',['changes'=>$result['changes']]);
       else if (!$result['result']) \esmo\pl\i_pl_log::reg(0, 'Ошибка изменения титула');

   	   return($result);
   	}



}

?>
