<?php

use LdapTools\Operation\DeleteOperation;

include_once('i_personals_filter.php') ;

$__functions['init'][]='_personal_site_vars' ;
$__functions['boot_site'][]='_personal_site_boot' ;

function PERSONAL() {if (is_object($_SESSION['personal_system'])) return($_SESSION['personal_system']);$_SESSION['personal_system']=new c_personal_system();return($_SESSION['personal_system']);} ;



function _personal_site_vars()
{


    $_SESSION['init_options']['personal']['debug']=0 ;
	//$_SESSION['init_options']['goods']['patch_mode']='TREE_NAME' ;
    $_SESSION['init_options']['personal']['patch_mode']='NAME' ;
	$_SESSION['init_options']['personal']['root_dir']	='/cab/personal/' ;
    $_SESSION['init_options']['personal']['clss_items']='211' ;
    //$_SESSION['init_options']['personal']['usl_show_items']='enabled=1 and _enabled=1' ;
    $_SESSION['init_options']['personal']['usl_show_items']='_enabled=1' ; // показываем всех сотрудников, уволенных и действующих
    $_SESSION['init_options']['personal']['tree_fields']='pkey,parent,clss,indx,enabled,obj_name,tkey' ;


    // определяем условия для формирование дерева
    //$_SESSION['init_options']['personal']['tree']['debug']=0 ;
    $_SESSION['init_options']['personal']['tree']['clss']='1,207,208' ;
    $_SESSION['init_options']['personal']['tree']['include_space_section']=1 ;
    $_SESSION['init_options']['personal']['tree']['order_by']='indx' ;
    $_SESSION['init_options']['personal']['tree']['get_count_by_clss']=0 ;

    $_SESSION['img_pattern']['personal'][400]['resize']=array('width'=>400,'resampled'=>1,'quality'=>100,'back_color'=>'ffffff');
    $_SESSION['img_pattern']['personal'][400]['default']='/images/def_400.jpg';
    $_SESSION['img_pattern']['personal'][200]['resize']=array('width'=>200,'height'=>266,'fields'=>0,'resampled'=>1,'quality'=>100,'back_color'=>'ffffff');
    $_SESSION['img_pattern']['personal'][200]['default']='/images/def_200.jpg';
    $_SESSION['img_pattern']['personal']['small']['no_photo']='/images/def_small.jpg';

    $_SESSION['ARR_mess_status']=array(1=>'Новое', // сообщение не было показано сотруднику
                                       2=>'Уведомлен', // сообщение было показано сотруднику
                                       3=>'Блокировка МО', // сообщение блокирует прохождение МО
                                       4=>'Закрыто', // закрыто вручную или завершен срок показа (блокировки) сообщения,
                                       5=>'Ожидает' // срок показа сообщения еще не наступил
                                       ) ;

}

function _personal_site_boot($options)
{ if (isset($options['personal_system'])) $options=$options['personal_system'] ;
  //damp_array($options) ;
  create_system_modul_obj('personal',$options) ;
}


class c_personal_system  extends c_system
{
 public $table_personal ;
 public $view_personal ;
 public $person_dir_name ;
 public $tkey_personal ;
 var $arr_pol=array(0=>'М',1=>'Ж') ;
 var $arr_no_yes=array(0=>'Нет',1=>'Да') ;

 function __construct($create_options=array())
 { $this->table_name ='obj_'.SITE_CODE.'_personals' ;
   $this->table_personal ='obj_'.SITE_CODE.'_personals' ;
   $this->view_personal ='view_personals' ;
   $this->tkey_personal =_DOT($this->table_personal)->pkey ;
   $this->table_tabel ='obj_'.SITE_CODE.'_tabel' ;
   parent::__construct($create_options) ;
   //parent::c_system_catalog($create_options) ;
   $this->person_dir_name=($create_options['person_dir_name'])? $create_options['person_dir_name']:'person' ;
   $this->system_title ='Персонал';

   ENGINE()->reg_ext('aspmo_personal','Персонал') ;
   ENGINE()->reg_ext('personal','Персонал2') ;
   ENGINE()->reg_ext('personals','Персонал  - организации') ;

 }

  function declare_menu_items_2($page)
  {

      $page->menu['/cab/personal/']=array('title'=>'Сотрудники',
                                          'class'=>'fa fa-users',
                                          'items'=>array(
                                                         //'/cab/personal/cars/'=>'Справочник автомобилей',
                                                         '/cab/personal/orgs/'=>array('title'=>'Справочник организаций',
                                                                                 'items'=>array('/cab/personal/org/create/'=>'Добавить организацию')
                                                                                 ),
                                                         '/cab/personals/editor/'=>array('title'=>'Редактор организаций','new_window'=>'win_personal_editor'),
                                                         '/cab/personal/'=>array('title'=>'Справочник сотрудников',
                                                                                 'items'=>array('/window/personal/create/'=>array('title'=>'Добавить сотрудника','new_window'=>'win_second'))
                                                                                 ),
                                                         '/cab/personal/extlist/'=>array('title'=>'Дополнительные списки',
                                                                                 'items'=>array('/cab/personal/extlist/create/'=>'Добавить сотрудника')
                                                                                ),
                                                         '/cab/personal/fired/'=>array('title'=>'Уволенные сотрудники','class'=>'fa fa-users'),
                                                         '/cab/personal/merge/'=>array('title'=>'Дубликаты сотрудников','class'=>'fa fa-users')

                                                        )
                                          ) ;

  }


	function personal_save($reffer,$form_data,$options=array())
	{ //damp_array($form_data,1,-1) ;
      $result=array() ;
	  $rec=$this->get_personal_by_id($reffer) ; $res=array() ; // damp_array($rec,1,-1) ;
	  if ($rec['pkey'] and _sizeof($form_data))
	  {  // определяем, какие поля были изменены
        ob_start() ;   $arr_changes=array() ;  $data=array() ;  $data_so=array() ;   $res_update=array() ;

	    if (isset($form_data['uid']) and $form_data['uid']!=$rec['uid'])  { $data['uid']=$form_data['uid'] ;  $arr_changes['UID']=$rec['uid'].' => '.$form_data['uid'] ; }
	    if (isset($form_data['obj_name']) and $form_data['obj_name']!=$rec['obj_name'])  { $data['obj_name']=$form_data['obj_name'] ;  $arr_changes['ФИО']=$rec['obj_name'].' => '.$form_data['obj_name'] ; }
	    if (isset($form_data['name']) and $form_data['name']!=$rec['obj_name'])  { $data['obj_name']=$form_data['name'] ;  $arr_changes['ФИО']=$rec['obj_name'].' => '.$form_data['name'] ; }
	    if (isset($form_data['name1']) and $form_data['name1']!=$rec['name1'])  { $data['name1']=$form_data['name1'] ;  $arr_changes['Фамилия']=$rec['name1'].' => '.$form_data['name1'] ; }
	    if (isset($form_data['name2']) and $form_data['name2']!=$rec['name2'])  { $data['name2']=$form_data['name2'] ;  $arr_changes['Имя']=$rec['name2'].' => '.$form_data['name2'] ; }
	    if (isset($form_data['name3']) and $form_data['name3']!=$rec['name3'])  { $data['name3']=$form_data['name3'] ;  $arr_changes['Отчество']=$rec['name3'].' => '.$form_data['name3'] ; }
	    if (isset($form_data['dr']) and $form_data['dr']!=$rec['dr'])
	    { $data['dr']=$form_data['dr'] ;
	      $arr_changes['ДР']=$rec['dr'].' => '.$form_data['dr'] ;
	      $form_data['age']=$data['age']=ENGINE()->get_age_by_dr($data['dr']) ;
	    }
	    if (isset($form_data['age']) and $form_data['age']!=$rec['age'])
	    { $data['age']=$form_data['age'] ;
	      $arr_changes['Возраст']=$rec['age'].' => '.$form_data['age'] ;
	    }
	    if (isset($form_data['pol']) and $form_data['pol']!=$rec['pol'])  { $data['pol']=$form_data['pol'] ;  $arr_changes['Пол']=$this->arr_pol[$rec['pol']].' => '.$this->arr_pol[$form_data['pol']] ; }

		//  working is work_id
		//_IL('IL_works')->reload_list() ;
		if (isset($form_data['working_name']) and trim($form_data['working_name'])!="") $form_data['working']=_IL('IL_works')->get_id_of_value(trim($form_data['working_name']),array('append_value_is_not_found'=>1)) ;
	    if (isset($form_data['working']) and $form_data['working']!=$rec['working'])
	    { $data['working']=$form_data['working'] ;
          $data_so['work_id']=$form_data['working'] ;
		  $arr_changes['Должность']=_IL('IL_works')->recs_names[$rec['working']].' => '._IL('IL_works')->recs_names[$form_data['working']]  ;
	    }

		$parent=0 ;
	    if (isset($form_data['parent']) and $form_data['parent']>0)  $parent=$form_data['parent'] ;
        if (isset($form_data['org_id']) and $form_data['org_id']>0)  $parent=$form_data['org_id'] ;
        if (isset($form_data['otdel_id']) and $form_data['otdel_id']>0)  $parent=$form_data['otdel_id'] ;
        if (isset($form_data['otdel_name']) and $form_data['otdel_name']!="")  $parent=LISTS()->get_rec_id_by_name($form_data['otdel_name'],208,$form_data['org_id'],$this->table_personal) ;
         if ($parent>0)
        {  $data['parent']=$parent ;
             // заполняем уровни parent по новой системе, в data будет правильные ID уровней
             $this->full_parent_levels_to_rec($parent,$data) ;
             if ($rec['parent']!=$data['parent'] or $rec['parent1']!=$data['parent1'] or $rec['parent2']!=$data['parent2'] or $rec['parent3']!=$data['parent3'] or $rec['parent4']!=$data['parent4'] or $rec['parent5']!=$data['parent5'] or $rec['parent6']!=$data['parent6'] or $rec['parent7']!=$data['parent7'] or $rec['parent8']!=$data['parent8'] or $rec['parent9']!=$data['parent9'])
             {   $arr=array() ;
                 for ($i=2;$i<=9;$i++)
                 {  if ($data['parent'.$i]) $arr[]=$data['parent'.$i] ; else $data['parent'.$i]=0 ;
                    if ($rec['parent'.$i]) $arr[]=$rec['parent'.$i] ;   else $rec['parent'.$i]=0 ;
                 }
           if (_sizeof($arr)) $org_names=execSQL_row('select pkey,obj_name from obj_site_personals where clss in (207,208) and pkey in ('.implode(',',$arr).')') ;  else $org_names=array() ;
           if ($data['parent2']!=$rec['parent2'])  $arr_changes['Организация']=$org_names[$rec['parent2']].' => '.$org_names[$data['parent2']] ;
           if ($data['parent3']!=$rec['parent3'])  $arr_changes['Подразделение']=$org_names[$rec['parent3']].' => '.$org_names[$data['parent3']] ;
                 for ($i=4;$i<=9;$i++) if ($data['parent'.$i]!=$rec['parent'.$i])  $arr_changes['Подразделение (уровень'.($i-2).')']=$org_names[$rec['parent'.$i]].' => '.$org_names[$data['parent'.$i]] ;
        }

            $data_so['parent']=$data['parent'] ;
            for ($i=1;$i<=9;$i++)  $data_so['parent'.$i]=($data['parent'.$i])? $data['parent'.$i]:0 ;
        }

       // $this->check_fired($form_data,$rec,$data,$arr_changes,array('clear_propusk_to_fired'=>1)) ;

	    if (isset($form_data['adres']) and $form_data['adres']!=$rec['adres'])  { $data['adres']=$form_data['adres'] ;  $arr_changes['Адрес']=$rec['adres'].' => '.$form_data['adres'] ; }
	    if (isset($form_data['driving']) and $form_data['driving']!=$rec['driving'])  { $data['driving']=$form_data['driving'] ;  $arr_changes['Вод.уд.']=$rec['driving'].' => '.$form_data['driving'] ; }
        if (isset($form_data['driving_date']) and strtotime($form_data['driving_date'])!=$rec['driving_date'])  { $data['driving_date']=strtotime($form_data['driving_date']) ;  $arr_changes['Вод.уд.']=date('d.m.Y',$rec['driving_date']).' => '.$form_data['driving_date'] ; }
        if (isset($form_data['driving_validity_period']) and strtotime($form_data['driving_validity_period'])!=$rec['driving_validity_period'])  { $data['driving_validity_period']=strtotime($form_data['driving_validity_period']) ;  $arr_changes['Вод.уд.']=date('d.m.Y',$rec['driving_validity_period']).' => '.$form_data['driving_validity_period'] ; }
	    if (isset($form_data['tab_number']) and $form_data['tab_number']!=$rec['tab_number'])  { $data['tab_number']=$form_data['tab_number'] ;  $arr_changes['Таб.номер']=$rec['tab_number'].' => '.$form_data['tab_number'] ; }
	    if (isset($form_data['snils']) and $form_data['snils']!=$rec['snils'])  { $data['snils']=$form_data['snils'] ;  $arr_changes['СНИЛС']=$rec['snils'].' => '.$form_data['snils'] ; }
	    if (isset($form_data['stazh']) and $form_data['stazh']!=$rec['stazh'])  { $data['stazh']=$form_data['stazh'] ;  $arr_changes['Стаж общий']=$rec['stazh'].' => '.$form_data['stazh'] ; }
	    if (isset($form_data['stazh_last']) and $form_data['stazh_last']!=$rec['stazh_last'])  { $data['stazh_last']=$form_data['stazh_last'] ;  $arr_changes['Стаж последний']=$rec['stazh_last'].' => '.$form_data['stazh_last'] ; }
        if (isset($form_data['email']) and $form_data['email']!=$rec['email'])  { $data['email']=$form_data['email'] ;  $arr_changes['E-mail']=$rec['email'].' => '.$form_data['email'] ; }
	    if (isset($form_data['propusk']) and strcmp($form_data['propusk'],$rec['propusk']))
	    { // проверяем что пропуск не занят
	      $pass_check=execSQL_value('select pkey from obj_site_personals where propusk="'.$form_data['propusk'].'"')  ;
	      if (!$pass_check)
          {   $data['propusk']=$form_data['propusk'] ;
              $arr_changes['Пропуск']=$rec['propusk'].' => '.$form_data['propusk'] ;
              // propusk_uptime сохраняем только если пропуск изменен
              if (isset($form_data['propusk_uptime']) and $form_data['propusk_uptime']!=$rec['propusk_uptime'])
                { $data['propusk_uptime']=$form_data['propusk_uptime'] ;
                  $arr_changes['Дата смены пропуска']=date('d.m.Y H:i:s',$rec['propusk_uptime']).' => '.date('d.m.Y H:i:s',$form_data['propusk_uptime']) ;
                }
          }
	      else
          {// TODO - добавить в ответ функции что пропуск занят для вывода на экране


          }
	    }
	    if (isset($form_data['full_access']) and $form_data['full_access']!=$rec['full_access'])  { $data['full_access']=$form_data['full_access'] ;  $arr_changes['Полный доступ']=$this->arr_no_yes[$rec['full_access']].' => '.$this->arr_no_yes[$form_data['full_access']]  ; }
	    if (isset($form_data['mo_block']) and $form_data['mo_block']!=$rec['mo_block'])  { $data['mo_block']=$form_data['mo_block'] ;  $arr_changes['Запрет МО']=$this->arr_no_yes[$rec['mo_block']].' => '.$this->arr_no_yes[$form_data['mo_block']]  ; }
	    if (isset($form_data['demo_access']) and $form_data['demo_access']!=$rec['demo_access'])  { $data['demo_access']=$form_data['demo_access'] ;  $arr_changes['Демо-аккаунт']=$this->arr_no_yes[$rec['demo_access']].' => '.$this->arr_no_yes[$form_data['demo_access']]  ; }
		if (isset($form_data['s_medspravka']) and $form_data['s_medspravka']!=$rec['s_medspravka'])
	    { $data['s_medspravka']=$form_data['s_medspravka'] ;
	      $arr_changes['Мед.справка от']=date('d.m.Y',$rec['s_medspravka']).' => '.date('d.m.Y',$form_data['s_medspravka']) ;
	    }
        if (isset($form_data['email']) and $form_data['email']!=$rec['email'])  { $data['email']=$form_data['email'] ;  $arr_changes['email']=$rec['email'].' => '.$form_data['email']  ; }

        //для модуля "Печать нарядов" PRINT_ORDER
        if (isset($form_data['print_order_type']) and $form_data['print_order_type']!=$rec['print_order_type'])  { $data['print_order_type']=$form_data['print_order_type'] ;  $arr_changes['Тип печатаемого наряда']=$rec['print_order_type'].' => '.$form_data['print_order_type']  ; }
        if (isset($form_data['print_order_URL']) and $form_data['print_order_URL']!=$rec['print_order_URL'])  { $data['print_order_URL']=$form_data['print_order_URL'] ;  $arr_changes['URL для печати наряда']=$rec['print_order_URL'].' => '.$form_data['print_order_URL']  ; }
        if (isset($form_data['print_order_time_from']) and $form_data['print_order_time_from']!=$rec['print_order_time_from'])  { $data['print_order_time_from']=$form_data['print_order_time_from'] ;  $arr_changes['Время с которого разрешено печатать наряд']=$rec['print_order_time_from'].' => '.$form_data['print_order_time_from']  ; }
        if (isset($form_data['print_order_time_to']) and $form_data['print_order_time_to']!=$rec['print_order_time_to'])  { $data['print_order_time_to']=$form_data['print_order_time_to'] ;  $arr_changes['Время до которого разрешено печатать наряд']=$rec['print_order_time_to'].' => '.$form_data['print_order_time_to']  ; }


	    $this->check_fired($form_data,$rec,$data,$arr_changes,0,$options) ;

		// траслируем изменения по отложенному увольнению на каждую должность отдельно
		// !!! функция "personal_save" не вызывается из i_personal_import при изменениях по СО, поэтому это будет отрабатывать только там где идет обращение напрямую к физическому лицу
		$worker_form_data=array() ;
		if (isset($form_data['close_fired_pause']))  $worker_form_data['close_fired_pause']=$form_data['close_fired_pause'] ;
		if (isset($form_data['fired_pause_cancel'])) $worker_form_data['fired_pause_cancel']=$form_data['fired_pause_cancel'] ;
		if (isset($form_data['fired_manual']))       $worker_form_data['fired_manual']=$form_data['fired_manual'] ;
		if (isset($form_data['fired']))              $worker_form_data['fired']=$form_data['fired'] ;
		if (_sizeof($worker_form_data))
		{   $worker_ids=execSQL_line('select pkey from obj_site_workers where personal_id='.$rec['pkey']) ;
			if (_sizeof($worker_ids)) foreach($worker_ids as $worker_id) PERSONAL()->worker_save($worker_id,$worker_form_data,$options) ;
		}
          // прием на работу только при смене организации должности статуса
	  // 11.08.22 - смена работы только при смене организации
          if ($arr_changes['Организация'] /*or $arr_changes['Должность']*/ or $data['enabled']==1)
          { $data['job_data']=time() ;
            $arr_changes['Дата вхождения в должность']=date('d.m.Y H:i') ;
          }

		if (_sizeof($data) and  !$options['read_only'])
        { $res_update=update_rec_in_table($this->table_personal,$data,'pkey='.$rec['pkey'],array('debug'=>0)) ;
          if (_sizeof($data_so)) update_rec_in_table('obj_site_workers',$data_so,'personal_id='.$rec['pkey'],array('debug'=>0)) ;

        }
        //echo 'data:' ; print_r($data) ; echo '<br>' ;
		//echo 'res:' ; print_r($res_update) ; echo '<br>' ;

	    $text=ob_get_clean() ;
	    echo $text ;
	    if (_sizeof($arr_changes) and !$options['read_only'])
	    { if ($options['source_fname']) $text.='<div><a href="'.$options['source_fname'].'" target="_blank">Источник</a></div>' ;
	      // старый вариант хранения в логе
	      //LOGS()->reg_log($event_title,$text,array('data'=>$arr_changes,'personal_id'=>$rec['pkey'],'reffers'=>array($rec['_reffer']))) ;
	      // новый вариант хранения в логе
          foreach($arr_changes as $fname=>$change)
          {   if (stripos($change,'=>')!==false) list($old_value,$new_value)=explode('=>',$change) ;
              else
              { $old_value='' ;
                $new_value=$change ;
              }
              $this->log_personal_change($rec['pkey'],0,0,$fname,trim($old_value),trim($new_value),$options['source_action']) ;
          }

	      $GLOBALS['personals_changes'][$rec['pkey']]['name']='<a href="/window/personal/person/'.$rec['pkey'].'/" class="new_window">'.$rec['obj_name'].'</a>' ;
		  $GLOBALS['personals_changes'][$rec['pkey']]['changes']['Физ.лицо']=$arr_changes ;

	    }

        $result=($options['return_changes'])? $arr_changes:$res_update ;
	  }
	  return($result) ;
	}

    function log_personal_change($personal_id,$worker_id,$worker_type,$fname,$old_value,$new_value,$source='')
    { //trace() ;
      $rec=array(   'clss'=>277,
                    'indx'=>1,
                    'obj_name'=>'upd',
                    'account_id'=>(MEMBER()->id)? MEMBER()->id:0,
                    'personal_id'=>$personal_id,
                    'worker_id'=>$worker_id,
                    'worker_type'=>$worker_type,
                    'fname'=>$fname,
                    'old_value'=>$old_value,
                    'new_value'=>$new_value,
                    'source'=>substr($source,0,128)
                ) ;
      //damp_array($rec,1,-1);
      adding_rec_to_table('log_personal_changes',$rec) ;
    }

	function worker_save($reffer,$form_data,$options=array())
	{ //damp_array($form_data,1,-1) ;

	  $rec=$this->get_worker_by_id($reffer) ; $res=array() ; // damp_array($rec,1,-1) ;
	  if ($rec['pkey'] and _sizeof($form_data))
	  {  // определяем, какие поля были изменены
	    $arr_changes=array() ;  $data=array() ;
		ob_start() ;
	    if (isset($form_data['personal_id']) and $form_data['personal_id']!=$rec['personal_id'])  { $data['personal_id']=$form_data['personal_id'] ;  $arr_changes['personal_id']=$rec['personal_id'].' => '.$form_data['personal_id'] ; }
	    if (isset($form_data['uid']) and $form_data['uid']!=$rec['uid'])  { $data['uid']=$form_data['uid'] ;  $arr_changes['UID']=$rec['uid'].' => '.$form_data['uid'] ; }
	    if (isset($form_data['is_main']) and $form_data['is_main']!=$rec['is_main'])  { $data['is_main']=$form_data['is_main'] ;  $arr_changes['is_main']=$rec['is_main'].' => '.$form_data['is_main'] ; }
	    if (isset($form_data['is_second']) and $form_data['is_second']!=$rec['is_second'])  { $data['is_second']=$form_data['is_second'] ;  $arr_changes['is_second']=$rec['is_second'].' => '.$form_data['is_second'] ; }
	    if (isset($form_data['inrm']) and $form_data['inrm']!=$rec['inrm'])  { $data['inrm']=$form_data['inrm'] ;  $arr_changes['inrm']=$rec['inrm'].' => '.$form_data['inrm'] ; }
	    if (isset($form_data['status']) and $form_data['status']!=$rec['status'])  { $data['status']=$form_data['status'] ;  $arr_changes['status']=$rec['status'].' => '.$form_data['status'] ; }
		if (isset($form_data['working_name']) and trim($form_data['working_name'])!="") $form_data['work_id']=_IL('IL_works')->get_id_of_value(trim($form_data['working_name']),array('append_value_is_not_found'=>1)) ;
	    if (isset($form_data['work_id']) and $form_data['work_id']!=$rec['work_id'])
	    { $data['work_id']=$form_data['work_id'] ;
		  $arr_changes['Должность']=_IL('IL_works')->recs_names[$rec['work_id']].' => '._IL('IL_works')->recs_names[$form_data['work_id']]  ;
	    }

		$parent=0 ;
	    if (isset($form_data['parent']) and $form_data['parent']>0)  $parent=$form_data['parent'] ;
        if (isset($form_data['org_id']) and $form_data['org_id']>0)  $parent=$form_data['org_id'] ;
        if (isset($form_data['otdel_id']) and $form_data['otdel_id']>0)  $parent=$form_data['otdel_id'] ;
        if (isset($form_data['otdel_id2']) and $form_data['otdel_id2']>0)  $parent=$form_data['otdel_id2'] ;
        if (isset($form_data['otdel_id3']) and $form_data['otdel_id3']>0)  $parent=$form_data['otdel_id3'] ;
        if (isset($form_data['otdel_name']) and $form_data['otdel_name']!="")  $parent=LISTS()->get_rec_id_by_name($form_data['otdel_name'],208,$form_data['org_id'],$this->table_personal) ;
        if ($parent>0 /*and $parent!=$rec['parent']*/)
        {  $data['parent']=$parent ;
           // заполняем уровни parent по новой системе, в data будет правильные ID уровней
           $this->full_parent_levels_to_rec($parent,$data) ;
           if ($rec['parent']!=$data['parent'] or $rec['parent1']!=$data['parent1'] or $rec['parent2']!=$data['parent2'] or $rec['parent3']!=$data['parent3'] or $rec['parent4']!=$data['parent4'] or $rec['parent5']!=$data['parent5'] or $rec['parent6']!=$data['parent6'] or $rec['parent7']!=$data['parent7'] or $rec['parent8']!=$data['parent8'] or $rec['parent9']!=$data['parent9'])
           {   $arr=array() ;
               for ($i=2;$i<=9;$i++)
               {  if ($data['parent'.$i]) $arr[]=$data['parent'.$i] ; else $data['parent'.$i]=0 ;
                  if ($rec['parent'.$i]) $arr[]=$rec['parent'.$i] ;   else $rec['parent'.$i]=0 ;
               }
           if (_sizeof($arr)) $org_names=execSQL_row('select pkey,obj_name from obj_site_personals where clss in (207,208) and pkey in ('.implode(',',$arr).')') ;  else $org_names=array() ;
           if ($data['parent2']!=$rec['parent2'])  $arr_changes['Организация']=$org_names[$rec['parent2']].' => '.$org_names[$data['parent2']] ;
           if ($data['parent3']!=$rec['parent3'])  $arr_changes['Подразделение']=$org_names[$rec['parent3']].' => '.$org_names[$data['parent3']] ;
               for ($i=4;$i<=9;$i++) if ($data['parent'.$i]!=$rec['parent'.$i])  $arr_changes['Подразделение (уровень'.($i-2).')']=$org_names[$rec['parent'.$i]].' => '.$org_names[$data['parent'.$i]] ;
           }
        }

		$this->check_fired($form_data,$rec,$data,$arr_changes,0,$options) ;

        // прием на работу только при смене организации должности статуса
        if ($arr_changes['Организация'] or $arr_changes['Должность'] or $data['enabled']==1)
          {  // временный костыль
             if ($rec['work_id']==$GLOBALS['LS_magnit_work_id_from'] and $form_data['work_id']==$GLOBALS['LS_magnit_work_id_to'])
             {
                 $arr_changes['Дата вхождения в должность']='Не фиксируется, для исключения вводного инструктажа' ;
             }
             else
          { $data['job_data']=time() ;
            $arr_changes['Дата вхождения в должность']=date('d.m.Y H:i') ;
           }
          }


		if (!$options['read_only'] and _sizeof($data)) $res=update_rec_in_table('obj_site_workers',$data,'pkey='.$rec['pkey'],array('debug'=>0)) ;

	    $event_title=($options['event_title'])? $options['event_title']:'Измение СО' ;
		$work_type='-' ; $work_type_id=0 ;
	    if (isset($data['is_main']) and $data['is_main']) { $work_type='основной должности' ; $work_type_id=1 ; }
		elseif (isset($data['is_second']) and $data['is_second']) { $work_type='должности по совмещению' ; $work_type_id=2 ; }
		else if ($rec['is_main']) { $work_type='Основная должность' ;$work_type_id=1 ; }
		else if ($rec['is_second']) { $work_type='Должность по совмещению' ; $work_type_id=2 ; }

	    $text=ob_get_clean() ;
	    echo $text ;
	    $personal_reffer=$rec['personal_id'].'.'._DOT('obj_site_personals')->pkey ;
	    if (_sizeof($arr_changes))
	    { if ($options['source_fname']) $text.='<div><a href="'.$options['source_fname'].'" target="_blank">Источник</a></div>' ;
          // старый вариант хранения в общем логе
	      //LOGS()->reg_log($event_title,$work_type.$text,array('data'=>$arr_changes,'personal_id'=>$rec['personal_id'],'reffers'=>array($personal_reffer))) ;
          // новый вариант хранения в отдельном логе
          foreach($arr_changes as $fname=>$change)
          {   if (stripos($change,'=>')!==false) list($old_value,$new_value)=explode('=>',$change) ;
              else
              { $old_value='' ;
                $new_value=$change ;
              }
              $this->log_personal_change($rec['personal_id'],$rec['pkey'],$work_type_id,$fname,trim($old_value),trim($new_value),$options['source_action']) ;
          }


		  $GLOBALS['personals_changes'][$rec['personal_id']]['name']='<a href="/window/personal/person/'.$rec['personal_id'].'/" class="new_window">'.$rec['personal_name'].'</a>' ;
		  $GLOBALS['personals_changes'][$rec['personal_id']]['changes'][$work_type]=$arr_changes ;
	    }
	    if ($options['show_changes']) damp_array($arr_changes,1,-1) ;
	  }
	  return($res) ;
	}

	// проверка на увольнение и отложенное увольнение
	// одна функция для сотрудников и для персон
	function check_fired($form_data,$rec,&$data,&$arr_changes,$check_time=0,$options=array())
	{   if (!$check_time)  $check_time=time() ;
		// ручной сброс отложенного увольнения - только для включенных аккаунтов
	    if ($form_data['fired_pause_cancel'] and $rec['enabled'] and $rec['fired_data_pause'])
	    { $data['fired_data_pause']=0 ;
	      $data['fired_data']=0 ;
		  $arr_changes['Отложенное увольнение']=date('d.m.Y',$rec['fired_data_pause']).' => отмена'  ;
	    }


	    // обычное увольнение через форму - выведено в fired_manual чтобы не путать с обычным  fired, которе идет с импорта
		// fired обрабатывается только если  выключено отложенное увольнение LS_fired_pause_day=0
		// только для включенных аккаунтов
		//damp_array($form_data,1,-1) ;
	    if (($form_data['fired_manual'] or ($form_data['fired'] and !$GLOBALS['LS_fired_pause_day'])) and $rec['enabled'])
	    {  $data['fired_data']=time() ;
	       $data['enabled']=0 ;
	       $data['fired_data_pause']=0 ;
	       if ($options['clear_propusk_to_fired']) $form_data['propusk']='id'.$rec['pkey'] ;
		   $arr_changes['Уволен']='Нет => Да'  ;
		   $arr_changes['Статус сотрудника']='Уволен'  ;
	    }

        // передана дата увольнения, но нет флага fired
        if (!$form_data['fired'] and $form_data['fired_data'] and $rec['enabled'])
        {
            // если дата увольнения еще не наступила
            if ($form_data['fired_data']>time())
            {
                $data['fired_data_pause']=0 ;
                $data['fired_data']=$form_data['fired_data'] ;
                $arr_changes['Статус сотрудника']='Предстоящее увольнение с '.date('d.m.Y',$data['fired_data'])  ;
            }
            // если дата увольнения наступила и включено отложенное увольнение
            else if ($GLOBALS['LS_fired_pause_day'])
            {
                $now=getdate() ;
                $sec=$GLOBALS['LS_fired_pause_day']*24*60*60 ;
                $to=mktime($now['hours'],$now['minutes'],$now['seconds']+$sec,$now['mon'],$now['mday'],$now['year']);
                $data['fired_data_pause']=$to ;
                $data['fired_data']=$form_data['fired_data'] ;
                $arr_changes['Статус сотрудника']='Отложенное увольнение до '.date('d.m.Y',$to)  ;
            }
            // если  дата увольнения наступила и выключено отложенное увольнение
            else
            {
                $data['enabled']=0 ;
                $data['fired_data_pause']=0 ;
                if ($options['clear_propusk_to_fired']) $form_data['propusk']='id'.$rec['pkey'] ;
                $arr_changes['Статус сотрудника']='Отложенное увольнение => Уволен'  ;
            }
        }


	    // увольнение для импорта -
	    if ($form_data['fired'] and $rec['enabled'] and $GLOBALS['LS_fired_pause_day']>0)
	    {     if (!$rec['fired_data_pause'])
	          { $now=getdate() ;
                $sec=$GLOBALS['LS_fired_pause_day']*24*60*60 ;
                $to=mktime($now['hours'],$now['minutes'],$now['seconds']+$sec,$now['mon'],$now['mday'],$now['year']);
                $data['fired_data_pause']=$to ;
                $data['fired_data']=time() ;
                $arr_changes['Статус сотрудника']='Отложенное увольнение до '.date('d.m.Y',$to)  ;
	          }
	          // если задано - проверяем, не прошел ли срок ожидания увольнения
	          else if ($rec['fired_data_pause'] and ($rec['fired_data_pause']<time() or $form_data['close_fired_pause']))
	          { $data['enabled']=0 ;
	            $data['fired_data_pause']=0 ;
                if ($options['clear_propusk_to_fired']) $form_data['propusk']='id'.$rec['pkey'] ;
		        $arr_changes['Статус сотрудника']='Отложенное увольнение => Уволен'  ;
	          }
	    }

	    // передано  $form_data['fired']=0 или  $form_data['fired_manual']=0
	    if (((isset($form_data['fired']) and !$form_data['fired']) or (isset($form_data['fired_manual']) and !$form_data['fired_manual'])))
	    { // если сотрудник в статусе отложенного увольнения
	      if ($rec['fired_data_pause'])
	      {  $arr_changes['Отложенное увольнение']=date('d.m.Y',$rec['fired_data_pause']).' => отмена'  ;
		     $data['fired_data']=0 ;
		     $data['fired_data_pause']=0 ;
		     //$data['enabled']=1 ;
	      }
	      elseif (!$rec['enabled'])
	      {   $data['fired_data']=0 ;
		      $data['fired_data_pause']=0 ;
		      $data['enabled']=1 ;
		      $arr_changes['Статус сотрудника']='Уволен => Восстановлен'  ;
	      }
	    }

	}

    function get_org_id_by_name($name,$options=array())
    {   $name=trim($name) ;
        $id=execSQL_value('select pkey from obj_site_personals where obj_name like "'.addslashes($name).'" and clss=207') ;
        if (!$id and $options['create_if_not_exists']) $id=PERSONAL()->create_org(array('obj_name'=>$name)) ;
        if (!$id) $id=0 ;
        return($id) ;
    }

    function get_otdel_id_by_name($org_id,$name,$options=array())
    {   $name=trim($name) ;
        $id=execSQL_value('select pkey from obj_site_personals where obj_name like "'.addslashes($name).'" and clss=208 and parent='.$org_id) ;
        if (!$id and $options['create_if_not_exists']) $id=PERSONAL()->create_otdel($org_id,array('obj_name'=>$name)) ;
        if (!$id) $id=0 ;
        return($id) ;
    }

    function personal_create($form_data,$options=array())
    { ob_start() ;
      $data=array('parent'=>1,'clss'=>211,'indx'=>1) ; // damp_array($form_data,1,-1) ;
      if (isset($form_data['uid']))  $data['uid']=$form_data['uid'] ;
      else                           $data['uid']='esmo_'.ENGINE()->generate_UID() ;
      if (isset($form_data['propusk']))  $data['propusk']=$form_data['propusk'] ;
      if (isset($form_data['driving']))  $data['driving']=$form_data['driving'] ;
      if (isset($form_data['tab_number']))  $data['tab_number']=$form_data['tab_number'] ;
      if (isset($form_data['obj_name']))     $data['obj_name']=$form_data['obj_name'] ;
      if (isset($form_data['name']))     $data['obj_name']=$form_data['name'] ;
      if (isset($form_data['dr']))       $data['dr']=$form_data['dr'] ;
	  if ($data['dr'])                   $data['age']=ENGINE()->get_age_by_dr($data['dr']) ;
      if (isset($form_data['pol']))      $data['pol']=$form_data['pol'] ;
      if (isset($form_data['adres']))    $data['adres']=$form_data['adres'] ;

      if (isset($form_data['permit']))    $data['permit']=$form_data['permit'] ;
      if (isset($form_data['PersonLicense']))    $data['PersonLicense']=$form_data['PersonLicense'] ;
      if (isset($form_data['snils']))    $data['snils']=$form_data['snils'] ;
      if (isset($form_data['company']))  $data['parent']=$form_data['company'] ;
      if (isset($form_data['danger']))  $data['danger']=$form_data['danger'] ;
      if (isset($form_data['full_access']))  $data['full_access']=$form_data['full_access'] ;
      if (isset($form_data['client_id']))  $data['client_id']=$form_data['client_id'] ;
      //if (isset($form_data['otdel']))    $data['parent']=$form_data['otdel'] ;
      if ($form_data['org_name'])          $form_data['org_id']=$this->get_org_id_by_name($form_data['org_name'],array('create_if_not_exists'=>1)) ;
      if ($form_data['org_id'])          $data['parent']=$form_data['org_id'] ;
      if ($form_data['org_id'] and $form_data['otdel_name'])      $form_data['otdel_id']=$this->get_otdel_id_by_name($form_data['org_id'],$form_data['otdel_name'],array('create_if_not_exists'=>1)) ;

      if ($form_data['org_id'] and $form_data['otdel_id'])        $data['parent']=$form_data['otdel_id'] ;
      if (isset($form_data['working_name']) and trim($form_data['working_name'])) $data['working']=_IL('IL_works')->get_id_of_value(trim($form_data['working_name']),array('append_value_is_not_found'=>1)) ;
      if (isset($form_data['working']))  $data['working']=$form_data['working'] ;
      if ($data['dr'])                   $data['age']=ENGINE()->get_age_by_dr($data['dr']) ;
      if ($form_data['to_extlist'])      $data['ext']=1 ;
      if ($form_data['full_access'])      $data['full_access']=1 ;
      if ($form_data['demo_access'])      $data['demo_access']=1 ;
      //if (isset($form_data['smena_s']))  $data['smena_s']=$form_data['smena_s'] ;
      //if (isset($form_data['smena_e']))  $data['smena_e']=$form_data['smena_e'] ;
      if (isset($form_data['s_medspravka']))
      { $data['s_medspravka']=strtotime($form_data['s_medspravka']) ;
        // в $form_data['s_medspravka'] может быть передано уже готовое число
        if (!$data['s_medspravka'] and $form_data['s_medspravka']) $data['s_medspravka']=$form_data['s_medspravka'] ;
        if (!$data['s_medspravka']) $data['s_medspravka']=0;
      }
      // заполняем уровни parent по новой системе
      if ($data['parent']>1) $this->full_parent_levels_to_rec($data['parent'],$data) ;

      // дополнение для st-server - есть в группе, где MEMBER есть клиент, то автоматически нового сотрудника связать с этим клиентом
      //ob_start() ;
      if (MEMBER()->cur_group_id)
      { $client_id=execSQL_value('select pkey from obj_site_account where clss=210 and rol=6 and enabled=1 and parent='.MEMBER()->cur_group_id) ;
      if ($client_id and !$data['client_id']) $data['client_id']=$client_id ;
      }
      //$text=ob_get_clean() ;
      //LOGS()->reg_log('auto set client_id',$text) ;

      $member_reffer=adding_rec_to_table($this->table_personal,$data,array('return_reffer'=>1,'debug'=>0)) ;
      list($personal_id,$personal_tkey)=explode('.',$member_reffer) ;
      $event_title=($options['event_title'])? $options['event_title']:'Добавление нового физ.лица' ;
      $text=ob_get_clean() ;
      LOGS()->reg_log($event_title,$text,array('data'=>$data,'personal_id'=>$personal_id,'reffers'=>array($member_reffer))) ;
      return($member_reffer) ;
    }

    function worker_create($form_data,$options=array())
    { ob_start() ;
      $data=($options['use_multiSQL_insert'])? ENGINE()->get_default_rec_of_clss(212):array() ;
      $data['clss']=212 ;
      $data['parent']=1 ;
      $data['parent1']=1 ;
      $data['indx']=1 ;
      if (isset($form_data['uid']))  $data['uid']=$form_data['uid'] ;
      if (isset($form_data['personal_id']))  $data['personal_id']=$form_data['personal_id'] ;
      if ($form_data['org_id'])          { $data['parent']=$form_data['org_id'] ; $data['parent2']=$form_data['org_id'] ; }
      if ($form_data['otdel_id'])        { $data['parent']=$form_data['otdel_id'] ; $data['parent3']=$form_data['otdel_id'] ; }

      if ($form_data['parent'])        $data['parent']=$form_data['parent'] ;
      if ($form_data['parent1'])        $data['parent1']=$form_data['parent1'] ;
      if ($form_data['parent2'])        $data['parent2']=$form_data['parent2'] ;
      if ($form_data['parent3'])        $data['parent3']=$form_data['parent3'] ;
      if ($form_data['parent4'])        $data['parent4']=$form_data['parent4'] ;
      if ($form_data['parent5'])        $data['parent5']=$form_data['parent5'] ;
      if ($form_data['parent6'])        $data['parent6']=$form_data['parent6'] ;
      if ($form_data['parent7'])        $data['parent7']=$form_data['parent7'] ;
      if ($form_data['parent8'])        $data['parent8']=$form_data['parent8'] ;
      if ($form_data['parent9'])        $data['parent9']=$form_data['parent9'] ;
      if ($form_data['level'])          $data['level']=$form_data['level'] ;

      if ($form_data['otdel_name'])      $data['parent']=LISTS()->get_rec_id_by_name($form_data['otdel_name'],208,$form_data['org_id'],$this->table_personal) ;
      if (isset($form_data['working_name'])) $data['work_id']=LISTS()->get_rec_id_by_name($form_data['working_name'],20,32,TM_LIST) ;
      if (isset($form_data['work_id']))  $data['work_id']=$form_data['work_id'] ;
      if (isset($form_data['is_main']))  $data['is_main']=$form_data['is_main'] ;
      if (isset($form_data['is_second']))  $data['is_second']=$form_data['is_second'] ;
      if (isset($form_data['fired_data']))  $data['fired_data']=$form_data['fired_data'] ;
      if (isset($form_data['job_data']))  $data['job_data']=$form_data['job_data'] ;

	  // заполняем уровни parent по новой системе
      //$this->full_parent_levels_to_rec($data['parent'],$data) ;

	  //$arr_changes['Организация']=PERSONAL()->get_org_names_by_ids($data['parent2']) ;
	  //$arr_changes['Подразделение']=PERSONAL()->get_org_names_by_ids($data['parent3']) ;
	  //$arr_changes['Должность']=_IL('IL_works')->recs[$data['work_id']]['obj_name'] ;
	  //$work_status='' ;
	  //if ($data['is_main']) $work_status='Основная должность' ;
	  //if ($data['is_second']) $work_status='Должность по совмещению' ;


      if ($options['use_multiSQL_insert']) multiSQL_insert('obj_site_workers')->append($data) ;
      else  adding_rec_to_table('obj_site_workers',$data,array('return_reffer'=>1,'debug'=>0,'no_return_id'=>1)) ;
      //$event_title=($options['event_title'])? $options['event_title']:'Добавление нового места работы' ;
	  //$personal_reffer=$data['personal_id'].'.'._DOT('obj_site_personals')->pkey ;
      $text=ob_get_clean() ;
      $text_log=array() ;
      if ($options['log_comment']) $text_log[]=$options['log_comment'];
      if ($text)                   $text_log[]=$text  ;
      echo $text ;
      LOGS()->reg_log('worker_create',implode('<br>',$text_log),array('personal_id'=>$data['personal_id'],'use_multiSQL_insert'=>$options['use_multiSQL_insert'],$options['log_comment'])) ;
      return(true) ;
    }

    // заполняет поля parent1,parent3,parent3... для item
    function full_parent_levels_to_rec($parent,&$data)
    {  $rec_parent_section=execSQL_van('select pkey,level,parent,parent1,parent2,parent3,parent4,parent5,parent6,parent7,parent8,parent9 from obj_site_personals where pkey='.$parent) ;
       if ($rec_parent_section['level']) for ($i=1;$i<$rec_parent_section['level'];$i++)  $data['parent'.$i]=$rec_parent_section['parent'.$i] ;
       else $data['parent1']=1 ;
       $data['parent'.$rec_parent_section['level']]=$data['parent'] ;
    }

    function get_personal_list($options=array())
    { $_usl=array() ;
      $_usl[]='clss=211' ;
      if (!$options['and_disabled']) $_usl[]='enabled=1' ;
      if ($options['ext']) $_usl[]='ext=1' ;
      if ($options['id'] and is_array($options['id'])) $_usl[]='pkey in ('.implode(',',$options['id']).')' ;
      if ($options['id'] and !is_array($options['id'])) $_usl[]='pkey in ('.$options['id'].')' ;
      $usl=implode(' and ',$_usl) ;
      $sort_mode=$options['order']? $options['order']:'obj_name' ;
      $recs=execSQL('select * from '.$this->view_personal.' where '.$usl.' order by '.$sort_mode) ;
      if (_sizeof($recs)) foreach($recs as $id=>$rec) $this->prepare_public_info_to_personal($recs[$id]) ;
      return($recs) ;
    }


    function get_personal_by_id($id,$options=array())
    {   list($pkey,$tkey)=explode('.',$id) ;
        $rec=array() ;
        if ($pkey)
        { $rec=execSQL_van('select * from '.$this->view_personal.' where pkey="'.$pkey.'"') ;
          if ($rec['pkey'] and !$options['no_public_info']) $this->prepare_public_info_to_personal($rec,$options) ;
        }
        return($rec) ;
    }

    function get_worker_by_id($id,$options=array())
    {   list($pkey,$tkey)=explode('.',$id) ;
        $rec=array() ;
        if ($pkey)
        { $rec=execSQL_van('select t1.*,t2.obj_name as personal_name 
							from obj_site_workers t1
							left join obj_site_personals t2 on t2.pkey=t1.personal_id 
							where t1.pkey="'.$pkey.'" ') ;
          //if ($rec['pkey'] and !$options['no_public_info']) $this->prepare_public_info_to_personal($rec,$options) ;
        }
        return($rec) ;
    }

    function get_workers_by_personal_id($id,$options=array())
    {   list($pkey,$tkey)=explode('.',$id) ;
        $rec=array() ;
        if ($pkey)
        { $recs=execSQL('select t1.* 
							from view_workers t1
							where t1.personal_id="'.$pkey.'" order by is_main desc') ;
          //if ($rec['pkey'] and !$options['no_public_info']) $this->prepare_public_info_to_personal($rec,$options) ;
        }
        return($recs) ;
    }

    function get_main_second_workers_by_personal_id($id)
    {
        $recs=$this->get_workers_by_personal_id($id) ;
        $orgs=array() ; $otdels=array() ; $workers=array() ;
        $arr['main']=[] ;
        $arr['second']=[] ;
        if (_sizeof($recs))
        { foreach($recs as $rec)
          {  if ($rec['is_main'])
             { $arr['main']=array('_org_name'=>$rec['_org_name'],'_otdel_name'=>$rec['_otdel_name'],'_work_name'=>$rec['_work_name']) ;
               $orgs['main']=$rec['_org_name'] ;
               $otdels['main']=$rec['_otdel_name'] ;
               $workers['main']=$rec['_work_name'] ;
             }
             if ($rec['is_second'])
             { $arr['second']=array('_org_name'=>$rec['_org_name'],'_otdel_name'=>$rec['_otdel_name'],'_work_name'=>$rec['_work_name']) ;
               $orgs['second']=$rec['_org_name'] ;
               $otdels['second']=$rec['_otdel_name'] ;
               $workers['second']=$rec['_work_name'] ;
             }
          }
          $arr['union']['_org_name']=($orgs['main']!=$orgs['second'])? implode(' / ',$orgs):$orgs['main'] ;
          $arr['union']['_otdel_name']=($otdels['main']!=$otdels['second'])? implode(' / ',$otdels):$otdels['main'] ;
          $arr['union']['_work_name']=($workers['main']!=$workers['second'])? implode(' / ',$workers):$workers['main'] ;
        }
        else
        { $rec=$this->get_personal_by_id($id,array('no_public_info'=>1)) ;

          $arr['main']=array('_org_name'=>$rec['_org_name'],'_otdel_name'=>$rec['_otdel_name'],'_work_name'=>_IL('IL_works')->recs[$rec['working']]['obj_name']) ;
          //damp_array($arr) ;
          $arr['union']['_org_name']=$arr['main']['_org_name'] ;
          $arr['union']['_otdel_name']=$arr['main']['_otdel_name'] ;
          $arr['union']['_work_name']=$arr['main']['_work_name'] ;
        }
        return($arr) ;
    }

    function set_personal_sign($personal_id, $sign_id)
    {
        if ($personal_id > 0 && $sign_id > 0) {
            $res = update_rec_in_table($this->table_personal,array('sign_id'=>$sign_id),'pkey='.$personal_id) ;
        }

        return $res;
    }

    function get_personal_sign_by_personal_id($personal_id)
    {
        $sign_id = execSQL_value("select sign_id from " . $this->table_personal . " where pkey = $personal_id and clss = 211");

        if (!$sign_id) {
            return false;
        }

        return $this->get_personal_sign($sign_id);
    }

    function get_personal_sign($sign_id)
    {
        $val = execSQL_value("select obj_name from obj_" . SITE_CODE . "_mo_session_DTW where pkey = $sign_id and clss = 259");
        if (!$val) $val=file_get_contents(_DIR_TO_ROOT.'/public/mo_sign/'.$sign_id.'.data') ;
        return $val;
    }

    function get_personal_by_driver($driver)
    {   $rec=select_db_recs($this->table_personal,'driving="'.$driver.'"',array('no_arr'=>1,'debug'=>0)) ;
        if ($rec['pkey']) $this->prepare_public_info_to_personal($rec) ;
        return($rec) ;
    }
    function get_personal_by_name($name)
    {   $rec=select_db_recs($this->table_personal,'obj_name="'.$name.'"',array('no_arr'=>1,'debug'=>0)) ;
        if ($rec['pkey']) $this->prepare_public_info_to_personal($rec) ;
        return($rec) ;
    }

    function get_personal_by_URL($URL)
    {  $arr=explode('.',$URL) ;
       $rec=$this->get_personal_by_id($arr[0])  ;
       return($rec) ;
    }

    // ищет сотрудника по пропуску, номеру ВУ или табельному номеру
    function get_personal_by_propusk($id,$options=array())
    {   //$rec=$this->get_personal(array('propusk'=>$id,'driving'=>$id,'tab_number'=>$id),$options)  ;
	$rec=$this->get_personal(array('propusk'=>$id,'tab_number'=>$id),$options)  ;
        //$id=str_replace(array("'",'"','(',')',' ',"\n"),'',$id) ;
        //$usl_select='(propusk="'.$id.'" or driving="'.$id.'" or tab_number="'.$id.'")' ;
        //if ($options['dop_usl']) $usl_select.=' and '.$options['dop_usl'] ;
        //$rec=select_db_recs($this->table_personal,$usl_select,array('no_arr'=>1,'debug'=>0)) ;
        //if ($rec['pkey']) $this->prepare_public_info_to_personal($rec,$options) ;
        return($rec) ;
    }

    // ищет сотрудника по пропуску, номеру ВУ или табельному номеру
    function get_personal($fields=array(),$options=array())
    {   $arr=array() ;
        if (_sizeof($fields)) foreach($fields as $fname=>$fvalue) if ($fname=='propusk')
        {
            $pass_search_arr=[];
            $text_en=ENGINE()->translit(str_replace(array("'",'"','(',')',' ',"\n"),'',$fvalue)) ;
            $pass_search_arr[]=$fname.'="'.$text_en.'"';
            $text_ru=ENGINE()->translit2(str_replace(array("'",'"','(',')',' ',"\n"),'',$fvalue)) ;
            $pass_search_arr[]=$fname.'="'.$text_ru.'"';
            // конфертируем пропуск из HEX в DEC и наооборот
            if ($GLOBALS['LS_get_personal_propusk_convert_to_hex']) {
            $text_h=ENGINE()->convert_to_hex($fvalue) ;
                $pass_search_arr[]=$fname.' like "'.$text_h.'"';
            }
            if ($GLOBALS['LS_get_personal_propusk_convert_to_dec']) {
            $text_d=ENGINE()->convert_to_dec($fvalue) ;
                $pass_search_arr[]=$fname.' like "'.$text_d.'"';
            }
            if ($GLOBALS['LS_get_personal_propusk_convert_to_dec_as_is']) {
                $text_d=ENGINE()->convert_to_dec2($fvalue) ;
                $pass_search_arr[]=$fname.' like "'.$text_d.'"';
            }

            if ($GLOBALS['LS_get_personal_propusk_convert_to_hex_as_is']) {
                $text_d=ENGINE()->convert_to_hex2($fvalue) ;
                $pass_search_arr[]=$fname.' like "'.$text_d.'"';
            }

            //if (strlen($fvalue)==8) $text_d=ENGINE()->convert_to_dec2($fvalue) ; // прямое преобразование HEX->DEC
            $arr[]='('.implode(' or ',$pass_search_arr).')';
//            $arr[]='('.$fname.'="'.$text_en.'" or '.$fname.'="'.$text_ru.'" or '.$fname.' like "'.$text_h.'" or '.$fname.' like "'.$text_d.'")' ;
        }
        else $arr[]=$fname.'="'.$fvalue.'"' ;

        $usl_select='('.implode(' or ',$arr).')' ;
        if ($options['dop_usl']) $usl_select.=' and '.$options['dop_usl'] ;
        $rec=execSQL_van('select * from '.$this->view_personal.' where clss=211 and '.$usl_select.' order by c_data desc limit 1',array('debug'=>$options['debug'])) ;
        if ($options['loading_mo_from_file'] and !$rec['pkey'] and $fields['propusk']) {
            $rec=$this->create_unknown_person($fields);
        }
        if ($rec['pkey'] and !$options['no_public_info']) $this->prepare_public_info_to_personal($rec,$options) ;
        if (!$rec['pkey']) $rec['_reason']='Сотрудник не найден (#203)' ;
        return($rec) ;
    }

      function get_personal2($fields=array(),$options=array())
    {   $arr=array() ; $_usl=array() ;
        $_usl[]='clss=211' ;
        $_usl[]='_enabled=1' ;
        if (_sizeof($fields)) foreach($fields as $fname=>$fvalue) $arr[]=$fname.'="'.str_replace(array("'",'"','(',')',' ',"\n"),'',$fvalue).'"' ;
        $_usl[]='('.implode(' or ',$arr).')' ;
        if ($options['dop_usl']) $_usl[]=$options['dop_usl'] ;
        if ($options['only_enabled']) $_usl[]='enabled=1' ;
        $usl_select=implode(' and ',$_usl) ;
        $rec=select_db_recs($this->table_personal,$usl_select,array('no_arr'=>1,'debug'=>0)) ;
        if ($rec['pkey']) $this->prepare_public_info_to_personal($rec,$options) ;
        return($rec) ;
    }

    function get_personals($fields=array(),$options=array())
    { $arr=array() ;
      if (_sizeof($fields)) foreach($fields as $fname=>$fvalue)
      {   $text_en=ENGINE()->translit(str_replace(array("'",'"','(',')',' ',"\n"),'',$fvalue)) ;
          $text_ru=ENGINE()->translit2(str_replace(array("'",'"','(',')',' ',"\n"),'',$fvalue)) ;
          $arr[]='('.$fname.'="'.$text_en.'" or '.$fname.'="'.$text_ru.'")' ;
      }
      $usl_select='('.implode(' or ',$arr).')' ;
      if ($options['dop_usl']) $usl_select.=' and '.$options['dop_usl'] ;
      $sort_mode=$options['order']? $options['order']:'obj_name' ;
      $recs=select_db_recs($this->table_personal,$usl_select,array('order_by'=>$sort_mode,'count'=>$options['count'])) ;
      if (_sizeof($recs)) foreach($recs as $id=>$rec) $this->prepare_public_info_to_personal($recs[$id]) ;
      return($recs) ;
    }



    function search_personal_ids($text,$dop_usl='')
    { $text_en=ENGINE()->translit($text) ;
      $text_ru=ENGINE()->translit2($text) ;
      $dop_usl=($dop_usl)? ' and '.$dop_usl:'' ;
  /*    $res=execSQL_line('select pkey from '.$this->table_personal.' where clss=211 and enabled=1 '.$dop_usl.' and '.
                                                                        '(obj_name like "%'.$text.'%" or propusk="'.$text.'" or driving="'.$text.'" or'.
                                                                        ' obj_name like "%'.$text_en.'%" or propusk="'.$text_en.'" or driving="'.$text_en.'" or'.
                                                                        ' obj_name like "%'.$text_ru.'%" or propusk="'.$text_ru.'" or driving="'.$text_ru.'")') ;
    */
      $res=execSQL_line('select pkey from '.$this->table_personal.' where clss=211 and enabled=1 '.$dop_usl.' and '.
                                                                        '(obj_name like "%'.$text.'%" or propusk="'.$text.'" or'.
                                                                        ' obj_name like "%'.$text_en.'%" or propusk="'.$text_en.'" or'.
                                                                        ' obj_name like "%'.$text_ru.'%" or propusk="'.$text_ru.'" )') ;
      return($res) ;
    }


      // $number:  У824СУ333#1111   - номер авто#номер ВУ
      //           5016107044       - номер ВУ
      function whois_personal($number,$options=array())
         { $arr=explode('#',$number) ;
           if (_sizeof($arr)>1) {$car_number=$arr[0] ; $driving=$arr[1] ; }
           else                {$car_number=''; $driving=$arr[0] ;}
           // определяем организацию, к которой принаджежит автомобиль
           $driving=str_replace(array("'",'"','(',')',' ',"\n"),'',$driving) ;
           $car_number=str_replace(array("'",'"','(',')',' ',"\n"),'',$car_number) ;
           $rec_personal=array() ;  $rec_car=array() ; $usl_parent='' ;
           if ($car_number)
           { $car_number_en=ENGINE()->translit($car_number) ;
             $car_number_ru=ENGINE()->translit2($car_number) ;
             $rec_car=execSQL_van('select pkey,parent,obj_name from obj_site_personals_cars where clss=361 and enabled=1 and (obj_name="'.$car_number_en.'" or obj_name="'.$car_number_ru.'")') ;
             if ($rec_car['pkey']) $usl_parent=' parent in ('.$this->tree[$rec_car['parent']]->get_list_child().')'  ;
             else $rec_personal['_reason']='Автомобиль "'.$car_number.'" не найден (#201)' ;
           }
           if ($driving and !$rec_personal['_reason'])
           { if (!$options['set_QR_code'])
             { $options['set_QR_code']=$number ;  // учет сквозной передачи параметров через options
               $options['set_QR_code_text']='Номер авто: '.$car_number;  // учет сквозной передачи параметров через options

             }
             $options['dop_usl']=($usl_parent)? $usl_parent.' and enabled=1':'enabled=1' ;
             $options['only_enabled']=1;
             $rec_personal=$this->get_personal(array('propusk'=>$driving,'driving'=>$driving,'tab_number'=>$driving),$options) ;
             if ($rec_car['pkey'])  $rec_personal['_rec_car']=$rec_car ;
             if (!$rec_personal['pkey']) $rec_personal['_reason']='Сотрудник не найден (#202)' ;
           } else if (!$rec_personal['_reason']) $rec_personal['_reason']='Не введен номер ВУ' ;

           return($rec_personal) ;
         }

    function check_propusk($id)
    {  $rec=execSQL_van('select pkey,obj_name,ext from '.$this->table_personal.' where propusk="'.$id.'"') ;
       return($rec) ;

    }

    function prepare_public_info(&$rec,$options=array())
    {
      $this->prepare_public_info_to_personal($rec,$options) ;
    }

    function prepare_href_info_to_personal(&$rec,$options=array())
    {
        $rec['__href']=$this->root_dir.$this->person_dir_name.'/'.$rec['pkey'].'/' ;
        $rec['__href_window']='/window/personal/'.$this->person_dir_name.'/'.$rec['pkey'].'/' ;
    }

    function prepare_public_info_to_personal(&$rec,$options=array())
    { // если задан внешний обработчик
      if (isset($this->ext_public_system) and is_object($_SESSION['ext_public_system']) and method_exists($_SESSION['ext_public_system'],'prepare_public_info_to_personal'))
      { $_SESSION['ext_public_system']->prepare_public_info_to_personal($rec) ;
        return ;
      }

      $arr_name=explode(' ',$rec['obj_name']) ;
      $rec['_F']=$arr_name[0] ;
      $rec['_IO']=$arr_name[1] ; if ($arr_name[2]) $rec['_IO'].=' '.$arr_name[2] ;
      $rec['_I']=$arr_name[1] ;
      $rec['_FIO']=$arr_name[0].' '.mb_substr($arr_name[1],0,1).'.' ; if ($arr_name[2]) $rec['_FIO'].=' '.mb_substr($arr_name[2],0,1).'.' ;

      if ($options['check_uid']) {
          if (!$rec['uid']) {
              $rec['uid']='esmo_'.ENGINE()->generate_UID();
              $this->personal_save($rec['pkey'],$rec,array('source_action'=>'Автогенерация UID'));
          }
      }

      // полный путь к фото
      $rec['_image_dir']=($rec['_image_name'])? _DOT($this->table_personal.'_image')->dir_to_file.'source/'.$rec['_image_name']:'' ;
      // нет необходимости, так как фото с последней авторизации и так должно быть добавлено в карточку сотрудника
      //if (!$rec['_image_name'] or !file_exists($rec['_image_dir'])) $rec['_image_dir']=ESMO()->get_photo_auth_from_last_mo_session($rec['pkey']) ;
      $rec['_work_name']=_IL('IL_works')->recs[$rec['working']]['obj_name'] ;
      $rec['__href']=$this->root_dir.$this->person_dir_name.'/'.$rec['pkey'].'/' ;
      $rec['__href_window']='/window/personal/'.$this->person_dir_name.'/'.$rec['pkey'].'/' ;
      if ($options['get_ext_info'])
      { if (function_exists('PP')) $rec['_pupilomeria_cnt']=execSQL_value('select count(pkey) from obj_site_narko_data where personal_id='.$rec['pkey']) ;
        $rec['_mo_cnt']=execSQL_value('select count(pkey) from obj_site_mo_session where member_id='.$rec['pkey']) ;

      }
      if ($rec['ext_info']) { $rec['_ext_info']=unserialize($rec['ext_info']) ; unset($rec['ext_info']) ; }
      $rec['_pol']=($rec['pol'])? 'Жен.':'Муж.' ;
      // вписываем данные по компании и отделу

      // все организации будут на втором уровне, все подразделения - третьем
      //damp_array($rec) ;
      // вариант для использования дерева каталога в personal_system
      // в противном случае поля _org_id,_org_name,_otdel_name,_otdel_id будут заполнены из вьювера
      //$rec['_org_id']=$rec['parent2'] ;
      //$rec['_org_name']=_IL('ARR_deps')->recs_names[$rec['parent2']] ;
      //$rec['_otdel_id']=$rec['parent'] ;
      //$rec['_otdel_name']=$this->get_full_dep_name_by_dep_levels($rec,'','<br>') ;

      /*
      if (0 and isset($this->tree) and isset($this->tree[$rec['parent']]))
      { $arr_orgs=$this->tree[$rec['parent']]->get_arr_parent() ; // damp_array($arr_orgs) ;
        unset($arr_orgs[0]) ;
        $rec['_org_id']=$this->tree[$arr_orgs[1]]->pkey  ;
        $rec['_org_name']=$this->tree[$arr_orgs[1]]->name  ;
        unset($arr_orgs[1]) ;
        if (_sizeof($arr_orgs)==1)  { $rec['_otdel_id']=$arr_orgs[2]  ; $rec['_otdel_name']=$this->tree[$arr_orgs[2]]->name  ; }
        else if (_sizeof($arr_orgs)>1)
          {   $arr_ordel_names=array() ;
              foreach($arr_orgs as $otdel_id) $arr_ordel_names[]=$this->tree[$otdel_id]->name  ;
              $rec['_otdel_name']=implode('<br>',$arr_ordel_names) ;
              $rec['_otdel_id']=$otdel_id ;
          }
      } */

      //ob_start() ;
      //if (!$options['no_group'])
      {   $rec['_groups']=array() ; $rec['_groups_names']=array() ;

      // определяем группы персонала, в которые входит сотрудник, через вьювер
      //$sql=array() ;
      //if (_sizeof(_IL('IL_groups')->recs)) foreach(_IL('IL_groups')->recs as $rec_group) $sql[]='select '.$rec_group['id'].' as personal_group_id,"'.$rec_group['obj_name'].'" as personal_group_name from view_personals_group_'.$rec_group['id'].' where pkey='.$rec['pkey'] ;
      //if (_sizeof($sql)) $rec['_groups_personal']=execSQL_row(implode(' UNION ',$sql),0,1) ;
      if (!_sizeof($rec['_so'])) $this->full_personal_SO_info($rec) ;


      // get_groups_to_personal теперь работает без запросов к базе, можно не использовать предзаполнение
      if (!isset($rec['_groups_personal'])) $this->get_groups_to_personal($rec,['debug'=>0]) ;

      // определяем мед.группы, в которые входит сотрудник, через вьювер, если ранее они не были заполнены через функцию PERSONAL()->full_personals_medic_groups($list_rec) ;
      if (!isset($rec['_groups_medic']))
      {   $rec['_groups_medic']=array() ;
      $sql=array() ;
      if (_sizeof(_IL('IL_group_medic')->recs)) foreach(_IL('IL_group_medic')->recs as $rec_group) $sql[]='select '.$rec_group['id'].' as personal_group_id,"'.$rec_group['obj_name'].'" as personal_group_name from view_personals_medic_group_'.$rec_group['id'].' where pkey='.$rec['pkey']."\n" ;
      if (_sizeof($sql)) $rec['_groups_medic']=execSQL_row(implode(' UNION ',$sql),0,1) ;
      }

      $rec['_groups']=array_merge($rec['_groups_personal'],$rec['_groups_medic']) ;
      $rec['_groups_names']=(_sizeof($rec['_groups']))? implode(', ',$rec['_groups']):'';
      }
      //damp_array($rec['_groups']) ;

      //if ($options['set_rules'] and function_exists('ESMO_RULES')) ESMO_RULES()->get_mo_rules_to_personal($rec,$options) ; // вписываем в запись критерии медосмотра, соотвествующие текущему сотруднику
      // убрать отсюда,  get_mo_rules_to_personal вызывается только непосредственно при проведении МО
      //if (function_exists('ESMO_RULES')) ESMO_RULES()->get_mo_rules_to_personal($rec,$options) ; // вписываем в запись критерии медосмотра, соотвествующие текущему сотруднику
      //echo 'PERSONAL_GROUP<br>' ;
      //damp_array($rec['_groups'],1,-1) ;
      //$text=ob_get_clean() ;
      //LOGS()->reg_log('check_group_rules',$text,array('personal_id'=>$rec['pkey'],'terminal_id'=>$options['terminal_id'],'reffers'=>array($rec['_reffer']))) ;

      $rec['_dopusk_time_H']=$GLOBALS['LS_setting_auto_mo_allow_interval'] ; // срок действия меддопуска в часах
      $rec['_dopusk_time_S']=(float)$GLOBALS['LS_setting_auto_mo_allow_interval']*60*60 ; // срок действия меддопуска в секундах
      //$rec['_nedopusk_time_H']=$GLOBALS['LS_setting_auto_mo_denited_interval'] ; // срок действия меддопуска в часах
      $rec['_nedopusk_time_S']=(float)$GLOBALS['LS_setting_auto_mo_denited_interval']*60*60 ; // срок действия меддопуска в секундах
      $rec['_nedopusk_time_S_alco']=(float)$GLOBALS['LS_setting_auto_mo_denited_alco_interval']*60*60 ; // срок действия меддопуска по алкоголю в секундах


      if ($options['set_QR_code'] and 0)
      {
          //$rec['_rec_car']=$rec_rec ;
          $value=(isset($rec[$options['set_QR_code']]))? $rec[$options['set_QR_code']]:$options['set_QR_code'] ;
          if ($value)
          {   $rec['_qrcode_src']=_MAIN_PROTOCOL._MAIN_DOMAIN.'/services/qrcode/'.urlencode($value).'/?dest=terminal' ;
          $source_qrcode=imagecreatefrompng($rec['_qrcode_src']) ;
          //var_dump($source_qrcode) ;
          $im_convas  = imagecreatetruecolor(300,400);
          imagefill($im_convas,0,0,hexdec('FFFFFF'));
          //if (!imagecopymerge($im_convas,$source,2,2,0,0,$w1,$h1,100)) echo 'Не удалось наложить картинку<br>';
          //ImageDestroy($source);
          //$options['angle']=0 ;

            if (_sizeof($source_qrcode))
             { $w_l=imagesx($source_qrcode)  ; $h_l=imagesy($source_qrcode) ;
               if (!imagecopymerge($im_convas,$source_qrcode,0,0, 0, 0,$w_l,$h_l,100))  echo 'Не удалось наложить лого<br>';
               ImageDestroy($source_qrcode);
             }

          //imagefttext($im_convas,12,0,30,320,hexdec('000000'),_DIR_TO_ROOT.'/images/PT-Sans/PTC55F-webfont.ttf','Номер авто: '.$car_number) ;
          if ($options['set_QR_code_text'])
          {
              imagefttext($im_convas,12,0,30,330,hexdec('000000'),_DIR_TO_ROOT.'/images/PT-Sans/PTC55F-webfont.ttf','Номер ВУ: '.$rec['driving']) ;
              imagefttext($im_convas,12,0,30,360,hexdec('000000'),_DIR_TO_ROOT.'/images/PT-Sans/PTC55F-webfont.ttf',$options['set_QR_code_text']) ;

          }
          else
          {
              imagefttext($im_convas,12,0,30,330,hexdec('000000'),_DIR_TO_ROOT.'/images/PT-Sans/PTC55F-webfont.ttf',$rec['_org_name']) ;
          imagefttext($im_convas,12,0,30,360,hexdec('000000'),_DIR_TO_ROOT.'/images/PT-Sans/PTC55F-webfont.ttf','Пропуск: '.$value) ;

          }
          ob_start() ;
          imagepng($im_convas);
          //imagejpeg($source_qrcode);
          $res=ob_get_clean()  ;
          //$rec['_qrcode_source']=base64_encode(file_get_contents($rec['_qrcode_src'])) ;
          $rec['_qrcode_source']=base64_encode($res) ;
      }
      }

      //damp_array($rec,1,-1) ;
    }

    // новая функция отличсется от старой тем, что в $options необходимо точно указывать какой информацией надо дополнить запись по сотруднику
    // get_member_photo_from_mo - при отсутствии фото у сотрудника получать его фото из последнего МО
    // get_ext_info - получить информацию по числу проверок на ПП и числу МО
    // get_groups_info - получить информацию по группам сотрудника
    // get_mo_rules_info - получить информацию по критериям проведения МО
    // get_QR_code - получить QR код


    function prepare_public_info_to_personal_v2(&$rec,$options=array())
    { // если задан внешний обработчик
      if (isset($this->ext_public_system) and is_object($_SESSION['ext_public_system']) and method_exists($_SESSION['ext_public_system'],'prepare_public_info_to_personal'))
      { $_SESSION['ext_public_system']->prepare_public_info_to_personal($rec) ;
        return ;
      }

      // полный путь к фото
      $rec['_image_dir']=_DOT($this->table_personal.'_image')->dir_to_file.'source/'.$rec['_image_name'] ;
      if ($options['get_member_photo_from_mo'] and (!$rec['_image_name'] or !file_exists($rec['_image_dir'])))
      { // получаеи ID последнего МО и используем его фото
        //$last_mo_id=execSQL_value('select max(pkey) from obj_site_mo_session where member_id='.$rec['pkey'].' and status in (2,3)') ;
        //if ($last_mo_id)  $rec['_image_dir']=_DIR_TO_ROOT.'/public/mo_photo/'.$last_mo_id.'_auth.jpg'  ;
        //if ($last_mo_id)  $rec['_image_dir']=ESMO()->get_mo_img_dir_by_id($last_mo_id,'dir','auth.jpg') ;
        //else              $rec['_image_dir']='' ;
      }

      $rec['_work_name']=_IL('IL_works')->recs[$rec['working']]['obj_name'] ;
      $rec['__href']=$this->root_dir.$this->person_dir_name.'/'.$rec['pkey'].'/' ;
      $rec['__href_window']='/window/personal/'.$this->person_dir_name.'/'.$rec['pkey'].'/' ;
      if ($options['get_ext_info'])
      { if (function_exists('PP')) $rec['_pupilomeria_cnt']=execSQL_value('select count(pkey) from obj_site_narko_data where personal_id='.$rec['pkey']) ;
        $rec['_mo_cnt']=execSQL_value('select count(pkey) from obj_site_mo_session where member_id='.$rec['pkey']) ;

      }
      if ($rec['ext_info']) { $rec['_ext_info']=unserialize($rec['ext_info']) ; unset($rec['ext_info']) ; }
      $rec['_pol']=($rec['pol'])? 'Жен.':'Муж.' ;
      // вписываем данные по компании и отделу

      // все организации будут на втором уровне, все подразделения - третьем
      //damp_array($rec) ;
      // вариант для использования дерева каталога в personal_system
      // в противном случае поля _org_id,_org_name,_otdel_name,_otdel_id будут заполнены из вьювера
      //$rec['_org_id']=$rec['parent2'] ;
      //$rec['_org_name']=_IL('ARR_deps')->recs_names[$rec['parent2']] ;
      //$rec['_otdel_id']=$rec['parent'] ;
      //$rec['_otdel_name']=$this->get_full_dep_name_by_dep_levels($rec,'','<br>') ;

      /*
      if (0 and isset($this->tree) and isset($this->tree[$rec['parent']]))
      { $arr_orgs=$this->tree[$rec['parent']]->get_arr_parent() ; // damp_array($arr_orgs) ;
        unset($arr_orgs[0]) ;
        $rec['_org_id']=$this->tree[$arr_orgs[1]]->pkey  ;
        $rec['_org_name']=$this->tree[$arr_orgs[1]]->name  ;
        unset($arr_orgs[1]) ;
        if (_sizeof($arr_orgs)==1)  { $rec['_otdel_id']=$arr_orgs[2]  ; $rec['_otdel_name']=$this->tree[$arr_orgs[2]]->name  ; }
        else if (_sizeof($arr_orgs)>1)
          {   $arr_ordel_names=array() ;
              foreach($arr_orgs as $otdel_id) $arr_ordel_names[]=$this->tree[$otdel_id]->name  ;
              $rec['_otdel_name']=implode('<br>',$arr_ordel_names) ;
              $rec['_otdel_id']=$otdel_id ;
          }
      } */

      //ob_start() ;
      if ($options['get_groups_info'])
      {   $rec['_groups']=array() ; $rec['_groups_personal']=array() ; $rec['_groups_medic']=array() ;

          if (!_sizeof($rec['_so'])) $this->full_personal_SO_info($rec) ;


          $this->get_groups_to_personal($rec) ;

          // определяем мед.группы, в которые входит сотрудник, через вьювер, если ранее они не были заполнены через функцию PERSONAL()->full_personals_medic_groups($list_rec) ;
          if (!isset($rec['_groups_medic']))
          {   $rec['_groups_medic']=array() ;
          $sql=array() ;
          if (_sizeof(_IL('IL_group_medic')->recs)) foreach(_IL('IL_group_medic')->recs as $rec_group) $sql[]='select '.$rec_group['id'].' as personal_group_id,"'.$rec_group['obj_name'].'" as personal_group_name from view_personals_medic_group_'.$rec_group['id'].' where pkey='.$rec['pkey'] ;
          if (_sizeof($sql)) $rec['_groups_medic']=execSQL_row(implode(' UNION ',$sql),0,1) ;
          }

          $rec['_groups']=array_merge($rec['_groups_personal'],$rec['_groups_medic']) ;
          $rec['_groups_names']=(_sizeof($rec['_groups']))? implode(', ',$rec['_groups']):'';
          }
          //damp_array($rec['_groups']) ;

      //if ($options['set_rules'] and function_exists('ESMO_RULES')) ESMO_RULES()->get_mo_rules_to_personal($rec,$options) ; // вписываем в запись критерии медосмотра, соотвествующие текущему сотруднику
      //if ($options['get_mo_rules_info'] and function_exists('ESMO_RULES')) ESMO_RULES()->get_mo_rules_to_personal($rec,$options) ; // вписываем в запись критерии медосмотра, соотвествующие текущему сотруднику
      //echo 'PERSONAL_GROUP<br>' ;
      //damp_array($rec['_groups'],1,-1) ;
      //$text=ob_get_clean() ;
      //LOGS()->reg_log('check_group_rules',$text,array('personal_id'=>$rec['pkey'],'terminal_id'=>$options['terminal_id'],'reffers'=>array($rec['_reffer']))) ;

      $rec['_dopusk_time_H']=$GLOBALS['LS_setting_auto_mo_allow_interval'] ; // срок действия меддопуска в часах
      $rec['_dopusk_time_S']=(float)$GLOBALS['LS_setting_auto_mo_allow_interval']*60*60 ; // срок действия меддопуска в секундах
      //$rec['_nedopusk_time_H']=$GLOBALS['LS_setting_auto_mo_denited_interval'] ; // срок действия меддопуска в часах
      $rec['_nedopusk_time_S']=(float)$GLOBALS['LS_setting_auto_mo_denited_interval']*60*60 ; // срок действия меддопуска в секундах
      $rec['_nedopusk_time_S_alco']=(float)$GLOBALS['LS_setting_auto_mo_denited_alco_interval']*60*60 ; // срок действия меддопуска по алкоголю в секундах


      if ($options['get_QR_code'])
      {
          //$rec['_rec_car']=$rec_rec ;
          $value=(isset($rec[$options['set_QR_code']]))? $rec[$options['set_QR_code']]:$options['set_QR_code'] ;
          if ($value)
          {   $rec['_qrcode_src']=_MAIN_PROTOCOL._MAIN_DOMAIN.'/services/qrcode/'.urlencode($value).'/?dest=terminal' ;
          $source_qrcode=imagecreatefrompng($rec['_qrcode_src']) ;
          //var_dump($source_qrcode) ;
          $im_convas  = imagecreatetruecolor(300,400);
          imagefill($im_convas,0,0,hexdec('FFFFFF'));
          //if (!imagecopymerge($im_convas,$source,2,2,0,0,$w1,$h1,100)) echo 'Не удалось наложить картинку<br>';
          //ImageDestroy($source);
          //$options['angle']=0 ;

            if (_sizeof($source_qrcode))
             { $w_l=imagesx($source_qrcode)  ; $h_l=imagesy($source_qrcode) ;
               if (!imagecopymerge($im_convas,$source_qrcode,0,0, 0, 0,$w_l,$h_l,100))  echo 'Не удалось наложить лого<br>';
               ImageDestroy($source_qrcode);
             }

          //imagefttext($im_convas,12,0,30,320,hexdec('000000'),_DIR_TO_ROOT.'/images/PT-Sans/PTC55F-webfont.ttf','Номер авто: '.$car_number) ;
          if ($options['set_QR_code_text'])
          {
              imagefttext($im_convas,12,0,30,330,hexdec('000000'),_DIR_TO_ROOT.'/images/PT-Sans/PTC55F-webfont.ttf','Номер ВУ: '.$rec['driving']) ;
              imagefttext($im_convas,12,0,30,360,hexdec('000000'),_DIR_TO_ROOT.'/images/PT-Sans/PTC55F-webfont.ttf',$options['set_QR_code_text']) ;

          }
          else
          {
              imagefttext($im_convas,12,0,30,330,hexdec('000000'),_DIR_TO_ROOT.'/images/PT-Sans/PTC55F-webfont.ttf',$rec['_org_name']) ;
          imagefttext($im_convas,12,0,30,360,hexdec('000000'),_DIR_TO_ROOT.'/images/PT-Sans/PTC55F-webfont.ttf','Пропуск: '.$value) ;

          }
          ob_start() ;
          imagepng($im_convas);
          //imagejpeg($source_qrcode);
          $res=ob_get_clean()  ;
          //$rec['_qrcode_source']=base64_encode(file_get_contents($rec['_qrcode_src'])) ;
          $rec['_qrcode_source']=base64_encode($res) ;
      }
  }

      //damp_array($rec,1,-1) ;
    }

    function get_groups_to_personal(&$rec_personal,$options=array())
    {
        ob_start() ;
        $rec_personal['_groups_personal']=[] ;
        if (_sizeof(_IL('IL_groups')->recs)) foreach(_IL('IL_groups')->recs as $rec_group) //if ($rec_group['id']==4)
        {  $f=0 ;
           if (_sizeof($rec_group['_ext_info']['personals'])) foreach($rec_group['_ext_info']['personals'] as $arr_select)
           {   echo 'Проверяем группу '.$rec_group['obj_name'].' ['.$rec_group['id'].']<br>' ;
               $res=$this->check_select_filter_to_personal($arr_select['filter'],$rec_personal,$options) ;
               if ($res['ball']>0) $f=1 ;
               echo 'ball='.$res['ball'].'<br>' ;
           }
           if ($f) $rec_personal['_groups_personal'][$rec_group['id']]=$rec_group['obj_name'] ;
        }
        $text=ob_get_clean() ;
        if ($options['debug'] ) echo $text ;
    }

    // возвращает список всех элементов, которые по условиям отбора подходят для переданного сотрудника
   function get_filter_item_ids_ball_to_personal_rec($rec_personal,$usl_select_item='')
   {
      $recs_filters=PERSONALS_FILTER()->get_personals_filter_all('reffer like "%.516"') ;

      $arr_allow_themes_ids=[] ; // массив всех тем, которые по условиям отбора подходят для данного сотрудника

      if (_sizeof($recs_filters)) foreach($recs_filters as $reffer=>$filter_sets)
      {   list($theme_id,$theme_tkey)=explode('.',$reffer) ;
          $ball_max=0 ;
          if (_sizeof($filter_sets)) foreach($filter_sets as $indx=>$filter_set)
          { $ball_info=$this->check_select_filter_to_personal($filter_set,$rec_personal,['debug'=>0]) ;
            // надо получить максимальный бал
            if ($ball_info['ball']>$ball_max) $ball_max=$ball_info['ball'] ;
          }
          if ($ball_max)
          {
              $arr_allow_themes_ids[$theme_id]=$ball_max ;
              echo '<div class="green">Тема ID <strong>'.$theme_id.'</strong> одобрена, балл '.$ball_max.'</div>' ;
          }
          else echo '<div class="red">Тема ID <strong>'.$theme_id.'</strong> отклонена, балл '.$ball_max.'</div>' ;

      }
      return($arr_allow_themes_ids) ;
    }

   // проверяем соответствие сотрудника в $rec_personal, фильтру
   // соответствия нет - ball =0
   // чем выше степерь соответствия, тем выше балл
    function check_select_filter_to_personal($arr_filter,$rec_personal,$options=array())
    {   ob_start() ;
        $ball=0 ; $balls_info=array() ;
        damp_array($arr_filter,1,-1);
        unset($arr_filter['section_id']) ;
        // проверяем число совпадений сотрудкника с заданными фильтрами, как только сотрудник не попадает в фильтр, баллы должны обнуляться
        if (_sizeof($arr_filter)) foreach($arr_filter as $key=>$values)
        {   $block=1 ;
            echo 'Провереяем поле фильтра '.$key.':<br>' ;
            //echo '$key='.$key.'<br>' ; echo '$values='.print_r($values,true).'<br>' ;
            if (!_sizeof($rec_personal['_so']))
            {  echo 'Провереяем запись ФЛ:<br>' ;
               switch($key)
                { // проверяем организацию сотрудника. по умолчания ставим block=1, если будет найдено хотябы одно соответствие block=0
                  // но если после проверки одного из фильтров  $block останется равным 1 - значит по этому параметру совпедаения не было и ball=0
                  case 'org_ids':     if (_sizeof($values)) foreach($values as $org_id=>$temp)      if ($rec_personal['parent2']==$org_id) { $block=0;  $ball=$ball+2 ;$balls_info[]='Организация'  ;}break ;
                  case 'otdel_ids':   if (_sizeof($values)) foreach($values as $otdel_id=>$temp)    if ($rec_personal['parent3']==$otdel_id or $rec_personal['parent4']==$otdel_id or $rec_personal['parent5']==$otdel_id or $rec_personal['parent6']==$otdel_id) {$block=0;  $ball=$ball+3 ;$balls_info[]='Подразделение'  ;}break ;
                  case 'working_ids': if (_sizeof($values)) foreach($values as $workings_id=>$temp) if ($rec_personal['working']==$workings_id) { $block=0; $ball=$ball+4 ; $balls_info[]='Должность'  ; } break ;
                   default: $block=0;
                }
            }
            else
            { // проверяем все рабочие места сотрудника на предмет совпадения с фильтвом
              echo 'Провереяем записи СО:<br>' ;
              foreach($rec_personal['_so'] as $rec_so)
              { echo 'Записи СО:<br>' ;
                 switch($key)
                  {   case 'org_ids':     if (_sizeof($values)) foreach($values as $org_id=>$temp)      if ($rec_so['parent2']==$org_id) { $block=0;  $ball=$ball+2 ;$balls_info[]='Организация'  ;}break ;
                      case 'otdel_ids':   if (_sizeof($values)) foreach($values as $otdel_id=>$temp)    if ($rec_so['parent3']==$otdel_id or $rec_so['parent4']==$otdel_id or $rec_so['parent5']==$otdel_id or $rec_so['parent6']==$otdel_id) {$block=0;  $ball=$ball+3 ;$balls_info[]='Подразделение'  ;}break ;
                      case 'working_ids': if (_sizeof($values)) foreach($values as $workings_id=>$temp) if ($rec_so['work_id']==$workings_id) { $block=0; $ball=$ball+4 ; $balls_info[]='Должность'  ; } break ;
                      default: $block=0;
                  }
                echo 'block='.$block.'<br>' ;
              }

            }
            // если сотрудник или одна из его должностей не прошел хотябы по одному из параметров фильтра - убираем баллы и далее не проверяем
            //echo 'block='.$block.'<br>' ;
            if ($block) {$ball=0; break ;}
        }
        $text=ob_get_clean() ;
        if ($options['debug']) echo $text ;
        return(['ball'=>$ball,'info'=>$balls_info]) ;
     }

    function full_personals_medic_groups(&$recs_personals)
    {   if (!_sizeof($recs_personals)) return ;
        $arr_ids=array() ;
        foreach($recs_personals as $rec) $arr_ids[]=$rec['pkey'] ;
        $str_ids=implode(',',$arr_ids) ;

        $rec['_groups_medic']=array() ;
        $groups_medic2=[] ; $groups_medic=[] ;

             // определяем мед.группы, в которые входит сотрудник, через вьювер
             $sql=array() ;
             if (_sizeof(_IL('IL_group_medic')->recs)) foreach(_IL('IL_group_medic')->recs as $rec_group) $sql[]='select pkey,'.$rec_group['id'].' as personal_group_id,"'.$rec_group['obj_name'].'" as personal_group_name from view_personals_medic_group_'.$rec_group['id'].' where pkey in ('.$str_ids.')' ;
             if (_sizeof($sql)) $groups_medic=execSQL(implode("\nUNION\n",$sql),0,1) ;
             if (_sizeof($groups_medic)) foreach($groups_medic as $rec) $groups_medic2[$rec['pkey']][$rec['personal_group_id']]=$rec['personal_group_name'] ;
             //damp_array($groups_medic2,1,-1) ;

        foreach($recs_personals as $i=>&$rec)
            { $rec['_groups_medic']=(_sizeof($groups_medic2[$rec['pkey']]))? $groups_medic2[$rec['pkey']]:[] ;
              //$rec['_groups_personal']=[] ;
              $this->get_groups_to_personal($rec,['debug'=>0]) ; // будет заполнено поле _groups_personal
              $rec['_groups']=array_merge($rec['_groups_personal'],$rec['_groups_medic']) ;
              $rec['_groups_names']=(_sizeof($rec['_groups']))? implode(', ',$rec['_groups']):'';
            }
    }

    function full_personals_SO_info(&$recs_personals)
    {   if (!_sizeof($recs_personals)) return ;
        $arr_ids=array() ;
        foreach($recs_personals as $rec) $arr_ids[]=$rec['pkey'] ;
        $str_ids=implode(',',$arr_ids) ;

        $recs_so=execSQL('select * from obj_site_workers where personal_id in ('.$str_ids.') and enabled=1') ;
        $recs_so_out=[] ;
        if (_sizeof($recs_so)) foreach($recs_so as $rec_so)
        {
            $data=['pkey'=>$rec_so['pkey'],
                    'uid'=>$rec_so['uid'],
                    'is_main'=>$rec_so['is_main'],
                    'is_second'=>$rec_so['is_second'],
                    'work_id'=>$rec_so['work_id'],
                    'parent'=>$rec_so['parent'],
                    'parent1'=>$rec_so['parent1'],
                    'parent2'=>$rec_so['parent2'],
                   ];
            if ($rec_so['parent3']) $data['parent3']=$rec_so['parent3'] ;
            if ($rec_so['parent4']) $data['parent4']=$rec_so['parent4'] ;
            if ($rec_so['parent5']) $data['parent5']=$rec_so['parent5'] ;
            if ($rec_so['parent6']) $data['parent6']=$rec_so['parent6'] ;
            if ($rec_so['parent7']) $data['parent7']=$rec_so['parent7'] ;
            if ($rec_so['parent8']) $data['parent8']=$rec_so['parent8'] ;
            if ($rec_so['parent9']) $data['parent9']=$rec_so['parent9'] ;
            if ($rec_so['inrm']) $data['inrm']=$rec_so['inrm'] ;
            if ($rec_so['job_data']) $data['job_data']=$rec_so['job_data'] ;
            if ($rec_so['fired_data']) $data['fired_data']=$rec_so['fired_data'] ;
            if ($rec_so['fired_data_pause']) $data['fired_data_pause']=$rec_so['fired_data_pause'] ;

            $recs_so_out[$rec_so['personal_id']][]=$data ;
        }
        //damp_array($recs_so_out);
        foreach($recs_personals as $i=>$rec) $recs_personals[$i]['_so']=$recs_so_out[$rec['pkey']] ;

    }

    function full_personal_SO_info(&$rec_personal)
    {   $recs_so=execSQL('select * from obj_site_workers where personal_id in ('.$rec_personal['pkey'].') and enabled=1') ;
        if (_sizeof($recs_so)) foreach($recs_so as $rec_so)
        {    $data=['pkey'=>$rec_so['pkey'],
                    'uid'=>$rec_so['uid'],
                    'is_main'=>$rec_so['is_main'],
                    'is_second'=>$rec_so['is_second'],
                    'work_id'=>$rec_so['work_id'],
                    'parent'=>$rec_so['parent'],
                    'parent1'=>$rec_so['parent1'],
                    'parent2'=>$rec_so['parent2'],
                   ];
            if ($rec_so['parent3']) $data['parent3']=$rec_so['parent3'] ;
            if ($rec_so['parent4']) $data['parent4']=$rec_so['parent4'] ;
            if ($rec_so['parent5']) $data['parent5']=$rec_so['parent5'] ;
            if ($rec_so['parent6']) $data['parent6']=$rec_so['parent6'] ;
            if ($rec_so['parent7']) $data['parent7']=$rec_so['parent7'] ;
            if ($rec_so['parent8']) $data['parent8']=$rec_so['parent8'] ;
            if ($rec_so['parent9']) $data['parent9']=$rec_so['parent9'] ;
            if ($rec_so['inrm']) $data['inrm']=$rec_so['inrm'] ;
            if ($rec_so['job_data']) $data['job_data']=$rec_so['job_data'] ;
            if ($rec_so['fired_data']) $data['fired_data']=$rec_so['fired_data'] ;
            if ($rec_so['fired_data_pause']) $data['fired_data_pause']=$rec_so['fired_data_pause'] ;

            $rec_personal['_so'][]=$data ;
        }

    }

    function search_cars($text)
    { $res=execSQL_line('select pkey from obj_site_personals_cars where (obj_name like "%'.$text.'%" or model like "%'.$text.'%") and enabled=1') ;
      return($res) ;
    }

    //==========================================================================================================================================================================
     // РАБОТА СО СТРУКТУРОЙ ОРГАНИЗАЦИЯ - ОТДЕЛ
     //==========================================================================================================================================================================

      function get_list_personal_section($parent=1,$clss='',$usl_select='')
      { if (!$clss) $clss='1,207,208' ;
        $sql='select * from '.$this->table_personal.' where parent in('.$parent.') and clss in ('.$clss.')' ;
        if ($usl_select) $sql.=' and '.$usl_select ;
        $sql.=' order by indx' ;
        $res=execSQL($sql) ;
        return($res) ;
      }

      function get_org_otdel_ids($org_id)
      {
         $res=execSQL_line('select pkey from '.$this->table_personal.' where parent='.$org_id.' and clss=208 and enabled=1') ;
         return($res) ;
      }

     function get_personal_section_by_id($id)
     {   list($pkey,$tkey)=explode('.',$id) ;
         $rec=array() ;
         if ($pkey) $rec=select_db_recs($this->table_personal,'pkey="'.$pkey.'" and clss=1',array('no_arr'=>1)) ;
         return($rec) ;
     }

     function get_org_by_id($id,$options=array())
     {   list($pkey,$tkey)=explode('.',$id) ;
          $rec=array() ;
          if ($pkey)
          { $rec=execSQL_van('select * from obj_site_personals where pkey='.$pkey,array('debug'=>0)) ;
            if ($rec['pkey']) $this->prepare_public_info_to_org($rec,$options) ;
          }
          //damp_array($rec) ;
          return($rec) ;
      }

     function get_name_by_id($id,$options=array())
     {   $name=execSQL_value('select obj_name from '.$this->table_personal.' where pkey='.$id) ;
         return($name) ;
     }

     function get_org_names_by_ids($ids,$options=array())
     {   $str_ids=(is_array($ids))? implode(',',$ids):$ids ;
         $arr_ids=explode(',',$str_ids) ;
         $arr=[];
         if (!_sizeof($GLOBALS['orgs_names'])) $GLOBALS['orgs_names']=execSQL_row('select pkey,obj_name from '.$this->table_personal.' where clss in (207,208)');
         if (_sizeof($arr_ids)) foreach($arr_ids as $id) $arr[]=$GLOBALS['orgs_names'][$id] ;
     	 //$arr=execSQL_line('select obj_name from '.$this->table_personal.' where pkey in ('.$str_ids.')') ;
         if (_sizeof($arr)) $res=implode(', ',$arr) ;
         return($res) ;
     }



      function prepare_public_info_to_org(&$rec)
      { $rec['__href']='/cab/personal/org/'.$rec['pkey'].'/' ;
        $rec['__href_window']='/window/personal/org/'.$rec['pkey'].'/' ;
        //$stamp_rec=execSQL_van('select pkey,tkey,file_name from obj_site_personals_image where parent='.$rec['pkey'].' and alt="stamp"',0) ;
        //if ($rec['pkey']) $rec['stamp']=$stamp_rec ;
        if ($rec['ext_info'])  $rec['_ext_info']=unserialize($rec['ext_info']) ;
        //damp_array($stamp_rec) ;
        //damp_array($rec) ;


      }

      function prepare_public_info_to_otdel(&$rec)
      { $rec['__href']='/cab/personal/otdel/'.$rec['pkey'].'/' ;
        $rec['__href_window']='/window/personal/otdel/'.$rec['pkey'].'/' ;
        //$stamp_rec=execSQL_van('select pkey,tkey,file_name from obj_site_personals_image where parent='.$rec['pkey'].' and alt="stamp"',0) ;
        //if ($rec['pkey']) $rec['stamp']=$stamp_rec ;
        if ($rec['ext_info'])  $rec['_ext_info']=unserialize($rec['ext_info']) ;
        //damp_array($stamp_rec) ;
        //damp_array($rec) ;


      }


      function get_car_by_id($id,$options=array())
     {   list($pkey,$tkey)=explode('.',$id) ;
          $rec=array() ;
          if ($pkey)
          { $rec=execSQL_van('select t1.*,t2.obj_name as _org_name from obj_site_personals_cars t1 left join obj_site_personals t2 on t2.obj_name=t1.parent where t1.pkey="'.$pkey.'" and t1.enabled=1') ;
            if ($rec['pkey']) $this->prepare_public_info_to_car($rec,$options) ;
          }
          return($rec) ;
      }

    function get_car_by_number($number,$options=array())
    {
        $rec=array() ;
        if ($number)
        { $rec=execSQL_van('select t1.*,t2.obj_name as _org_name from obj_site_personals_cars t1 left join obj_site_personals t2 on t2.obj_name=t1.parent where t1.obj_name like "'.$number.'" and t1.enabled=1') ;
            if ($rec['pkey']) $this->prepare_public_info_to_car($rec,$options) ;
        }
        return($rec) ;
    }


      function prepare_public_info_to_car(&$rec)
      { $rec['__href']='/cab/personal/cars/'.$rec['pkey'].'/' ;
        //$rec['']='/cab/personal/cars/'.$rec['pkey'].'/' ;
        //$stamp_rec=execSQL_van('select pkey,tkey,file_name from obj_site_personals_image where parent='.$rec['pkey'].' and alt="stamp"') ;
        //if ($stamp_rec['pkey']) $rec['stamp']=$stamp_rec ;


      }



     function get_personal_section_by_URL($URL)
     {  $arr=explode('.',$URL) ;
        $rec=$this->get_personal_section_by_id($arr[0])  ;
        return($rec) ;
     }

     function update_personal_section_name($reffer,$new_name)
     {  $res=array() ;
        $rec=$this->get_personal_section_by_id($reffer) ;
        if ($rec['pkey'] and $new_name!=$rec['obj_name']) $res=update_rec_in_table($rec['tkey'],array('obj_name'=>$new_name),'pkey='.$rec['pkey']) ;
        return($res) ;
     }

     function update_otdel_name($reffer,$new_name)
     {  $res=array() ;
        $rec_org=$this->get_personal_section_by_id($reffer) ;
        if ($rec_org['pkey']) $res=update_rec_in_table($rec_org['tkey'],array('obj_name'=>$new_name),'pkey='.$rec_org['pkey']) ;
        return($res) ;
     }

     function add_personal_section($reffer,$new_name)
     {  $res=array() ;
        $rec_org=$this->get_personal_section_by_id($reffer) ;
        if ($rec_org['pkey']) $res=adding_rec_to_table($rec_org['tkey'],array('clss'=>1,'parent'=>$rec_org['pkey'],'obj_name'=>$new_name)) ;
        return($res) ;

     }

     function create_org($data)
     {  $data['clss']=207 ;
        $data['parent']=1 ;
        $data['parent1']=1 ;
        $data['level']=2 ;
        if (_sizeof($data)) foreach($data as $indx=>$value) if (!$value) unset($data[$indx]) ;
        $id=adding_rec_to_table('obj_site_personals',$data,array('return_id'=>1)) ;
        $org_reffer=$id.'.'._DOT('obj_site_personals')->pkey ;
        LOGS()->reg_log('Добавление организации','',array('data'=>$data,'reffers'=>array($org_reffer))) ;
        return($id) ;
     }

     function create_otdel($org_id,$data)
     {  if (!$org_id) return(0) ;
         $data['clss']=208 ;
        $data['parent']=$org_id ;
	    $data['level']=3 ;
        $rec_parent_section=execSQL_van('select * from obj_site_personals where pkey='.$data['parent']) ;
        for ($i=1;$i<$rec_parent_section['level'];$i++)  $data['parent'.$i]=$rec_parent_section['parent'.$i] ;
        $data['parent'.$rec_parent_section['level']]=$data['parent'] ;
        $data['level']=$rec_parent_section['level']+1 ;
	    $reffer=adding_rec_to_table('obj_site_personals',$data,array('return_reffer'=>1)) ;
	    list($id,$tkey)=explode('.',$reffer) ;
	    LOGS()->reg_log('Добавление подразделения','',array('data'=>$data,'reffers'=>array($reffer))) ;
        return($id) ;
     }

     function delete_otdel_or_org($otdel_id)
     { $rec=$this->get_otdel_by_id($otdel_id) ;
       if (!$rec) $rec=$this->get_org_by_id($otdel_id) ;
       if ($rec['pkey'])
       {   // перемещаем все дочерние объекты родителю
           execSQL_update('update '.$this->table_personal.' set parent='.$rec['parent'].' where parent='.$rec['pkey']) ;
           // удаляем раздел
           execSQL_update('delete from  '.$this->table_personal.' where pkey='.$rec['pkey']) ;
           return(1) ;
       }
       return(0) ;
     }

     function save_org($id,$data)
     {
       $res=update_rec_in_table('obj_site_personals',$data,'pkey='.$id,array('debug'=>0)) ;
       return($res) ;
     }

     function save_otdel($id,$data)
     {
       $res=update_rec_in_table('obj_site_personals',$data,'pkey='.$id,array('debug'=>0)) ;
       return($res) ;
     }

     function get_org_otdels($org_id)
     { $res=execSQL('select * from '.$this->table_personal.' where parent='.$org_id.' and clss=208 and enabled=1') ;
       return($res) ;
     }

     function get_otdel_by_id($otdel_id,$options=array())
     { $rec=execSQL_van('select * from '.$this->table_personal.' where pkey='.$otdel_id.' and clss=208 and enabled=1') ;
       if ($rec['pkey']) $this->prepare_public_info_to_org($rec,$options) ;
       return($rec) ;
     }



     function delete_personal_section($reffer)
     {  $rec=$this->get_personal_section_by_id($reffer) ;
        //damp_array($rec) ;
        if ($rec['pkey'])
        {   // перемещаем все дочерние объекты родителю
            execSQL_update('update '.$this->table_personal.' set parent='.$rec['parent'].' where parent='.$rec['pkey']) ;
            // удаляем раздел
            execSQL_update('delete from  '.$this->table_personal.' where pkey='.$rec['pkey']) ;
            return(1) ;
        }
        return(0) ;
     }


    //==========================================================================================================================================================================
     // ЗАГРУЗКА СМЕНЫ ИЗ EXCEL
     //==========================================================================================================================================================================

     function upload_tabel_from_excel($file_name)
     { set_include_path(_DIR_TO_ROOT.'/AddOns/PHPExcel/');
       include_once 'PHPExcel/IOFactory.php';
       $objPHPExcel = PHPExcel_IOFactory::load($file_name);
       $objPHPExcel->setActiveSheetIndex(0);
       $aSheet = $objPHPExcel->getActiveSheet();
       if (is_object($aSheet))
       {   $rowIterator = $objPHPExcel->getActiveSheet()->getRowIterator();

           $line=1 ;
           foreach($rowIterator as $row)
           { $cellIterator = $row->getCellIterator();
             $cellIterator->setIterateOnlyExistingCells(false); // Loop all cells, even if it is not set
             $rec=array() ; $col=1 ;  $arr_dates=array() ;

             foreach ($cellIterator as $cell)
               { $value=$cell->getCalculatedValue();
                 if ($value) switch($cell->getColumn())
                 { case 'A': $rec['propusk'] = (int)$cell->getFormattedValue(); break ;
                   case 'B':  $rec['name'] = $cell->getFormattedValue(); break ;
                   default: if ($line==1)  {  // убираем час из даты, который любит вставлять excel
                                              $data=PHPExcel_Shared_Date::ExcelToPHP($cell->getValue());
                                              $now=getdate($data) ;
                                              $arr_dates[$col]=mktime(0,0,0,$now['mon'],$now['mday'],$now['year']);
                                           }
                            else          if ($cell->getFormattedValue()>0) $rec[$arr_dates[$col]]=$cell->getFormattedValue();
                 }
                 //else if('C' == $cell->getColumn()){$array_data[$rowIndex][$cell->getColumn()] = PHPExcel_Style_NumberFormat::toFormattedString($cell->getCalculatedValue(), 'YYYY-MM-DD');}
                 $col++ ;
               }
             $member_id=execSQL_value('select pkey from '.$this->table_personal.' where propusk="'.$rec['propusk'].'"') ;
             if (!$member_id) $rec['alert']='Сотрудник не внесен в БД, в табель добавлен не будет' ;
             //if ($line==1) damp_array($arr_dates) ;
             if ($line>1 and $rec['propusk']) $tabel[]=$rec ;
             $line++ ;
           }

       }
       return(array($arr_dates,$tabel)) ;
     }

     //==========================================================================================================================================================================
     // ДОБАВЛЕНИЕ ТАБЕЛЯ В БД
     //==========================================================================================================================================================================

     function append_tabel_from_array($recs)
     {  $res=array() ;
        if (_sizeof($recs)) foreach($recs as $rec)
         { // определяем id сотрудника
           $member_id=execSQL_value('select pkey from '.$this->table_personal.' where propusk="'.$rec['propusk'].'"') ;
           if ($member_id)
           { unset($rec['propusk'],$rec['name']) ;
             if (_sizeof($rec)) foreach($rec as $date=>$smena)
             { $tabel_id=execSQL_value('select pkey from '.$this->table_tabel.' where member_id='.$member_id.' and data='.$date) ;
               if ($tabel_id) { update_rec_in_table($this->table_tabel,array('smena'=>$smena,'obj_name'=>date('d.m.Y H:i:s',$date)),'pkey='.$tabel_id) ;  $res['update']++ ; }
               else           { adding_rec_to_table($this->table_tabel,array('parent'=>1,'clss'=>212,'obj_name'=>date('d.m.Y H:i:s',$date),'member_id'=>$member_id,'data'=>$date,'smena'=>$smena)) ; $res['adding']++ ; }
             }
           }
           else $res['not_found']++ ;
         }
        return($res) ;
     }

     function append_tabelHR_from_array($recs)
     {  $res=array() ;
        if (_sizeof($recs)) foreach($recs as $rec)
         { // определяем id сотрудника
           $member_id=execSQL_value('select pkey from '.$this->table_personal.' where person_id="'.$rec['person_id'].'"') ;
           if ($member_id)
           { $rec['parent']=$member_id ;
             $rec['clss']=214 ;
             $tabel_id=execSQL_value('select pkey from '.$this->table_personal.'_tabel_HR where table_id="'.$rec['table_id'].'"') ;
             if ($tabel_id) { update_rec_in_table($this->table_personal.'_tabel_HR',$rec,'pkey='.$tabel_id) ;  $res['tabel_update']++ ; }
             else           { adding_rec_to_table($this->table_personal.'_tabel_HR',$rec) ; $res['tabel_adding']++ ; }

           }
           else $res['not_found_person_id']++ ;
         }
        return($res) ;
     }


     //==========================================================================================================================================================================
     // ДОБАВЛЕНИЕ СОТРУДНИКОВ В БД
     //==========================================================================================================================================================================

     function append_personal_from_array(&$recs,$options=array())
     {  $cnt_update=0 ; $cnt_adding=0 ;
        $client_id=($options['client_id'])? $options['client_id']:0 ;
        $arr_org_names=execSQL_row('select pkey,obj_name from '.$this->table_personal.' where clss=207 and parent=1') ;
        $arr_work_names=execSQL_row('select id,obj_name from obj_site_list where clss=20 and parent='._IL('IL_works')->list_id) ;
        $_arr_otdel_names=execSQL('select pkey,parent,obj_name from '.$this->table_personal.' where clss=208 and parent!=1 and pkey!=1') ;
        $arr_otdel_names=group_by_field('parent',$_arr_otdel_names,'pkey','obj_name') ;
        // определяем условие, по которому будет искаться идентичная запись
        if (!$options['key_fields']) $options['key_fields']='obj_name,dr' ;
        $arr_key_fields=explode(',',$options['key_fields']) ;

        //damp_array($arr_org_names,1,-1) ; damp_array($arr_otdel_names,1,-1) ; damp_array($arr_work_names,1,-1) ;
        if (_sizeof($recs)) foreach($recs as $indx=>$rec)
         { $org_id=0 ; $otdel_id=0 ; $work_id=0 ;  // damp_array($rec) ;
           // проверяем организацию
           if ($rec['_org_name'])
           {   if (_sizeof($arr_org_names) and in_array($rec['_org_name'],$arr_org_names)) $org_id=array_search($rec['_org_name'],$arr_org_names) ;
               else
               { echo 'Добавляем новую организацию - "<strong>'.$rec['_org_name'].'</strong>"<br>' ;
                 $org_id=adding_rec_to_table($this->table_personal,array('clss'=>207,'parent'=>1,'parent1'=>1,'level'=>2,'obj_name'=>$rec['_org_name'],'client_id'=>$client_id)) ;
                 $arr_org_names[$org_id]=$rec['_org_name'] ;
                 LOGS()->reg_log('Изменение структуры каталога сотрудников','Добавление новой организации - "'.$rec['_org_name'].'", id='.$org_id) ;
               }
               unset($rec['_org_name']) ;
           }
           else if ($rec['_org_id']) $org_id=$rec['_org_id'] ;
           //echo '$org_id='.$org_id.'<br>';
           //echo $rec['_otdel_name'] ;
           // проверяем отдел
           if ($rec['_otdel_name'])
           {   if (_sizeof($arr_otdel_names[$org_id]) and in_array($rec['_otdel_name'],$arr_otdel_names[$org_id])) $otdel_id=array_search($rec['_otdel_name'],$arr_otdel_names[$org_id]) ;
               else
                 { echo 'Добавляем новый отдел - "<strong>'.$rec['_otdel_name'].'</strong>"<br>' ;
                   $otdel_id=adding_rec_to_table($this->table_personal,array('clss'=>208,'parent'=>$org_id,'parent1'=>1,'parent2'=>$org_id,'level'=>3,'obj_name'=>$rec['_otdel_name'])) ;
                   $arr_otdel_names[$org_id][$otdel_id]=$rec['_otdel_name'] ;
                   LOGS()->reg_log('Изменение структуры каталога сотрудников','Добавление нового отдела - "'.$rec['_otdel_name'].'", id='.$otdel_id) ;
                 }
               unset($rec['_otdel_name']) ;
           }
           if (_sizeof($rec['_otdels_names']))
           {   $parent_otdel=$org_id ; //damp_array($rec['_otdels_names']) ;
               foreach($rec['_otdels_names'] as $i=>$otdel_name) if ($otdel_name)
               {
                  if (_sizeof($arr_otdel_names[$org_id]) and in_array($otdel_name,$arr_otdel_names[$org_id]))
                  {   $otdel_id=array_search($otdel_name,$arr_otdel_names[$org_id]) ;
                      //echo 'Отдел "<strong>'.$otdel_name.'</strong>" уже добавлен<br>' ;
                  }
                  else
                  { echo 'Добавляем новый отдел - "<strong>'.$otdel_name.'</strong>"<br>' ;
                    $otdel_id=adding_rec_to_table($this->table_personal,array('clss'=>208,'parent'=>$parent_otdel,'parent1'=>1,'parent2'=>$parent_otdel,'level'=>3,'obj_name'=>$otdel_name)) ;
                    $arr_otdel_names[$org_id][$otdel_id]=$otdel_name ;
                    $parent_otdel=$otdel_id ;
                  }
               }
               unset($rec['_otdels_names']) ;
           }

           //echo '$otdel_id='.$otdel_id.'<br>';
           // проверяем должность
           // проверяем организацию
           if (trim($rec['_working_name'])!="") $rec['working']=_IL('IL_works')->get_id_of_value(trim($rec['_working_name']),array('append_value_is_not_found'=>1)) ;

           unset($rec['_working_name'],$rec['_otdels_names'],$rec['_otdel_name'],$rec['_org_name'],$rec['_org_id']) ;


           $_usl=array() ;
           foreach($arr_key_fields as $key) $_usl[]=$key.'="'.$rec[$key].'"' ;
           $res_usl=implode(' and ',$_usl) ;

           $id_exsist=execSQL_value('select pkey from '.$this->table_personal.' where '.$res_usl) ;

           if ($id_exsist) { if ($otdel_id or $org_id)
                             { $rec['parent']=($otdel_id)? $otdel_id:$org_id ; //   print_r($rec) ;
                             $rec['parent1']=1 ;
	                         $rec['parent2']=$org_id ;
                             if ($otdel_id) $rec['parent3']=$otdel_id ;
                             }
                             update_rec_in_table($this->table_personal,$rec,'pkey='.$id_exsist,array('debug'=>0)) ;
                             $cnt_update++ ;
                             $recs[$indx]['id']=$id_exsist ;
                           }
           else if ($rec['uid'])
                           { $rec['clss']=211 ;
                             $rec['parent']=($otdel_id)? $otdel_id:$org_id ;
                             $rec['parent1']=1 ;
	                         $rec['parent2']=$org_id ;
                             if ($otdel_id) $rec['parent3']=$otdel_id ;
                             $recs[$indx]['id']=adding_rec_to_table($this->table_personal,$rec) ;
                             echo 'Добавляем нового сотрудника - "<strong>'.$rec['obj_name'].'</strong>"<br>' ;
                             $cnt_adding++ ;
                           }
           else echo 'Сотрудник "<strong>'.$rec['obj_name'].'</strong> не добавлени - не задан UID<br>"' ;
         }
         //damp_array($arr_org_names,1,-1) ; damp_array($arr_otdel_names,1,-1) ; damp_array($arr_work_names,1,-1) ;

        return(array($cnt_update,$cnt_adding)) ;
     }

    //==========================================================================================================================================================================
    // СООБЩЕНИЯ ДЛЯ СОТРУДНИКОВ
    //==========================================================================================================================================================================

    function get_message_by_id($id,$options=array())
    {
        if (!_sizeof($options['fields'])) $rec=execSQL_van('select * from view_personals_messages where pkey='.$id) ;
        else                             $rec=execSQL_van('select '.$options['fields'].' from obj_site_personal_mess where pkey='.$id) ;
        $this->prepare_public_info_to_mess($rec) ;
        return($rec) ;
    }

    function get_message_by_reffer($reffer)
    {   list($pkey,$tkey)=explode('.',$reffer) ;
        $rec=execSQL_van('select * from view_personals_messages where source_pkey='.$pkey.' and source_tkey='.$tkey) ;
        $this->prepare_public_info_to_mess($rec) ;
        return($rec) ;
    }

    function get_messages_by_reffer($reffer)
    {   list($pkey,$tkey)=explode('.',$reffer) ;
        $recs=execSQL('select * from view_personals_messages where source_pkey='.$pkey.' and source_tkey='.$tkey) ;
        if (_sizeof($recs)) foreach($recs as $id=>$rec) $this->prepare_public_info_to_mess($recs[$id]) ;
        return($recs) ;
    }



    function prepare_public_info_to_mess(&$rec)
    {
      //$rec['__href_window']='/window/personal/message/'.$rec['pkey'].'/' ;  - идет через вьювер
      if ($rec['personal_id']) $rec['_personal_reffer']=$rec['personal_id'].'.'.$this->tkey_personal ;
    }

    // доведение сообщений до сотрудника основа только на их статусе
    // подлежат доведению все сообщения в статусах 1,2,3
    // статусы сообщений обновляются по заданию планировщика
    function get_active_mess_to_personal($personal_id,$options=array())
    {   $_usl=array() ;
        $_usl[]='personal_id='.$personal_id ;
        $_usl[]=($options['view_blocked'])? 'status in (1,2,3)':'status in (1,2)' ;
        $_usl[]='enabled=1' ;
 //$_usl[]='mess_event_id!=97' ;
        if ($options['usl_select']) $_usl[]=$options['usl_select'] ;
        if ($options['source_pkey']) $_usl[]='source_pkey='.$options['source_pkey'] ;
        if ($options['source_obj']) $_usl[]='source_obj="'.$options['source_obj'].'"' ;
        $usl=implode(' and ',$_usl) ;
        $recs_mess=execSQL('select * from view_personals_messages where '.$usl.' order by pkey') ;
        ENGINE()->on_event_by_pointer('get_active_mess_to_personal',$personal_id,$recs_mess,$options) ;
        return($recs_mess) ;
    }

    // используется только для закрытия сообщений, поэтому вызов обработчика get_active_mess_to_personal можно не делать
    function get_active_mess_ids_to_personal($personal_id,$options=array())
    {   $_usl=array() ;
        $_usl[]='personal_id='.$personal_id ;
 //$_usl[]='mess_event_id!=97' ;
        $arr_status=array(1,2) ;
        if ($options['view_blocked']) $arr_status[]=3 ;
        if ($options['view_unactive']) $arr_status[]=5 ;
        $_usl[]='status in ('.implode(',',$arr_status).')' ;
        $_usl[]='enabled=1' ;
        if ($options['usl_select']) $_usl[]=$options['usl_select'] ;
        if ($options['source_pkey']) $_usl[]='source_pkey='.$options['source_pkey'] ;
        if ($options['source_obj']) $_usl[]='source_obj="'.$options['source_obj'].'"' ;
        $usl=implode(' and ',$_usl) ;
        $recs_mess=execSQL_line('select pkey from obj_site_personal_mess where '.$usl.' order by pkey') ;
        //$recs_mess=execSQL_line('select pkey from view_personal_messages where '.$usl.' order by pkey') ;
        return($recs_mess) ;
    }

    // вызывется из c_server::check_access
    // status=2 - сообщение активно
    // status=3 - идет блокировка
    //  старое поле max_data - использовалось, когда не было поля block_from. Содержало время, после которого должна была наступить блокировка
    // сейчас вместо поля  max_data используется поле  block_from

    function message_personal_set_view($rec_mess,$mesto_name,$options=array())
    {    //$rec_mess=$this->get_message_by_id($mess_id) ;
         if (!$rec_mess['view_cnt']) $rec_mess['view_cnt']=0 ;
         $rec_mess['view_cnt']++ ;
         // поля max_cnt и max_data более не используются
         //if ($rec_mess['max_cnt'] and $rec_mess['view_cnt']>=$rec_mess['max_cnt']) $status=3 ;
         //elseif ($rec_mess['max_data'] and time()>$rec_mess['max_data'])           $status=3 ;
         // задано только время начала блокировки и оно меньше текущего
         if ($rec_mess['block_from'] and !$rec_mess['block_to'] and time()>$rec_mess['block_from'])  $status=3 ;
         // задано время начала и конца блокировки и оно текущее время между ними
         elseif ($rec_mess['block_from'] and $rec_mess['block_to'] and $rec_mess['block_from']<time() and time()<$rec_mess['block_to'])  $status=3 ;
         else  $status=2 ;
         //$status=($rec_mess['view_cnt']>=$rec_mess['max_cnt'] or time()>$rec_mess['max_data'])? 3:2 ;
             //
         // у виртуальных сообщений нет pkey
         if ($rec_mess['pkey']) execSQL_update('update obj_site_personal_mess set status='.$status.',view_cnt='.$rec_mess['view_cnt'].',view_data='.time().',view_mesto="'.$mesto_name.'" where pkey='.$rec_mess['pkey']) ;
         $rec_mess['status']=$status ;
         //$rec_mess['view_data']=time() ;
         $rec_mess['view_mesto']=$mesto_name ;

             //
         //$options['data']=$rec_mess ;
         // вместо общего лога сохраням историю показа сообщений в таблице лога

         //LOGS()->reg_log('Показ сообщения сотруднику',$mesto_name,$options) ;
         $this->reg_mess_history($rec_mess) ;


         // если указан объект связанный с данным сообщением - дергаем его
         if ($rec_mess['pkey'] and $rec_mess['source_obj']) $this->message_source_obj_on_message_change($rec_mess['pkey']) ;

         return($status) ;
    }

    function reg_mess_history($rec_mess)
    {
        $data=['clss'=>117,
               'indx'=>1,
               'obj_name'=>$rec_mess['obj_name'],
               'mess_id'=>($rec_mess['pkey'])?:0,
               'pass_id'=>($rec_mess['pass_id'])?:0, // pass_id будет только у виртуальных сообщений ПМО
               'personal_id'=>$rec_mess['personal_id'],
               'status'=>$rec_mess['status'],
               'view_mesto'=>$rec_mess['view_mesto'],
               ] ;
        adding_rec_to_table('personal_mess_history',$data) ;
    }

    // LOGS()->reg_log('on_message_change' заремирован, так как не несет практической нагрузки
    function message_source_obj_on_message_change($mess_id)
    {   $rec_mess=$this->get_message_by_id($mess_id) ;
        if ($rec_mess['source_obj'])
        {   list($ext,$class_name)=explode('/',$rec_mess['source_obj']) ;
            $script_dir=_DIR_EXT.'/'.$ext.'/'.$class_name.'.php' ;
            if (file_exists($script_dir))
            { include_once($script_dir) ;
              if (class_exists($class_name))
              { $obj=new $class_name() ;
                if (method_exists($obj,'on_message_change')) $obj->on_message_change($rec_mess) ;
                //else LOGS()->reg_log('on_message_change','В классе '.$rec_mess['source_obj'].' не найден метод on_message_change') ;
              }
              //else LOGS()->reg_log('on_message_change','В скрипте '.$script_dir.' не найден класс '.$class_name) ;
            } //else LOGS()->reg_log('on_message_change','Не найден скрипт '.$script_dir.' для заданного обработчика '.$rec_mess['source_obj']) ;
        }
    }


    function message_personal_save($mess_id,$form_data=array())
    {   $rec_mess=$this->get_message_by_id($mess_id);
        $data=array() ;
        if ($form_data['mess_text'])        $data['obj_name']=$form_data['mess_text'] ;
        //if (isset($form_data['block_mo']))  $data['block_mo']=(int)$form_data['block_mo'] ;
        if (isset($form_data['status']) and $form_data['status']) $data['status']=$form_data['status'] ;
        // поля max_cnt и max_data более не используются
        //if (isset($form_data['max_cnt']) and $form_data['max_cnt']>0)  $data['max_cnt']=(int)$form_data['max_cnt'] ;
        //if (isset($form_data['max_data']) and $form_data['max_data']!='')
        //{ $data['max_data']=ENGINE()->set_end_of_day_if_time_undefined($form_data['max_data']) ;
        //  $data['block_from']=$data['max_data'] ;// обеспечиванием плавный переход на block_from
        //}
        // внимание! не добавлять  and $form_data['block_from']!='' так так иначе нет возможности сбросить
        if (isset($form_data['view_from']))     $data['view_from']=($form_data['view_from'])? ENGINE()->to_unix_time($form_data['view_from']):0 ;
        if (isset($form_data['view_to']))       $data['view_to']=($form_data['view_to'])? ENGINE()->set_end_of_day_if_time_undefined($form_data['view_to']):0 ;
        if (isset($form_data['block_from']))    $data['block_from']=($form_data['block_from'])? ENGINE()->to_unix_time($form_data['block_from']):0 ;
        if (isset($form_data['block_to']))      $data['block_to']=($form_data['block_to'])? ENGINE()->set_end_of_day_if_time_undefined($form_data['block_to']):0 ;
        if (isset($form_data['auto_close']))    $data['auto_close']=($form_data['auto_close'])? ENGINE()->to_unix_time($form_data['auto_close']):0;
        //if (_sizeof($form_data['mess_view_mode']))  $data['view_mode']=array_sum($form_data['mess_view_mode']) ;
        //else                                       $data['view_mode']=0 ;
        if (_sizeof($data))
        { update_rec_in_table('obj_site_personal_mess',$data,'pkey='.$mess_id) ;
          // обновляем статус сообщений на основаии изменения данных
          $this->update_message_status(array('message_id'=>$mess_id)) ;
        LOGS()->reg_log('Изменение сообщения','',array('data'=>$data,'personal_id'=>$rec_mess['personal_id'],'reffers'=>array($rec_mess['_reffer'],$rec_mess['_personal_reffer']))) ;
        // если указан объект связанный с данным сообщением - дергаем его
          //if ($rec_mess['source_obj']) $this->message_source_obj_on_message_change($mess_id) ;
    }
    }

    // отмена вызова на прием - исполнение
    function message_personal_create(array $form_data,$options=array())
    {   //damp_array($form_data,1,-1);
        //if (_sizeof($form_data['mess_view_mode']))  $view_mode=array_sum($form_data['mess_view_mode']) ;
        //else                                       $view_mode=0 ;
        if ($form_data['account_id']) $account_id=$form_data['account_id'] ;
        else if (isset(MEMBER()->id) and MEMBER()->id) $account_id=MEMBER()->id ;
        else $account_id=0 ;

    	$data=array('clss'=>217,
                   'obj_name'=>$form_data['mess_text'],
                   'group_id'=>$form_data['group_id'],
                   'account_id'=>$account_id,
                   'personal_id'=>$form_data['personal_id'],
                   'status'=>1,
                   //'max_cnt'=>(trim($form_data['mess_view_cnt'])!="")? $form_data['mess_view_cnt']:0,
                   //'view_mode'=>$view_mode,
                   //'block_mo'=>($form_data['block_mo'])? $form_data['block_mo']:0,
                   'source_pkey'=>($form_data['source_pkey'])? $form_data['source_pkey']:0,
                   'source_tkey'=>($form_data['source_tkey'])? $form_data['source_tkey']:0,
                   'source_obj'=>($form_data['source_obj'])? $form_data['source_obj']:''
                  ) ;
       /*if (isset($form_data['mess_view_srok']))
       { $data['max_data']=($form_data['mess_view_srok'])? ENGINE()->set_end_of_day_if_time_undefined($form_data['mess_view_srok']):0;
         $data['block_from']=$data['max_data'] ; // обеспечиванием плавный переход на block_from
       }*/
       //if (isset($form_data['min_time']))       $data['min_data']=($form_data['min_time'])? $form_data['min_time']:0;
       //if (isset($form_data['max_time']))       $data['max_data']=($form_data['max_time'])? $form_data['max_time']:0;
       if (isset($form_data['view_from']))      $data['view_from']=($form_data['view_from'])? ENGINE()->to_unix_time($form_data['view_from']):0;
       if (isset($form_data['view_to']))        $data['view_to']=($form_data['view_to'])? ENGINE()->set_end_of_day_if_time_undefined($form_data['view_to']):0;
       if (isset($form_data['block_from']))     $data['block_from']=($form_data['block_from'])? ENGINE()->to_unix_time($form_data['block_from']):0;
       if (isset($form_data['block_to']))       $data['block_to']=($form_data['block_to'])? ENGINE()->set_end_of_day_if_time_undefined($form_data['block_to']):0;
       if (isset($form_data['auto_close']))     $data['auto_close']=($form_data['auto_close'])? ENGINE()->to_unix_time($form_data['auto_close']):0;
       //if (isset($form_data['max_day']))        $data['max_day']=($form_data['max_day'])? $form_data['max_day']:0;
       if (isset($form_data['c_data']))         $data['c_data']=($form_data['c_data'])? $form_data['c_data']:0;
       //damp_array($data,1,-1);

       // контроль полей
       if (!$data['group_id'])        $data['group_id']=0;
       if (!$data['account_id'])      $data['account_id']=0;
       if (!$data['source_pkey'])      $data['source_pkey']=0;
       if (!$data['source_tkey'])      $data['source_tkey']=0;
       if (!$data['source_obj'])      $data['source_obj']='';

	   // проверка что сообщение не было отправлено ранее только что
	   $last_mess_rec=execSQL_van('select pkey,source_pkey,obj_name,status from obj_site_personal_mess where account_id='.$data['account_id'].' and personal_id='.$data['personal_id'].' order by pkey desc limit 1') ;
	   // искомое сообщение не должно быть "закрыто"!!! Если закрыто, то это не дубликат сообщения
	   if ($last_mess_rec['source_pkey']==$data['source_pkey'] and $last_mess_rec['obj_name']==$data['obj_name'] and $last_mess_rec['status']!=4)
	   {
		   $mess_reffer=$last_mess_rec['_reffer'];
		   LOGS()->reg_log('Дубль отправки сообщения','заблокировано: "'.$last_mess_rec['obj_name'].'"',array('personal_id'=>$form_data['personal_id'],'reffers'=>array($mess_reffer,$form_data['personal_id'].'.'.$this->tkey_personal))) ;
	   }
       else
       {
	       //LOGS()->reg_log('message_personal_create','',array('data'=>$data)) ;
           //if (is_array($form_data['mess_view_mode']))  $data['view_mode']=array_sum($form_data['mess_view_mode']);
       $mess_reffer=adding_rec_to_table('obj_site_personal_mess',$data,array('return_reffer'=>1)) ;
	       list($mess_id,$mess_pkey)=explode('.',$mess_reffer) ;
	       // не отключать так как без этого не вывести журнал событий по сообщению

	       LOGS()->reg_log('Отправка сообщения',$options['comment'],array('personal_id'=>$form_data['personal_id'],'reffers'=>array($mess_reffer,$form_data['personal_id'].'.'.$this->tkey_personal))) ;

	       $this->update_message_status(array('message_id'=>$mess_id)) ;

       }
       if (!$mess_reffer) LOGS()->reg_log('fixed bug','no create mess to person',array('data'=>$data)) ;
       return($mess_reffer) ;
    }


   function messages_personal_close($personal_id,$source_obj,$options=[])
  {   $_usl=[] ;
      $_usl[]='personal_id='.$personal_id ;
      $_usl[]='source_obj="'.$source_obj.'"' ;
      $_usl[]='status!=4' ;
if ($options['event_id']) $_usl[]='mess_event_id='.$options['event_id'] ;
      $usl=implode(' and ',$_usl) ;
      if ($personal_id and $source_obj)
      { $recs_messages_ids=execSQL_line('select pkey from view_personals_messages where '.$usl) ;
        if (_sizeof($recs_messages_ids)) foreach($recs_messages_ids as $mess_id)  PERSONAL()->message_personal_close($mess_id,$options) ;
      }

  }

    function message_personal_close($mess_id,$options=array())
    {  $rec_mess=$this->get_message_by_id($mess_id,array('fields'=>'pkey,personal_id,source_obj')) ;
       $data_close=($options['data_close'])? $options['data_close']:time() ;
       update_rec_in_table('obj_site_personal_mess',array('status'=>4,'enabled'=>0,'close_data'=>$data_close),'pkey='.$mess_id) ;
       LOGS()->reg_log('Закрытие сообщения',$options['comment'],array('personal_id'=>$rec_mess['personal_id'],'reffers'=>array($rec_mess['_reffer'],$rec_mess['_personal_reffer']))) ;
       // если указан объект связанный с данным сообщением - дергаем его
       if ($rec_mess['source_obj']) $this->message_source_obj_on_message_change($mess_id) ;
    }

    function message_personal_disabled($mess_id,$options=array())
    {  //$rec_mess=$this->get_message_by_id($mess_id,array('fields'=>'pkey,personal_id,source_obj')) ;
       //$data_close=($options['data_close'])? $options['data_close']:time() ;
       update_rec_in_table('obj_site_personal_mess',array('enabled'=>0),'pkey='.$mess_id) ;
       //LOGS()->reg_log('Закрытие сообщения',$options['comment'],array('personal_id'=>$rec_mess['personal_id'],'reffers'=>array($rec_mess['_reffer'],$rec_mess['_personal_reffer']))) ;
       // если указан объект связанный с данным сообщением - дергаем его
       //if ($rec_mess['source_obj']) $this->message_source_obj_on_message_change($mess_id) ;
    }

    function message_personal_enabled($mess_id,$options=array())
    {  //$rec_mess=$this->get_message_by_id($mess_id,array('fields'=>'pkey,personal_id,source_obj')) ;
       //$data_close=($options['data_close'])? $options['data_close']:time() ;
       update_rec_in_table('obj_site_personal_mess',array('enabled'=>1),'pkey='.$mess_id) ;
       //LOGS()->reg_log('Закрытие сообщения',$options['comment'],array('personal_id'=>$rec_mess['personal_id'],'reffers'=>array($rec_mess['_reffer'],$rec_mess['_personal_reffer']))) ;
       // если указан объект связанный с данным сообщением - дергаем его
       //if ($rec_mess['source_obj']) $this->message_source_obj_on_message_change($mess_id) ;
    }

    function message_personal_repeat($mess_id)
    {   $rec_mess=execSQL_van('select * from view_personals_messages where pkey='.$mess_id) ;
        $data=array('view_cnt'=>0,
                    'view_data'=>0,
                    'view_mesto'=>"",
                    'status'=>1,
                    'enabled'=>1,
                    'c_data'=>time()
         ) ;
        update_rec_in_table('obj_site_personal_mess',$data,'pkey='.$mess_id) ;
        LOGS()->reg_log('Повторная отправка сообщения',$rec_mess['obj_name'],array(       'personal_id'=>$rec_mess['personal_id'],
                                                                                          'reffers'=>array($rec_mess['_reffer'],
                                                                                                           $rec_mess['_personal_reffer']
                                                                                                          )
                                                                                         )) ;
        if ($rec_mess['source_obj']) $this->message_source_obj_on_message_change($mess_id) ;
    }

    function message_personal_add_day($mess_id,$count,$options=[])
    {   $rec_mess=execSQL_van('select * from view_personals_messages where pkey='.$mess_id,2) ;
        $data=array() ;
        /*if ($rec_mess['max_data'])
        {  $now=getdate($rec_mess['max_data']) ;
           $max_data=mktime(23,59,59,$now['mon'],$now['mday']+$count,$now['year']);
           // меняем только дату в тексе сообщения, текст сообщения не трогаем
           $text=preg_replace('/\d\d.\d\d\.\d\d\d\d/is',date('d.m.Y',$max_data),$rec_mess['obj_name']) ;
           $data=array('max_data'=>$max_data,
                       'block_from'=>$max_data,
                       'obj_name'=>$text
                       ) ;
           if ($data['max_data']>=time()) $data['status']=($data['view_cnt'])? 2:1 ;
           if ($data['max_data']<time()) $data['status']=3 ;
        }*/
        if (!$rec_mess['block_from']) $rec_mess['block_from']=time() ;
        if ($rec_mess['block_from'])
        {  $now=getdate($rec_mess['block_from']) ;
           $max_data=mktime(23,59,59,$now['mon'],$now['mday']+$count,$now['year']);
           // меняем только дату в тексе сообщения, текст сообщения не трогаем
           $text=preg_replace('/\d\d.\d\d\.\d\d\d\d/is',date('d.m.Y',$max_data),$rec_mess['obj_name']) ;
           $data=array('block_from'=>$max_data,
                       //'max_data'=>$max_data,
                       'obj_name'=>$text
                       ) ;
           if ($data['block_from']>=time()) $data['status']=($data['view_cnt'])? 2:1 ;
           if ($data['block_from']<time()) $data['status']=3 ;
        }
        if (_sizeof($data)) update_rec_in_table('obj_site_personal_mess',$data,'pkey='.$mess_id) ;

        if (!$options['no_reg_log']) LOGS()->reg_log('Увеличение срока возврата документа',$rec_mess['obj_name'],array('personal_id'=>$rec_mess['personal_id'],
                                                                                                                        'reffers'=>array($rec_mess['_reffer'],
                                                                                                                        $rec_mess['_personal_reffer']
                                                                                                                       )
                                                                                         )) ;
        if ($rec_mess['source_obj']) $this->message_source_obj_on_message_change($mess_id) ;
    }

    // обновение статуса по крону
    // проверяем сообщения, которые вышли за предел временных лимитов, изменяем статус
    // max_data более не должны заполняться, будет использоваться поле block_from
    // 1 - Новое - сообщение не было показано сотруднику
    // 2 - Уведомлен // сообщение было показано сотруднику
    // 3 - Блокировка МО // сообщение блокирует прохождение МО
    // 4 - Закрыто // закрыто вручную или завершен срок показа (блокировки) сообщения,
    // 5 - Ожидает // срок показа сообщения еще не наступил


    function update_message_status($options=array())
    {   ob_start() ;
        $result=array() ;
        $usl_select_messages=($options['message_id'])? ' pkey='.$options['message_id'].' and  ':'' ;
        $cur_time=($options['cur_time'])? $options['cur_time']:time() ;
        echo 'Текущее время: '.date('d.m.Y H:i:s',$cur_time) ;
        $recs_mess=execSQL('select pkey,source_obj,view_from,view_to,block_from,block_to,auto_close,status from obj_site_personal_mess where '.$usl_select_messages.' status in (1,2,3,5)') ;
        if (_sizeof($recs_mess)) foreach($recs_mess as $rec_mess)
        {   $new_status=0 ;
            // если в сообщении задан срок окончания блокировки и не задан срок окончания показа - то срока окончания показа = срок окончания блокировки
            if ($rec_mess['block_to'] and !$rec_mess['view_to']) $rec_mess['view_to']=$rec_mess['block_to'] ;

            // если у сообщения стоит дата автозакрытия и она уже прошоа - перевести в статус 4
            if ($rec_mess['auto_close']>0 and $rec_mess['auto_close']<$cur_time) $new_status=4 ;
            // соощения c диапазоном блокировки, блокировка по которым сейчас активана - перевести в статус 3
            elseif ($rec_mess['block_from']>0 and $rec_mess['block_to']>0 and $rec_mess['block_from']<$cur_time and $rec_mess['block_to']>$cur_time) $new_status=3 ;
            // сообщения с заданной датой начала блокировки, даты окончания нет
            else if ($rec_mess['block_from']>0 and $rec_mess['block_to']==0 and $rec_mess['block_from']<$cur_time) $new_status=3 ;
            // сообщения с заданной датой окончания блокировки, даты начала нет
            else if ($rec_mess['block_from']==0 and $rec_mess['block_to']>0 and $rec_mess['block_to']>$cur_time) $new_status=3 ;
            // сообщения с диапазоном показа
            else if ($rec_mess['view_from']>0 and $rec_mess['view_to']>0 and $rec_mess['view_from']<$cur_time and $rec_mess['view_to']>$cur_time) $new_status=1 ;
            // сообщения с заданной датой начала показа, даты окончания нет
            else if ($rec_mess['view_from']>0 and $rec_mess['view_to']==0 and $rec_mess['view_from']<$cur_time) $new_status=1 ;
            // сообщения с заданной датой окончания показа, даты начала нет
            else if ($rec_mess['view_from']==0 and $rec_mess['view_to']>0 and $rec_mess['view_to']>$cur_time) $new_status=1 ;
            // сообщения у которых вышел срок показа
            else if ($rec_mess['view_to']>0 and $rec_mess['view_to']<$cur_time) $new_status=4 ;
            // сообщения у которых вышел срок блокировки
            else if ($rec_mess['block_to']>0 and $rec_mess['block_to']<$cur_time) $new_status=4 ;
            // сообщения у которых еще не наступил срок показа
            else if ($rec_mess['view_from']>0 and $rec_mess['view_from']>$cur_time) $new_status=5 ;

            if ($new_status==1 and ($rec_mess['status']==1 or $rec_mess['status']==2)) $new_status=$rec_mess['status'] ;

            if ($new_status>0 and $new_status!=$rec_mess['status'])
            { $usl_close=($new_status==4)? ',auto_close='.$cur_time:'' ;
              execSQL_update('update obj_site_personal_mess set status='.$new_status.$usl_close.' where pkey='.$rec_mess['pkey']) ;
              if ($rec_mess['source_obj']) $this->message_source_obj_on_message_change($rec_mess['pkey']) ;
              $result[]=array('ID'=>$rec_mess['pkey'],
                              'Показывать от'=>($rec_mess['view_from'])? date('d.m.Y H:i:s',$rec_mess['view_from']):'',
                              'Показывать до'=>($rec_mess['view_to'])? date('d.m.Y H:i:s',$rec_mess['view_to']):'',
                              'Блокировать от'=>($rec_mess['block_from'])? date('d.m.Y H:i:s',$rec_mess['block_from']):'',
                              'Блокировать до'=>($rec_mess['block_to'])? date('d.m.Y H:i:s',$rec_mess['block_to']):'',
                              'Старый статус'=>$_SESSION['ARR_mess_status'][$rec_mess['status']],
                              'Новый статус'=>$_SESSION['ARR_mess_status'][$new_status],
                      );
       }

    }

        if (!$options['message_id'])
        {
             echo 'Проверяем активные сообщения, которые связаны с закрытым участием в мероприятии (enabled=1)<br>' ;
             $recs_mess=execSQL('select t1.pkey,t1.source_obj,t1.view_from,t1.view_to,t1.block_from,t1.block_to,t1.auto_close,t1.status,
                                 t3.obj_name as event_name 
                                from obj_site_personal_mess t1
                                left join obj_site_events_pass t2 on t2.pkey=t1.source_pkey 
                                left join obj_site_events_pass t3 on t3.pkey=t2.event_id 
                                where t1.status in (1,2,3,5) and t1.source_tkey='._DOT('obj_site_events_pass')->pkey.' and t1.enabled=1 and t2.enabled=0
             ',2) ;
             if (_sizeof($recs_mess)) foreach($recs_mess as $rec_mess)
                 { $this->message_personal_close($rec_mess['pkey'],['comment'=>'Сообщение закрыто, так как сотрудник не учавствует в мероприятии']) ;
                   execSQL_update('update obj_site_personal_mess set status=4,auto_close='.time().' where pkey='.$rec_mess['pkey']) ;
                     $result[]=array('ID'=>$rec_mess['pkey'],
                                       'Показывать от'=>($rec_mess['view_from'])? date('d.m.Y H:i:s',$rec_mess['view_from']):'',
                                       'Показывать до'=>($rec_mess['view_to'])? date('d.m.Y H:i:s',$rec_mess['view_to']):'',
                                       'Блокировать от'=>($rec_mess['block_from'])? date('d.m.Y H:i:s',$rec_mess['block_from']):'',
                                       'Блокировать до'=>($rec_mess['block_to'])? date('d.m.Y H:i:s',$rec_mess['block_to']):'',
                                       'Старый статус'=>$_SESSION['ARR_mess_status'][$rec_mess['status']],
                                       'Новый статус'=>$_SESSION['ARR_mess_status'][4],
                                       'Мероприятие'=>$rec_mess['event_name'],
                               );
                   LOGS()->reg_log('Закрытие сообщения','Сообщение закрыто, так как сотрудник не учавствует в мероприятии',array('personal_id'=>$rec_mess['personal_id'],'reffers'=>array($rec_mess['_reffer'],$rec_mess['_personal_reffer']))) ;
    }
        }


        if (_sizeof($result)) print_2x_arr($result);
        else echo '<div class=green>Нет сообщений с измененным статусом</div>' ;
        $text=ob_get_clean() ;
        if ($options['debug']) echo $text ;
        if (_sizeof($result)) LOGS()->reg_log('update_message_status','Изменены статусы у '._sizeof($result).' сообщений',array('save_to_file'=>$text)) ;
   }


  /*==================================================================================================================================*/
  //
  // ЗАМЕНА ОБЪЕКТНОЙ МОДЕЛИ
  //
  /*==================================================================================================================================*/

  function update_levels_parents($options=array())
   {
      TREE('obj_site_personals')->update_levels_parents('clss in (1,207,208)',['ext_table'=>'obj_site_workers']);
  }

  function get_select_option($from_id=0,$sel_pkey=0,$options=array())
  { $arr=array() ;
    $options['debug']=0 ;
    $recs=execSQL('select pkey,parent,obj_name from '.$this->table_name.' where enabled=1 and clss in (1,207,208)',$options['debug']) ;
    $recs2=$recs ;
    convert_list_to_tree($recs2,$arr) ;
    $arr2=(isset($from_id))? $arr[$from_id]:$arr ;
    $str=$this->get_select_option2($arr2,$recs,0,$sel_pkey) ;
    return($str) ;

  }

  function get_select_option2($arr,&$recs,$level=0,$sel_pkey=0)
    {  //
       $pref=($level)? str_repeat("&nbsp;&nbsp;",$level):"" ;
       $str='' ;  $level++ ;
       if (_sizeof($arr)) foreach ($arr as $id=>$arr_child)
       {   $sel=($sel_pkey==$id)? 'selected':'' ;
           $str.='<option value="'.$id.'"'.$sel.'>'.$pref.$recs[$id]['obj_name'].'</option>' ;
           if (_sizeof($arr_child)) $str.=$this->get_select_option2($arr_child,$recs,$level,$sel_pkey) ;
       }
       return($str) ;
    }

  // формирует полный путь подразделения на основе полей parent1,parent2,parent3,parent4,parent5....
  function get_full_dep_name_by_dep_levels($rec,$prefix='',$separator=' / ')
  { $arr=array() ;
    //if (isset($rec[$prefix.'parent1'])) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent1']] ;
    //if (isset($rec[$prefix.'parent2'])) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent2']] ;
    if (isset($rec[$prefix.'parent3']) and $rec[$prefix.'parent3']) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent3']] ;
    if (isset($rec[$prefix.'parent4']) and $rec[$prefix.'parent4']) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent4']] ;
    if (isset($rec[$prefix.'parent5']) and $rec[$prefix.'parent5']) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent5']] ;
    if (isset($rec[$prefix.'parent6']) and $rec[$prefix.'parent6']) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent6']] ;
    if (isset($rec[$prefix.'parent7']) and $rec[$prefix.'parent7']) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent7']] ;
    if (isset($rec[$prefix.'parent8']) and $rec[$prefix.'parent8']) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent8']] ;
    if (isset($rec[$prefix.'parent9']) and $rec[$prefix.'parent9']) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent9']] ;
    $str=(_sizeof($arr))? implode($separator,$arr):'' ;
    return($str) ;
  }
  // формирует полный путь подразделения на основе полей parent1,parent2,parent3,parent4,parent5....
  function get_full_dep_name_by_dep_id($dep_id,$options=array())
  { $rec=execSQL_van('select * from obj_site_personals where pkey='.$dep_id) ;
    $arr=array() ;
    //if (isset($rec[$prefix.'parent1'])) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent1']] ;
    //if (isset($rec[$prefix.'parent2'])) $arr[]=_IL('ARR_deps')->recs_names[$rec[$prefix.'parent2']] ;
    if ($GLOBALS['LS_view_org_name_in_dep_tree'] and !$options['no_org_view'] and isset($rec['parent2']) and $rec['parent2']) $arr[]=_IL('ARR_deps')->recs_names[$rec['parent2']] ;
    if (isset($rec['parent3']) and $rec['parent3']) $arr[]=_IL('ARR_deps')->recs_names[$rec['parent3']] ;
    if (isset($rec['parent4']) and $rec['parent4']) $arr[]=_IL('ARR_deps')->recs_names[$rec['parent4']] ;
    if (isset($rec['parent5']) and $rec['parent5']) $arr[]=_IL('ARR_deps')->recs_names[$rec['parent5']] ;
    if (isset($rec['parent6']) and $rec['parent6']) $arr[]=_IL('ARR_deps')->recs_names[$rec['parent6']] ;
    if (isset($rec['parent7']) and $rec['parent7']) $arr[]=_IL('ARR_deps')->recs_names[$rec['parent7']] ;
    if (isset($rec['parent8']) and $rec['parent8']) $arr[]=_IL('ARR_deps')->recs_names[$rec['parent8']] ;
    if (isset($rec['parent9']) and $rec['parent9']) $arr[]=_IL('ARR_deps')->recs_names[$rec['parent9']] ;
    $arr[]=$rec['obj_name'] ;
    $str=implode(' / ',$arr) ;
    return($str) ;
  }

 //==========================================================================================================================================================================
 // РАБОТА с ГРУППАМИ  - пемещена из ACCOUNTS
 //==========================================================================================================================================================================

  function group_create($form_data)
  { $list_tkey=_DOT(TM_LIST)->pkey ;
    $result=_CLSS(20)->obj_create($form_data,array('parent_reffer'=>_IL('IL_groups')->list_id.'.'.$list_tkey)) ;
    // добавляем запись в таблицу фильтров
    PERSONALS_FILTER()->append_rec_to_personals_filter($result['_reffer'],[],'view_personals_group_'.$result['id']) ;
    $this->group_personal_change($result['id']) ;
    return($result) ;
  }

  function group_delete($ids)
  { $list_tkey=_DOT(TM_LIST)->pkey ;
    $result=_CLSS(20)->obj_delete($list_tkey,$ids) ;
    return($result) ;
  }

  function group_personal_save($group_id,$data,$options=array())
  {   $list_pkey=_IL('IL_groups')->get_pkey_by_id($group_id) ;
      update_rec_in_table('obj_site_list',$data,'pkey='.$list_pkey) ;
      $this->group_personal_change($group_id) ;
  }

  function group_personal_change($group_id)
  {
      $this->update_group_viewer($group_id) ;
  }

  function update_group_viewer($group_id)
  {
      PERSONALS_FILTER()->update_viewer_personals('view_personals_group_'.$group_id) ;
  }

  function update_groups_viewers()
  {
    PERSONALS_FILTER()->update_viewer_personals('view_personals_group_') ;
  }

  // временная функция для синхронизации данных по фильтрам в группе с новой схемой хранения фильтров
  function sync_personals_group_filter($id)
  {
    $rec_group=PERSONAL()->get_group_by_id($id) ;
    $filter_set=PERSONALS_FILTER()->get_personals_filter_to_item($rec_group['_reffer']) ;
    $ext_info=$rec_group['_ext_info'] ;
    $ext_info['personals']=[] ;
    foreach($filter_set as $filter) $ext_info['personals'][]=['filter'=>$filter] ;
    PERSONAL()->group_personal_save($id,['ext_info'=>$ext_info]) ;
  }


  function get_list_groups($options=array())
     { //$recs=execSQL('select * from '.TM_LIST.' where clss=20 and enabled=1 and parent='._IL('IL_groups')->list_id.' order by indx,obj_name') ;
       $recs=_IL('IL_groups')->recs ;
       if (_sizeof($recs)) foreach($recs as $id=>$rec) $this->prepare_public_info_to_group($recs[$id],$options) ;
       return($recs) ;
     }

   function get_group_by_URL($URL)
   {  $arr=explode('.',$URL) ;
      $rec=$this->get_group_by_id($arr[0])  ;
      return($rec) ;
   }

   function get_group_by_id($id)
   {   $rec=_IL('IL_groups')->recs[$id] ;
       if ($rec['pkey']) $this->prepare_public_info_to_group($rec) ;
       return($rec) ;
   }
   function get_group_by_pkey($id)
   {   $rec=execSQL_van('select * from obj_site_list where pkey='.$id) ;
       if ($rec['pkey']) $this->prepare_public_info_to_group($rec) ;
       return($rec) ;
   }

   function prepare_public_info_to_group(&$rec,$options=array())
   {
       $rec['__href']='/cab/esmo_setting/group_of_personal/'.$rec['id'].'/' ;
       $rec['_ext_info']=unserialize($rec['ext_info']) ;
       if ($rec['_ext_info']===false) $rec['_ext_info']=json_decode($rec['ext_info'],1) ;
   }

function convert_tree_to_list($arr,&$recs,$name)
 { if (is_array($arr) and _sizeof($arr)) foreach($arr as $id=>$node_info)
   { //var_dump($name) ; echo '<br>' ;
     $node_name=(isset($node_info['name']))? $node_info['name']:'' ;
     $recs[$id]=($name)? $name.' / '.$node_name:$node_name;
     if (isset($node_info['name'])) unset($node_info['name']) ;
     $aa=(isset($recs[$id]))? $recs[$id]:'' ;
     if ($node_info!='' and _sizeof($node_info)) $this->convert_tree_to_list($node_info,$recs,$aa) ;
     unset($recs['name']) ;
   }
 }



 function get_arr_orgs_to_cur_account($options=array())
 {   $arr=array() ; $left_join=[] ; //damp_array($options);
     if (!$options['view_disabled']) $arr['Показать действвующих']='t1.enabled=1' ;
     if ($options['view_disabled']==1)  $arr['Показать уволенных']='t1.enabled=0' ;
     $arr['Задана организация']='t1.parent2>0' ;
     //if ($usl) $arr['Переданное условие']=$usl ;

     // учет области видимости теккущего аккакнтуа
     if (MEMBER()->personal_viewer_name and !$options['no_use_account_usl_select']) PERSONALS_FILTER()->prepare_left_join_on_table(MEMBER()->personal_viewer_name,$left_join,'t1.personal_id') ;
     // учет области видимости текущего объекта
     if ($options['viewer_name']) PERSONALS_FILTER()->prepare_left_join_on_table($options['viewer_name'],$left_join,'t1.personal_id') ;
     if ($options['viewer_ids']) PERSONALS_FILTER()->prepare_left_join_on_table($options['viewer_ids'],$left_join,'t1.personal_id') ;
     // формируем строки для SQL left join
     list($join_table,$join_usl)=PERSONALS_FILTER()->prepare_SQL_left_join($left_join) ;

     $usl_select=implode(' and ',$arr) ;

      $arr_ids=execSQL_line('select distinct(t1.parent2) as pkey 
                             from obj_site_workers t1
                             '.$join_table.'
                             where '.$usl_select.$join_usl) ;

     $arr_names=array() ;
     if (_sizeof($arr_ids)) $arr_names=execSQL_row('select pkey,obj_name from obj_site_personals where pkey in ('.implode(',',$arr_ids).') order by obj_name') ;
     if (_sizeof($arr_names)) foreach($arr_names as $id=>$name) if (!$name) $arr_names[$id]='Организация # '.$id ;

     return($arr_names) ;
 }

 // функция должна отдавать результат только если выбрана одна организация
 function get_arr_otdels_to_cur_account($org_ids,$usl='',$options=array())
 {   $arr=array() ;
     //$arr[]='clss=211' ;
     if (!$options['view_disabled']) $arr['Показать действвующих']='t1.enabled=1' ;
     if ($options['view_disabled']==1)  $arr['Показать уволенных']='t1.enabled=0' ;

     if (_sizeof($org_ids)) $arr[]='t1.parent2 in ('.implode(',',array_keys($org_ids)).')' ;
     $arr[]='t1.parent3>0' ;
     //if ($usl) $arr[]=$usl ;

      // учет области видимости теккущего аккакнтуа
     if (MEMBER()->personal_viewer_name and !$options['no_use_account_usl_select']) PERSONALS_FILTER()->prepare_left_join_on_table(MEMBER()->personal_viewer_name,$left_join,'t1.personal_id') ;
     // учет области видимости текущего объекта
     if ($options['viewer_name']) PERSONALS_FILTER()->prepare_left_join_on_table($options['viewer_name'],$left_join,'t1.personal_id') ;
     if ($options['viewer_ids']) PERSONALS_FILTER()->prepare_left_join_on_table($options['viewer_ids'],$left_join,'t1.personal_id') ;
     // формируем строки для SQL left join
     list($join_table,$join_usl)=PERSONALS_FILTER()->prepare_SQL_left_join($left_join) ;

     $usl_select=implode(' and ',$arr) ;

     // получаем ids путей подраделений путем группировки parent
     $recs_ids=execSQL('select t1.parent3,t1.parent4,t1.parent5,t1.parent6,t1.parent7,t1.parent8,t1.parent9
                        from obj_site_workers t1
                        '.$join_table.'
                        where '.$usl_select.$join_usl.'
                        group by t1.parent3,t1.parent4,t1.parent5,t1.parent6,t1.parent7,t1.parent8,t1.parent9
                       ') ;

     $arr_section_names=[] ; $arr_ids=[] ; $arr_section_patch=[] ;
     // собираем массив уникальных значений id подразделов
     if (_sizeof($recs_ids)) foreach($recs_ids as $rec) for($i=3;$i<=9;$i++) if ($rec['parent'.$i]) $arr_ids[$rec['parent'.$i]]=1 ;
     // получаем названия разделов одним запросом
     if (_sizeof($arr_ids)) $arr_section_names=execSQL_row('select pkey,obj_name from obj_site_personals where pkey in ('.implode(',',array_keys($arr_ids)).')') ;
     // собираем путь на основе ids в parent и полученных наименований
     if (_sizeof($recs_ids)) foreach($recs_ids as $rec)
     {   $arr=[] ;
         for($i=3;$i<=9;$i++) if ($rec['parent'.$i]) $arr[]=($arr_section_names[$rec['parent'.$i]])? $arr_section_names[$rec['parent'.$i]]:'Подразделение # '.$rec['parent'.$i];
         $arr_section_patch[$rec['parent3']]=implode(' / ',$arr) ;
     }
     return($arr_section_patch) ;
 }

 function get_arr_works_to_cur_account($org_ids=array(),$otdel_ids=array(),$options=array())
 {   //return ;
     $arr=array() ;
     if (!$options['view_disabled']) $arr['Показать действвующих']='t1.enabled=1' ;
     if ($options['view_disabled']==1)  $arr['Показать уволенных']='t1.enabled=0' ;

     $arr[]='t1.work_id>0' ;
     $arr[]='t1.parent2>0' ;
     // учет отбора по организации в текущем фильре
     if (_sizeof($org_ids)) $arr[]='t1.parent2 in ('.implode(',',array_keys($org_ids)).')' ;
     // учет отбора по подразделение в текущем фильте
     if (_sizeof($otdel_ids)) $arr[]='(t1.parent3 in ('.implode(',',array_keys($otdel_ids)).') or t1.parent4 in ('.implode(',',array_keys($otdel_ids)).') or t1.parent5 in ('.implode(',',array_keys($otdel_ids)).'))' ;
     // учет дополнительного условия отбора
     //if ($usl) $arr[]=$usl ;

     // учет области видимости теккущего аккакнтуа
     if (MEMBER()->personal_viewer_name and !$options['no_use_account_usl_select']) PERSONALS_FILTER()->prepare_left_join_on_table(MEMBER()->personal_viewer_name,$left_join,'t1.personal_id') ;
     // учет области видимости текущего объекта
     if ($options['viewer_name']) PERSONALS_FILTER()->prepare_left_join_on_table($options['viewer_name'],$left_join,'t1.personal_id') ;
     if ($options['viewer_ids']) PERSONALS_FILTER()->prepare_left_join_on_table($options['viewer_ids'],$left_join,'t1.personal_id') ;
     // формируем строки для SQL left join
     list($join_table,$join_usl)=PERSONALS_FILTER()->prepare_SQL_left_join($left_join) ;

     //damp_array($arr) ;
     $usl_select=implode(' and ',$arr) ;
     $arr_workings_names=array() ;
     // используем для получения списка долженостей таблицу СО а не таблицу ФЛ !!!!
          $arr_workd_ids=execSQL_line('select distinct(t1.work_id) 
                                       from obj_site_workers t1
                                       '.$join_table.'
                                       where '.$usl_select.$join_usl) ;

     if (_sizeof($arr_workd_ids)) $arr_workings_names=execSQL_row('select id,obj_name from view_IL_works where id in ('.implode(', ',$arr_workd_ids).') order by obj_name') ;
     if (_sizeof($arr_workings_names)) foreach($arr_workings_names as $id=>$name) if (!$name) $arr_workings_names[$id]='Должность # '.$id ;
     return($arr_workings_names) ;
 }

 // возвращает три массива по доступному списку организаций, подразделений, должностей для отчетов по сотрудникам мероприятий
 function get_org_otdels_works_to_cur_account($filter,$options=[])
 {  // если передаен reffer фильтра, prepare_left_join_on_filter_reffer проверит есть ли готовый вьювер на эти условия
    // если нет - будет создана temp table
    // далее в left_join будет подготовлены фрагменты для SQL-запроса
    // и будет возвращено имя вьювера или временной таблицы
     if ($options['filter_reffer']) $options['viewer_ids']=PERSONALS_FILTER()->get_viewer_name_by_filter_reffer($options['filter_reffer'],$options) ;
     if ($filter['org_id'] and !_sizeof($filter['org_ids'])) $filter['org_ids'][$filter['org_id']]=1 ;
     $arr_orgs_ids=PERSONAL()->get_arr_orgs_to_cur_account($options) ;
     $arr_otdel_ids=(_sizeof($filter['org_ids']))? PERSONAL()->get_arr_otdels_to_cur_account($filter['org_ids'],'',$options):array() ;
     $arr_workd_ids=PERSONAL()->get_arr_works_to_cur_account($filter['org_ids'],$filter['otdel_ids'],$options) ;
     return([$arr_orgs_ids,$arr_otdel_ids,$arr_workd_ids,$options['viewer_ids']]) ;
 }

 // временено оставляем для совместимости со старыми проектаи
 function get_arr_working_by_usl($arr_org_ids=array(),$arr_otdel_ids=array()) {return $this->get_arr_works_to_cur_account($arr_org_ids,$arr_otdel_ids) ;}

    // загрузка отложенных фото сотрудников
    function upload_image_personal_async()
     {  include_once(_DIR_TO_ENGINE.'/admin/i_admin_system.php') ;
        $cnt=execSQL_value('select count(pkey) from obj_site_personals where clss=211 and upl_img!=""') ;
        $cnt_upl=0 ;  $cnt_after=0 ;
        ?><h2>В очереди на загрузку фото <?echo $cnt?> записей сотрудников</h2><?
        LOG_JSON('upload_image_personal')->reg('upload_image','В очереди на загрузку фото '.$cnt.' записей сотрудников');
        $recs=execSQL('select pkey,obj_name,upl_img from obj_site_personals where clss=211 and upl_img!="" order by pkey limit 200') ;
        if (_sizeof($recs))
        {   foreach($recs as $rec)
            { ob_start() ;
              $info=array() ;
              ?><strong><?echo $rec['obj_name']?></strong><br><?
              $upl_img=unserialize($rec['upl_img']) ;
              if (_sizeof($upl_img['url'])) foreach($upl_img['url'] as $url_img) if ($url_img)
              {
                  //$url_img=str_replace('esmo-server','pl-server',$url_img) ;
                  $temp_fname=_DIR_TO_ROOT.'/temp/'.ENGINE()->generate_UID().'.jpg' ;
                  echo 'Загружаем фото с URL: <strong>'.$url_img.'</strong><br>' ;
                  $result=IO()->doPut_v3($url_img) ; //damp_array($result,1,-1);
                  if ($result['status']==200 and $result['content'])
                  {   $res=file_put_contents($temp_fname,$result['content']) ;
                      if (!$res) echo '<div class=red>Не удалось сохранить фото во временной директории</div>' ;
                      else
                      {   $type=mime_content_type($temp_fname) ;
                          echo 'Сохранен файл: <strong>'.hide_server_dir($temp_fname).'</strong>, тип <strong>'.$type.'</strong><br>' ;
                          $upload_image_options=['source_action'=>'Фото из шлюза'];
                          if ($GLOBALS['LS_esmo_gateway_delete_old_photo']) $upload_image_options['delete_old_photo']=1;
                          if ($type=='image/jpeg') $this->personal_upload_image($rec['pkey'],$temp_fname,$upload_image_options) ;
                          else echo '<div class=red>Загруженный файл не является файлом изображения. <a href="'.hide_server_dir($temp_fname).'" target="_blank">Ссылка</a></div>' ;
                      }
                  }
                  //obj_upload_image_by_href($rec['_reffer'],$url_img,array('view_upload'=>1,'finfo'=>array(),'dont_generate_uid_to_file_name'=>1)) ;
              }

              $fname=execSQL_value('select file_name from obj_site_personals_image where parent='.$rec['pkey'].' and enabled=1 order by indx desc limit 1') ;
              execSQL_update('update obj_site_personals set upl_img="",_image_name="'.$fname.'" where pkey='.$rec['pkey']) ;
              $cnt_upl++ ;
              $text=ob_get_clean() ;
              echo $text ;
              LOG_JSON('upload_image_personal')->reg('upload_image',$text);


            }
            $cnt_after=execSQL_value('select count(pkey) from obj_site_personals where clss=211 and upl_img!=""') ;
            ?><h2>В очереди на загрузку фото <?echo $cnt_after?> записей</h2><?
            LOG_JSON('upload_image_personal')->reg('upload_image','В очереди на загрузку фото '.$cnt_after.' записей сотрудников');
        }
        if (_sizeof($recs))
        { $log_fname=LOG_JSON('upload_image_personal')->flush('upload_image_personal_'.ENGINE()->generate_UID());
          LOGS()->reg_log('upload_image_personal','<a href="'.$log_fname.'" target="_blank">Лог</a>',array('account_id'=>MEMBER()->id)) ;
        }
     }

     // функция для загрузки внешних данных через крон
     function upload_personal_from_ext_data()
     {  if (!$GLOBALS['LS_esmo_gateway_ext_source']) return ;
        ob_start() ;
                include_once(_DIR_EXT.'/esmo_gateway/c_services_esmo_gateway_upload_persons.php') ;
        $upload=new c_services_esmo_gateway_upload_persons(array('ext_source'=>$GLOBALS['LS_esmo_gateway_ext_source'])) ;
        $result=$upload->exec() ;
        ob_end_clean() ;
        return $result;
     }


    function check_fired_pause_day()
    {  ob_start() ;
       // сначала проводим отложенное увольнение по СО
       $ids=execSQL_row('select pkey,personal_id from obj_site_workers where clss=212 and enabled=1 and fired_data_pause>0 and fired_data_pause<'.time()) ;
       if (_sizeof($ids)) foreach($ids as $id=>$personal_id)
       {  echo 'Увольняем СО # '.$id.', ФЛ # '.$personal_id.'<br>' ;
       	  $this->worker_save($id,array('fired'=>1)) ;
       } else echo 'СО на увольнение не найдено<br>' ;
       // переносим информацию по ОУ из СО в ФЛ для обратной совместимости
       include_once(_DIR_EXT.'/esmo_gateway/i_personal_import.php') ;
       PERSONAL_IMPORT()->sync_workings_persons() ;
       // проводим отложенное увольнение для ФЛ, если не используется система с СО
       $ids=execSQL_line('select pkey from obj_site_personals where clss=211 and enabled=1 and fired_data_pause>0 and fired_data_pause<'.time()) ;
       if (_sizeof($ids)) foreach($ids as $id)
       { echo 'Увольняем ФЛ # '.$id.'<br>' ;
       	  $this->personal_save($id,array('fired'=>1),array('source_action'=>'Проверка отложенного увольнения')) ;
       } else echo 'ФЛ на увольнение не найдено<br>' ;

       $text=ob_get_clean() ;
       echo $text ;
       LOGS()->reg_log('check_fired_pause_day',$text) ;

    }

    // обрабочик события прошедшего МО
    // если человек был в статусе отложенного увольнения, после прохождения МО этот статус снимается
    function personal_fired_pause_cancel($personal_id)
      { // сначала проводим отложенное увольнение по СО
        //  trace() ;
        $recs_workers=execSQL('select pkey,fired_data_pause from obj_site_workers where personal_id='.$personal_id) ;
        // смотрим сколько у сотрудника активных должностей без отложенного увольнения
        $cnt_active=execSQL('select count(pkey) from obj_site_workers where personal_id='.$personal_id.' and enabled=1 and fired_data_pause=0') ;
        if (!$cnt_active)
        { if (_sizeof($recs_workers)) foreach($recs_workers as $rec_worker) if ($rec_worker['fired_data_pause']>0) PERSONAL()->worker_save($rec_worker['pkey'],array('fired_pause_cancel'=>1),array('source_action'=>'Отмена отложенного увольнения')) ;
          // проводим отложенное увольнение для ФЛ, если не используется система с СО
          $rec_personal=execSQL_van('select pkey,fired_data_pause from obj_site_personals where pkey='.$personal_id) ;
          if (_sizeof($rec_personal) and $rec_personal['pkey'] and $rec_personal['fired_data_pause']>0) PERSONAL()->personal_save($personal_id,array('fired_pause_cancel'=>1,array('source_action'=>'Отмена отложенного увольнения'))) ;
        }


      }


      // функция с магнита из import_photo_from_skud
      function personal_upload_image($personal_id,$img_dir,$options=array())
      { include_once(_DIR_TO_ENGINE.'/admin/i_img_working.php')  ;
        include_once(_DIR_TO_ENGINE.'/admin/i_admin_system.php')  ;
	    // предсоздание записи в базе для получения ID записи
	    $result['image_id']=adding_rec_to_table('obj_site_personals_image',array('parent'=>$personal_id,'indx'=>999)) ;
	    if ($result['image_id'])
	    { // загружаем оригинал фото в папку source
        $tkey=_DOT('obj_site_personals_image')->pkey ;
        //damp_array(_DOT('obj_site_personals_image')) ;
        $fname=($options['fname'])? $options['fname']:basename($img_dir) ;
	        $new_fname=$personal_id.'_'.$result['image_id'].'_'.$fname ;
        $new_fdir=_DOT($tkey)->dir_to_file.'source/' ;



        if (file_exists($new_fdir.$new_fname)) $new_fname=$personal_id.'_'.ENGINE()->generate_UID().'_'.$fname ;
        $result['from']=$img_dir ;
        $result['to']=$new_fdir.$new_fname ;
        $result['fname']=basename($img_dir) ;
        $result['personal_id']=$personal_id ;
	        $old_fname=execSQL_value('select _image_name from obj_site_personals where pkey='.$personal_id) ;

        if (copy($img_dir,$new_fdir.$new_fname))
        {  // оригинал скопирован, создаем клоны
           create_clone_image($tkey,$new_fname,array('view_upload'=>1)) ;
           // сдвигаем все текущие фото сотрудника на одну вверх
	           //execSQL_update('update obj_site_personals_image set indx=indx+1 where parent='.$personal_id) ;
	           execSQL_update('update obj_site_personals_image set indx=indx+1,faceimg=0 where parent='.$personal_id) ;
	           // обновлеяем данные по новое фото
           list($size_info,$file_type)=get_small_file_info($new_fdir.$new_fname,array('view_upload'=>1)) ;
	           $data_img=array('indx'=>1,'obj_name'=>basename($img_dir),'file_name'=>$new_fname,'type'=>$file_type,'size'=>$size_info) ;
	           $result['image_id']=update_rec_in_table('obj_site_personals_image',$data_img,'pkey='.$result['image_id']) ;
           // обновляем в записи по сотруднику название главного фото

               if ($options['delete_old_photo'])
               {    //удаляем старые фото
                    $old_image_recs=execSQL('select pkey,indx,file_name from obj_site_personals_image where indx>1 and parent='.$personal_id);
                    if (_sizeof($old_image_recs)) foreach ($old_image_recs as $old_image_rec)
                    {
                        if (is_file(_DOT($tkey)->dir_to_file.'source/'.$old_image_rec['file_name'])) unlink(_DOT($tkey)->dir_to_file.'source/'.$old_image_rec['file_name']);
                        delete_clone_image($tkey,$old_image_rec['file_name']);
                    }
                    execSQL_update('delete from obj_site_personals_image where indx>1 and parent='.$personal_id);
               }

           update_rec_in_table('obj_site_personals',array('_image_name'=>$new_fname),'pkey='.$personal_id) ;
		       PERSONAL()->log_personal_change($personal_id,0,0,'_image_name',$old_fname,$new_fname,$options['source_action']) ;
           // регистрируем событие в журнале
	           PERSONAL()->log_personal_change($personal_id,0,0,'faceid','',0,$options['source_action']) ;
           // генерим событие смены фото
           ENGINE()->on_event('personal_change_photo',array('personal_id'=>$personal_id,'source'=>$options['source_action'])) ;
        }
	        else
	        { $result['error']='Не удалось скопировать файл в место назначения' ;
	          execSQL_update('delete from obj_site_personals_image where pkey='.$result['image_id']) ;
	        }
	    } else $result['error']='Не удалось создать запись в БД для нового изображния' ;
        return($result) ;
      }

    function full_group_id_to_personal()
       {   ?><strong>Проверка заполнения group_id для сотрудников</strong><br><?
           $recs_orgs=execSQL_row('select pkey,group_id from obj_site_personals where clss in (206,207) and group_id>0',0) ;
           if (_sizeof($recs_orgs))
           {   $sum_cnt=0 ;
               foreach($recs_orgs as $id=>$group_id)
               { $cnt=execSQL_update('update obj_site_personals set group_id='.$group_id.' where (parent2='.$id.' or parent3='.$id.')',array('debug'=>0)) ;
                 if ($cnt) echo 'Сохранено GROUP_ID='.$group_id.' у ORG_ID,OTDEL_ID='.$id.' для '.$cnt.' записей<br>' ;
                 $sum_cnt+=$cnt  ;
               }
               if (!$sum_cnt) echo 'Все group_id заполнены корректно<br>' ;
           }
           else
           { $cnt=execSQL_update('update obj_site_personals set group_id=1 where group_id=0',array('debug'=>0)) ;
             if ($cnt) echo 'Сохранено GROUP_ID=1 для '.$cnt.' записей<br>' ;
             else echo 'Все group_id заполнены корректно<br>' ;
           }
       }

       function sync_workers_by_persons($ids='')
       {  ob_start() ;
        $_usl[]='t1.clss=211' ;
        $_usl[]='t2.pkey is null' ;
        if ($ids) $_usl[]='t1.pkey in ('.$ids.')' ;
        $usl=implode(' and ',$_usl) ;
      	 $recs=execSQL('select t1.* 
      						  from obj_site_personals t1
      	                   	  left join obj_site_workers t2 on t2.personal_id=t1.pkey 
      	                   	  where '.$usl)  ;
      	 if (_sizeof($recs)) foreach($recs as $rec)
      		 multiSQL_insert('obj_site_workers')->append(array('clss'=>212,
      				                                           'enabled'=>$rec['enabled'],
      				                                           'parent'=>$rec['parent'],
      				                                           'c_data'=>$rec['c_data'],
                                                                 'r_data'=>$rec['c_data'],
      				                                           'uid'=>($rec['uid'])? $rec['uid']:$rec['pkey'],
      				                                           'personal_id'=>$rec['pkey'],
      				                                           'work_id'=>$rec['working'],
      														   'is_main'=>1,
      													       'is_second'=>0,
      													       'job_data'=>$rec['c_data'],
      													       'fired_data'=>$rec['fired_data'],
      													       'fired_data_pause'=>$rec['fired_data_pause'],
                                                                 'parent1'=>$rec['parent1'],
                                                                 'parent2'=>$rec['parent2'],
                                                                 'parent3'=>$rec['parent3'],
                                                                 'parent4'=>$rec['parent4'],
                                                                 'parent5'=>$rec['parent5'],
                                                                 'parent6'=>$rec['parent6'],
                                                                 'parent7'=>$rec['parent7'],
                                                                 'parent8'=>$rec['parent8'],
                                                                 'parent9'=>$rec['parent9'],
                                                                 )) ;
               multiSQL_insert('obj_site_workers')->flush() ;


       }

    function create_unknown_person($fields) {
        $person_rec=[];
        $name='Unknown';
        if ($fields['propusk']) {
            $data=[];
            $data['uid']='unknown_'.ENGINE()->generate_UID() ;
            $data['propusk']=$fields['propusk'];
            $data['obj_name']=$name;
            $data['dr']='01.01.2000';
            $data['org_name']=$name;

            $reffer=PERSONAL()->personal_create($data) ;
            if ($reffer) {
                list($pkey,$tkey)=explode('.',$reffer) ;
                PERSONAL()->personal_save($reffer,['obj_name'=>$name.' '.$pkey]);
                $person_rec=PERSONAL()->get_personal_by_id($reffer,['no_public_info'=>1]) ;
            }
        }
        return $person_rec;
    }


    // $group_ids - значения в ключах массива !!! так как передается фильтр
     function get_usl_group_personal($fname,$group_ids,$union=' or ')
     {   $usl=array() ;
         if (_sizeof($group_ids))
         { foreach($group_ids as $group_id=>$flag) $usl[]=$fname.' in (select pkey from view_personals_group_'.$group_id.')' ;
           $res='('.implode($union,$usl).')' ;
         }
         return($res) ;
     }


     function prepare_left_join_on_group_personals($fname_from,$fname_to,$group_ids,&$left_join,$title)
     {   $join=[] ; $usl=[] ;
         foreach($group_ids as $group_id=>$flag)
          {   $join[]='left join view_personals_group_'.$group_id.' vpg'.$group_id.' on vpg'.$group_id.'.'.$fname_to.'='.$fname_from ;
              $usl[]='not vpg'.$group_id.'.'.$fname_to.' is null' ;
          }
         $left_join[$title]=['join'=>implode("\n ",$join),'usl'=>'('.implode(" or ",$usl).')'] ;
     }


     // $group_ids - значения в ключах массива !!! так как передается фильтр
     function get_usl_group_medic($fname,$group_ids,$union=' or ')
     {   $usl=array() ; $res='' ;
         if (_sizeof($group_ids))
             { foreach($group_ids as $group_id=>$flag) $usl[]=$fname.' in (select pkey from view_personals_medic_group_'.$group_id.')' ;
               $res='('.implode(' '.$union.' ',$usl).')' ;
             }
         return($res) ;
     }

     // $group_ids - значения в ключах массива !!! так как передается фильтр
     // $group_ids - выбранные значения групп из фильтра
     function prepare_left_join_on_group_medic($fname_from,$fname_to,$group_ids,&$left_join,$title=null,$options=[])
     {   $join=[] ; $usl=[] ; $indx=_sizeof($left_join)+1 ;
         $filter_indx=($options['filter_indx'])? $options['filter_indx']:1 ;
         foreach($group_ids as $group_id=>$flag)
          {   $alias='vpmg'.$group_id.'_'.$filter_indx.'_'.$indx ;
              $join[]='left join view_personals_medic_group_'.$group_id.' '.$alias.' on '.$alias.'.'.$fname_to.'='.$fname_from ;
              $usl[]='not '.$alias.'.'.$fname_to.' is null' ;
          }
         $left_join[$title.'_'.$filter_indx]=['join'=>implode("\n ",$join),'usl'=>'('.implode(" or ",$usl).')'] ;
     }

    function get_usl_select_FL($filter,&$usl_fl,&$left_join,$options=[])
    {   //damp_array($filter);
        $usl_fl[]='fl.clss=211' ;
        if (!$filter['fired'])          $usl_fl[]='fl.enabled=1' ;
        else                            $usl_fl[]='fl.enabled=0' ;
        if ($filter['uid'])             $usl_fl[]='(fl.uid="'.$filter['uid'].'" or fl.pkey='.(int)$filter['uid'].')' ;
        if ($filter['personal_id'])     $usl_fl[]='fl.pkey='.$filter['personal_id'] ;
        if ($filter['ids'])             $usl_fl[]='fl.pkey in ('.implode(',',array_keys($filter['ids'])).')' ;
        if ($filter['propusk'])         $usl_fl[]='fl.propusk="'.$filter['propusk'].'"' ;
        if ($filter['name'])            $usl_fl[]='fl.obj_name like "'.$filter['name'].'%"' ;
        if ($filter['personal_name'])   $usl_fl[]='fl.obj_name like "'.$filter['personal_name'].'%"' ;
        if ($filter['tab_number'])      $usl_fl[]='fl.tab_number="'.$filter['tab_number'].'"' ;
        if ($filter['client_id'])       $usl_fl[]='fl.client_id="'.$filter['client_id'].'"' ;
        if ($filter['client_ids'])      $usl_fl[]='fl.client_id in ('.$filter['client_ids'].')' ;
        if ($filter['age_from'])        $usl_fl[]='fl.age>='.$filter['age_from'];
        if ($filter['age_to'])          $usl_fl[]='fl.age<='.$filter['age_to'];
        if ($filter['person_status']=='OU')  $usl_fl[]='fl.enabled=1 and fl.fired_data_pause>0' ;
        if ($filter['person_status']=='SM')  $usl_fl[]='fl.working>0 and fl.working2>0' ;
        if ($filter['person_status']=='ALL')  $usl_fl[]='fl.enabled=1' ; // все действующие
        else if ($filter['status']==1)   $usl_fl[]='(fl.enabled=0 or fl.enabled is null)' ;
        if ($filter['ext']==1)          $usl_fl[]='fl.ext=1' ; else $usl_fl[]='(fl.ext=0 or fl.ext is null)' ;
        if (isset($filter['personal_ids']) and is_array($filter['personal_ids']) and _sizeof($filter['personal_ids'])) $usl_fl[]='fl.pkey in ('.implode(',',array_keys($filter['personal_ids'])).')' ;
        if (isset($filter['personal_ids']) and is_string($filter['personal_ids']) and strlen($filter['personal_ids'])) $usl_fl[]='fl.pkey in ('.$filter['personal_ids'].')' ;

        // обработка фильтров из очета по сотрудникам, не все понятны зачем нужны, но оставляем для совместимости - пока
        if ($filter['space']) $usl_fl[]='0' ;
        if ($filter['all']) $usl_fl[]='1' ;
        //if (!$this->filter['status'])         $usl_fl[]='fl.enabled=1' ;
        if ($filter['ids_file'])
        {  $ids_file_content = file_get_contents(_TEMP_DIR.$filter['ids_file']);
           $usl_fl[]='fl.pkey in ('.$ids_file_content.')' ;
        }

        // меняем выборку сотрудников по медгруппам и группам сотрудников с in на left join
        if (_sizeof($filter['group_medic']))  $this->prepare_left_join_on_group_medic('fl.pkey','pkey',$filter['group_medic'],$left_join,'group_medic',['filter_indx'=>$options['filter_indx']]) ;
        if (_sizeof($filter['group_pers']))   $this->prepare_left_join_on_group_personals('fl.pkey','pkey',$filter['group_pers'],$left_join,'group_pers') ;

        // собственные условия отбора аккаунта.
        // no_use_account_usl_select - не применять при использовании отчета для формитрования условий отбора сотрудников для вьюверов
        if (!$options['no_use_account_usl_select'] and MEMBER()->personal_viewer_name)
        {   $personal_viewer_name=(!$filter['fired'])? MEMBER()->personal_viewer_name:MEMBER()->personal_viewer_name.'_all' ;
            $left_join['personal_viewer_name']=['join'=>'left join '.$personal_viewer_name.' apf on apf.pkey=fl.pkey','usl'=>'not apf.pkey is null'] ;
        }

        return($usl_fl) ;
    }

    function get_usl_select_SO($filter,&$usl_so,&$left_join)
    {
        if (!$filter['fired'])          $usl_so[]='so.enabled=1' ;
        else                            $usl_so[]='so.enabled=0' ;

        if ($filter['dep_id2'])          $usl_so[]='so.parent='.$filter['dep_id2'] ; // dep_id  -сотрудники только из этого подразделения, без дочерних

        if ($filter['org_id'])          $usl_so[]='so.parent2='.$filter['org_id'] ;
        if ($filter['org_ids'])         $usl_so[]='so.parent2 in ('.implode(',',array_keys($filter['org_ids'])).')' ;
        if ($filter['otdel_id'])        $usl_so[]='(so.parent3='.$filter['otdel_id'].' or 
                                                    so.parent4='.$filter['otdel_id'].' or 
                                                    so.parent5='.$filter['otdel_id'].'  
                                                   )' ;
        if ($filter['otdel_ids'])       $usl_so[]='(so.parent3 in ('.implode(',',array_keys($filter['otdel_ids'])).') or 
                                                    so.parent4 in ('.implode(',',array_keys($filter['otdel_ids'])).') or
                                                    so.parent5 in ('.implode(',',array_keys($filter['otdel_ids'])).')
                                                   )' ;
        if (is_array($filter['working_ids']) and _sizeof($filter['working_ids'])) $usl_so['work']='so.work_id in ('.implode(',',array_keys($filter['working_ids'])).')' ;
        if ($filter['working_id'])      $usl_so[]='so.work_id="'.$filter['working_id'].'"' ;
        if ($filter['working'])         $usl_so[]='so.work_id="'.$filter['working'].'"' ;
        if ($filter['without_temp_fired'])  $usl_so[]='so.fired_data_pause=0';
        if ($filter['person_status']=='FU')  $usl_so[]='so.enabled=1 and so.fired_data>'.time() ;

        // фильтры по дате приема на работу
        if ($filter['job_data_from'])  $usl_so[]='so.job_data>='.strtotime($filter['job_data_from']);
        if ($filter['job_data_to'])  $usl_so[]='(so.job_data<='.strtotime($filter['job_data_to']).' or so.job_data is null) and so.c_data<='.strtotime($filter['job_data_to']);


        // обработка фильтров из очета по сотрудникам, не все понятны зачем нужны, но оставляем для совместимости - пока
        if ($filter['only_org_ids'])            $usl_so[]='so.parent2 in ('.implode(',',array_keys($filter['only_org_ids'])).')' ;
        if ($filter['inrm'])                  $usl_so[]='so.inrm="'.$filter['inrm'].'"' ;
        if ($filter['org_id'])                  $usl_so[]='so.parent2="'.$filter['org_id'].'"' ;
        if (!_sizeof($filter['atp_ids']))       $filter['atp_ids']=[] ;
        if (!_sizeof($filter['rc_ids']))        $filter['rc_ids']=[] ;
        $filter['dep_ids']=$filter['atp_ids']+$filter['rc_ids'] ;
        if (_sizeof($filter['dep_ids']))         $usl[]='so.parent2 in ('.implode(',',array_keys($filter['dep_ids'])).')' ;
        if ($filter['dep_id'])
        {  $cur_level=execSQL_value('select level from obj_site_personals where pkey='.$filter['dep_id']) ;
           if ($cur_level)                      $usl[]='so.parent'.$cur_level.'='.$filter['dep_id'] ;
           else                                 $usl[]='so.parent1=-1' ;
        }


        // по переданным group_ids получаем id сопоставленных организаций
        if ($filter['group_id']) $filter['group_ids'][$filter['group_id']]=1 ;
        if ($filter['group_ids'])
        {  $orgs_ids=execSQL_row('select pkey,obj_name from obj_site_personals where group_id in ('.implode(',',array_keys($filter['group_ids'])).') and clss=207') ;
            if (_sizeof($orgs_ids)) $usl_so[]='so.parent2 in ('.implode(',',array_keys($orgs_ids)).')' ;
            else                    $usl_so[]='so.parent2=-1' ;
        }
        return($usl_so) ;
    }

	function full_org_othdels_work_names(&$list_recs)
	{
		$arr_ids_orgs=[];
		$names_orgs=[];
		$names_works=[];
		$arr_ids_workings=[];
		if(_sizeof($list_recs)) foreach($list_recs as $rec)
		{
			for($i=1;$i<=9;$i++) if($rec['parent'.$i]) $arr_ids_orgs[$rec['parent'.$i]]=1;
			if($rec['work_id']) $arr_ids_workings[$rec['work_id']]=1;
		}
		//damp_array($arr_ids_workings);

		//damp_array($this->filter);

		if(_sizeof($arr_ids_orgs)) $names_orgs=execSQL_row('select pkey,obj_name from obj_site_personals where pkey in ('.implode(',',array_keys($arr_ids_orgs)).')');
		if(_sizeof($arr_ids_workings)) $names_works=execSQL_row('select id,obj_name from view_IL_works where id in ('.implode(',',array_keys($arr_ids_workings)).')');
		//damp_array($names_orgs);
		if(_sizeof($list_recs)) foreach($list_recs as &$rec)
		{
			$arr_otdel_path=[];
			$dep_id=0;
			for($i=1;$i<=9;$i++)
			{
				$parentX='parent'.$i;
				$parentXname='_parent'.$i.'_name';
				if($rec[$parentX]) $rec[$parentXname]=($names_orgs[$rec[$parentX]])? $names_orgs[$rec[$parentX]]:'Организация ID '.$rec[$parentX];
				else $rec[$parentXname]='-';
				if($i>=3 and $rec[$parentX]>0) $arr_otdel_path[]=$rec[$parentXname];
				if($rec[$parentX]) $dep_id=$rec[$parentX]; // запоминаем ID последнего подразделения
			}
			$rec['_otdel_path']=(_sizeof($arr_otdel_path))? implode(' / ',$arr_otdel_path):'-';
			if($rec['work_id']) $rec['_work_name']=($names_works[$rec['work_id']])? $names_works[$rec['work_id']]:'Должность ID '.$rec['work_id'];
			else  $rec['_work_name']='-';
			$rec['_dep_id']=$dep_id;
		}
	}



}



?>
