<?php
$__functions['init'][]='_kt_site_vars' ;
$__functions['boot_site'][]='_kt_site_boot' ;

include_once('i_esmo_rules_kt.php') ;
function ESMO_RULES_KT(){ $esmo_rules=new esmo_rules();return($esmo_rules);}
function KT() {return($_SESSION['kt_system']);$_SESSION['kt_system']=new c_kt_system();return($_SESSION['kt_system']);} ;
define('_SERVER_KT_URL','/equipment_api_kt.php') ;
define('_MONITOR_KT_DIR','/monitor_kt') ;


function _kt_site_vars()
{

}

function _kt_site_boot($options)
{
  create_system_modul_obj('kt',$options) ;
}


class c_kt_system
{
   public $list_device ;
   public $cancel_message ;
   public $id_section_device ;

   public $host ;
   public $list_operator_id ;

   public $table_account ;
   public $table_mo_sessions ;
   public $view_mo_session ;
   public $smena_time ;
   public $group_title ;
   public $dir_monitor ;
   public $url_monitor ;

   public $ARR_status_dopusk=array(   1=>'Разрешен',
                                      2=>'Запрещен',
                                      ) ;
   public $ARR_status_sess=array(     0=>'',
                                      1=>'КТ начат',
                                      2=>'КТ окончен, полож.',
                                      3=>'КТ окончен, отриц.',
                                      4=>'КТ прерван'
                                 ) ;

    public $ARR_kt_tk_type=array (0=>'предсменный',
                                  1=>'послесменный'
                                 ) ;

   function __construct($create_options=array())
   { $this->table_name ='obj_site_kt_session' ;
     $this->view_mo_session ='view_kt_session' ;
     $this->group_title='Зона доступа';
     $this->tkey=_DOT('obj_site_kt_session')->pkey  ;

     $this->table_account='obj_site_device' ;
     $this->table_mo_sessions='obj_site_kt_session' ;

     //регистрируем отчеты
     $this->system_title ='Контроль трезвости';

     ENGINE()->reg_ext('kt','Контроль трезвости') ;

     set_time_point('Создание объекта <strong>kt_system</strong>') ;

   }



    function declare_menu_items_1($page)
        {
            $page->menu['/cab/kt/rmv/[cur_smena]/']=array('title'=>'Контроль трезвости',
                                               'allow_access_to_rol'=>2,
                                               'class'=>'fas fa-beer',
                                               'items'=>array('/cab/kt/rmv/[cur_smena]/'=>'Рабочее место КТ',
                                                              '/cab/kt/hand/'=>'Провести вручную',
                                                              '/cab/kt/terminals/'=>array('title'=>'Терминалы KT','class'=>'fa fa-users',
                                                                                     /* 'items'=>array('/'=>array('title'=>'Усыпить все терминалы','cmd'=>'aspmo/all_term_sleep'),
                                                                                                     '//'=>array('title'=>'Разбудить все терминалы','cmd'=>'aspmo/all_term_start')
                                                                                      ) */

                                                              ),
                                                              '/cab/kt/report_kt/[cur_smena]/'=>'Журнал KT',
                                                              '/cab/kt/monitor/dispatcher/'=>array('title'=>'МОНИТОР ДИСПЕТЧЕРА','class'=>'fa fa-desktop','id'=>'show_window_monitor','window_title'=>'MO_MONITOR'),
                                                              '/cab/kt/monitor/'=>array('title'=>'МОНИТОР КТ','class'=>'fa fa-desktop','id'=>'show_window_monitor','window_title'=>'MO_MONITOR')
                                               )
                                              ) ;
        }

        function declare_menu_items_4($page)
        {   $page->menu['/cab/setting/']['items']['/cab/kt/setting/']['title']='Контроль трезвости' ;
            $page->menu['/cab/setting/']['items']['/cab/kt/setting/']['items']['/cab/kt/setting/']='Настройки КТ' ;
            $page->menu['/cab/setting/']['items']['/cab/kt/setting/']['items']['/cab/kt/setting/device/']='Терминалы КТ' ;
            $page->menu['/cab/setting/']['items']['/cab/kt/setting/']['items']['/cab/kt/setting/device_edit/']='Зоны доступа' ;
            $page->menu['/cab/setting/']['items']['/cab/kt/setting/']['items']['/cab/kt/setting/virt/']='Виртуальный терминал' ;
            //$page->menu['/cab/setting/']['items']['/cab/kt/mo/']['items']['/cab/kt/groups_of_disease/']='Группы по болезни' ;
            //$page->menu['/cab/setting/']['items']['/cab/kt/mo/']['items']['/cab/kt/rules/']='Критерии осмотра' ;
            //$page->menu['/cab/setting/']['items']['/cab/kt/members/']['items']['/cab/kt/terminal/']='Терминалы' ;
            //$page->menu['/cab/setting/']['items']['/cab/kt/members/']['items']['/cab/kt/ssl_check/']='Проверка SSL' ;
        }


        function declare_menu_items_5($page)
        {
            //$page->menu['/cab/esmo_luk/stats/[org_ids=(7106)]/']=array('title'=>'Статистика','class'=>'fa _fa-desktop') ;
            //$page->menu['/cab/esmo_luk/master/']=array('title'=>'Мастер','class'=>'fa _fa-desktop') ;

        }


    //==========================================================================================================================================================================
       // ПРАВИЛО ПРИНЯТИЯ РЕШЕНИЯ НА ДОПУСК В СМЕНУ
       //==========================================================================================================================================================================

       // условия МО зависят от:
       // - возраста
       // - должности
   function get_mo_result_to_personal($rules,$data,$options=array())
   { $_comment=array() ; $res_log=array() ;  $mo_result=array() ;
     ob_start() ;


     if ($rules['a'] and isset($data['a']))
     { if ($data['a']>0)
       { $res='Превышен уровень алкоголя' ;
         $_comment[]=$res ;
         $res_log[]='алкоголь: '.$data['a'].'=>'.$res ;
         $mo_result['res_a']=2 ;
       } else $mo_result['res_a']=1 ;
     }

     $result=(!_sizeof($_comment))? 1:0;
     $text_comment=implode('<br>',$_comment) ;
     $res_log[]='<strong>ИТОГ:</strong>'.$text_comment ;
     // фиксируем все в журнале

     $text=ob_get_clean() ;
     //if ($GLOBALS['LS_kt_logging_full']) LOGS()->reg_log('Оценка результатов КТ',$text.'<br>'.implode('<br>',$res_log),array('personal'=>$rec_personal,'mo_id'=>$options['mo_id'],'data'=>array('Результаты осмотра'=>$data,'Правила'=>$rules))) ;

     $mo_result['status']=($result)? 2:3 ;
     $mo_result['comment']=$text_comment ;
     return($mo_result) ;
   }


  //==========================================================================================================================================================================
  // ТЕРМИНАЛЫ
  //==========================================================================================================================================================================

   function prepare_public_info_to_terminal(&$rec,$options=array())
   {  // переносим информацию из профиля в запись по терминалу
      /*if ($options['debug']){?><h2>Профиль терминала:</h2><? damp_array(_IL('IL_term_prof')->recs[$rec['profil']],1,-1) ;}*/
      $rec['_profil']['video']=_IL('IL_term_prof')->recs[$rec['profil']]['video'] ;
      $rec['_profil']['alcotester']=_IL('IL_term_prof')->recs[$rec['profil']]['alcotester'] ;
      $rec['_zone_name']=SKD()->tree[$rec['zone_id']]->name ;
      $rec['_zone_path']=SKD()->get_full_zone_path($rec['zone_id']) ;
      //$rec['__href']='/window/esmo_setting/terminal/card/'.$rec['pkey'].'/' ;
	  $rec['settings']['remote_endpoint']='/equipment-api-kt.php';
      $rec['settings']['question']=0 ;
      $rec['settings']['signature']=0 ;
   }


   // проверяем испроавность всех устройст терминала согласно профиля
   // !!! не используется
   function check_terminal_to_active($rec_terminal)
   { $allow=1 ;
     // $rec_terminal['_profil']['...'] - устройство по профилю
     // $rec_terminal['...'] - устройство на терминале по информации с check_status
     // проверяем соответствие устройст терминала заданному для него профилю
     // если профиль требует устройство, но устройство = 0 - оно неисправно
     if (!$rec_terminal['alcotester']) { $rec_personal['__check_comment'][]='На терминале неисправен алкотестер' ; $allow=0 ; }
     if (!$allow)
     {   $status=array('alcotester'=>$rec_terminal['alcotester']) ;
         LOGS()->reg_log('Проверка устройств терминала','<div class="red">Набор исправных устройств терминала не соответствует профилю</div>Проверте правильность назначения профиля, исправность устройств терминала, перезагрузите терминал',
                 array( 'reffers'=>array($rec_terminal['_reffer']),
                        'terminal_id'=>$rec_terminal['id'],
                        'data'=>array('Состояние устройств'=>$status,
                                      'Профиль терминала'=>$rec_terminal['_profil'],
                                      'Название профиля терминала'=>$rec_terminal['_profil_name']
                        ))) ;
     }
     return($allow) ;

   }

   // проверяем права доступа работника
   function check_personal_access(&$rec_personal,$options=array())
   { ob_start() ;
     $options['debug']=0 ;
     // ПРОВЕРКА запрета КТ в последнем МО (если был выявлен алкоголь)
     $this->check_KT_denited($rec_personal,$options) ;

     $rec_personal['__check']['result']=(!$rec_personal['__check']['KT_denited'])? 1:0;

     if ($rec_personal['demo_access']) $rec_personal['__check']['result']=1 ;

     $text=ob_get_clean() ;
     //if (!$rec_personal['__check']['result'])
     	LOGS()->reg_log('check_personal_access',$text,array('personal_id'=>$rec_personal['pkey'],'data'=>$rec_personal['__check'])) ;
   }

   // ПРОВЕРКА запрета КТ в последнем МО (если был выявлен алкоголь)
   function check_KT_denited(&$rec_personal,$options=array())   // rec - rec_member
   { $rec_personal['__check']['KT_denited']=0 ;
     $rec_personal['debug']=$options['debug'] ;
     if ($rec_personal['demo_access'])
     {   if ($options['debug']) echo 'Сотрудник имеет безлимитный доступ к прохождению KT<br>' ;
         return ;
     }
     // проверяем наличие запрета допуска по фактическому времени жизни допуска
     if ($options['debug']) echo 'Проверяем наличие запрета допуска по фактическому времени жизни допуска<br>' ;
     $rec_dopusk=$this->check_active_dopusk($rec_personal['pkey'],array('no_public_info'=>1,'debug'=>$options['debug'])) ;
     //damp_array($rec_dopusk) ;
     if ($rec_dopusk['dopusk']==2)
     { $rec_personal['__check']['KT_denited']=1 ;
	   $rec_personal['__check']['dopiskDenitedExist']=1 ;
	   $rec_personal['__check_comment'][]='КТ запрещен до '.date('d.m.Y H:i',$rec_dopusk['dopusk_time_end']) ;
	   $rec_personal['__reason']='dopiskDenitedExist' ;
	   $rec_personal['__pause']=0 ;
       return ;
     }
   }

 function check_personal_status(&$rec_personal)
   {   // если блокировка МО
       // при запрете МО текстовку надо сохранить не в $rec['__terminal_comment'] а в $rec['__check_comment']
       if ($rec_personal['mo_block']>0)
       {  $rec_personal['__check_comment']=array() ;
          $rec_personal['__check_comment'][]='Прохождение МО заблокировано' ;
          $rec_personal['__pause']=0 ;
          $rec_personal['__check']['access_by_personal_status']=0 ;
          //LOGS()->reg_log('check_personal_status','',array('data'=>$rec_personal['__check_comment'])) ;
       }
       else $rec_personal['__check']['access_by_personal_status']=1 ;
   }

   //==========================================================================================================================================================================
   // ПОЛУЧЕНИЕ РЕЗУЛЬТАТОВ МО
   //==========================================================================================================================================================================

    function get_mo_session_view_table_tr($mo_session_id)
    {  ob_start() ;
       $rec_session=$this->get_mo_by_id($mo_session_id) ;
       include_once(_DIR_EXT.'/kt/report_kt_monitor.php') ;
       $report_obj=new report_kt_monitor() ;
       $report_obj->list_kt_sessions_tr($rec_session) ;
       return(ob_get_clean()) ;
    }

   //==========================================================================================================================================================================
   // СЕАНС МЕДОСМОТРА
   //==========================================================================================================================================================================

   // добавляем запись по KT в таблицу, возвращает id записи
   // Регистрируются все попытки прохождения КТ
   function open_mo_session($rec_session=array())
   {   $rec_session['c_data']=time() ;
       $rec_session['e_data']=0 ;
       $rec_session['clss']=240 ;
       if (!$rec_session['status']) $rec_session['status']=1 ;
       $rec_session['indx']=1 ;
       //$rec_session['tk']=0 ;

       // смотрим последную нормальную сессию за  заданный переод времени
       //ob_start() ;
       if ($rec_session['member_id'] and !isset($rec_session['tk']))
       { $now=getdate() ;
         $from_time=mktime($now['hours']-$GLOBALS['LS_setting_smena_after'],$now['minutes'],0,$now['mon'],$now['mday'],$now['year']);
         $prev_session=execSQL_van('select * from '.$this->table_mo_sessions.' where c_data>='.$from_time.' and member_id='.$rec_session['member_id'].' and dopusk=1 order by c_data desc limit 1') ;
         $rec_session['tk']=($prev_session['pkey'] and !$prev_session['tk'])? 1:0  ;   // тип контроля 0 - предсменный, 1 - послесменный контроль
       }

       $id=adding_rec_to_table($this->table_mo_sessions,$rec_session) ;
     return($id) ;
   }

   function update_mo_session($sess_id,$rec)
   { list($sess_id,$tkey)=explode('.',$sess_id) ;
     $res=update_rec_in_table($this->table_mo_sessions,$rec,'pkey='.$sess_id,array('debug'=>0)) ;
     return($res) ;
   }

   function prepare_public_info_to_mo(&$rec,$options=array())
   {  $t=fixed_time() ;
      $rec['__href']='/cab/kt/card/'.$rec['pkey'].'/' ;
      $rec['__href_window']='/window/kt/card/'.$rec['pkey'].'/' ;
       $rec['_tk_name']=$_SESSION['ARR_mo_tk_type'][$rec['tk']];

      $arr_ids=array() ; //$recs_account=array() ;
      if ($rec['e_data']) $rec['__dlit_mo']=$rec['e_data']-$rec['c_data'] ;

      // если терминал удален из системы, поле terminal_name будет пустов
      if ($rec['terminal_id'] and !$rec['terminal_name']) $rec['terminal_name']='Терминал № '.$rec['terminal_id'] ;

      if ($rec['hand_check_user_id'])   $rec['_hand_check_user_name']=_IL('ARR_accounts')->recs[$rec['hand_check_user_id']]['_rol_name'].' '._IL('ARR_accounts')->recs[$rec['hand_check_user_id']]['obj_name'] ;
      if ($rec['doctor_id'])            $rec['_doctor_name']=_IL('ARR_accounts')->recs[$rec['doctor_id']]['_rol_name'].' '._IL('ARR_accounts')->recs[$rec['doctor_id']]['obj_name'] ;
      if ($rec['doctor_id'])            $rec['_doctor_name_small']=_IL('ARR_accounts')->recs[$rec['doctor_id']]['obj_name'] ;
      if ($rec['creator_id'])           $rec['_creator_name']=_IL('ARR_accounts')->recs[$rec['creator_id']]['_rol_name'].' '._IL('ARR_accounts')->recs[$rec['creator_id']]['obj_name'] ;
      if ($rec['dopusk_user_id'])       $rec['dopusk_user_name']=_IL('ARR_accounts')->recs[$rec['dopusk_user_id']]['_rol_name'].' '._IL('ARR_accounts')->recs[$rec['dopusk_user_id']]['obj_name'] ;

      $rec['_data']=date('d.m.Y H:i',$rec['c_data']) ;
      $rec['_data_dopusk_end']=($rec['dopusk_time_end']>0 and ($rec['dopusk']==1 or $rec['dopusk']==2))? date('d.m.Y H:i:s',$rec['dopusk_time_end']):0 ;
      $rec['_status_name']=$this->ARR_status_sess[$rec['status']] ;
      if ($rec['reason'])       $rec['_reason']=$_SESSION['ARR_mo_failed_status'][$rec['reason']] ;
      if ($rec['equipment'])    $rec['_equipment']=$_SESSION['ARR_mo_failed_dev'][$rec['equipment']] ;
      if (!$rec['dopusk']) $rec['dopusk']=0 ;
      $rec['_dopusk_name']=($rec['dopusk'])? $this->ARR_status_dopusk[$rec['dopusk']]:'' ;

      if ($rec['dopusk']==1)     $rec['_dopusk_name_full']='Допуск разрешен' ;
      elseif ($rec['dopusk']==2) $rec['_dopusk_name_full']='Допуск запрещен' ;
      else                       $rec['_dopusk_name_full']='КТ не выполнен' ;

      if ($rec['dopusk']==1 or $rec['dopusk']==2)
      { $rec['_dopusk_status']='<div class="dopusk_state_'.$rec['dopusk'].'">'.$rec['_dopusk_name_full'].'</div>' ;
        $rec['_dopusk_status'].='<div class="dopusk_comment">'.date('d.m.Y H:i',$rec['dopusk_time']).' - '.date('H:i',$rec['dopusk_time_end']).'</div>' ;
      }

      if ($rec['error']==5)
      { $rec['_dopusk_status']='<div class="red bold dopusk_state_2">Допуск аннулирован</div>'.$rec['dopusk_user_name'].'<br>'.date('d.m.Y H:i:s',$rec['dopusk_time']) ;
        if ($rec['error_reason']) $rec['_dopusk_status'].='<br>Причина<br><strong>'.$rec['error_reason'].'</strong>' ;
      }

      if ($rec['error']==6)
      { $rec['_dopusk_status']='<div class="red bold dopusk_state_2">ЗАПРЕТ ДОПУСКА аннулирован</div>'.$rec['dopusk_user_name'].'<br>'.date('d.m.Y H:i:s',$rec['dopusk_time']) ;
        if ($rec['error_reason']) $rec['_dopusk_status'].='<br>Причина<br><strong>'.$rec['error_reason'].'</strong>' ;
      }

      // результат МО
      // либо все хорошо, либо выводим причину почему плохо
      $_arr=array() ;
      //if ($rec['status']==2)                   $_arr[]='<div class=ok>'.$rec['_status_name'].'</div>' ; // выводится отдельно
      // если есть ошибка - выводим расшифровку ошибки
      if ($rec['reason'])                      $_arr[]='<div class=red>'.$rec['_reason'].'</div>' ;
      if ($rec['equipment'])                   $_arr[]='<div class=red>'.$rec['_equipment'].'</div>' ;
      //if ($rec['question_comment'])            $_arr[]='<div class=red>'.$rec['question_comment'].'</div>' ; //  выводиться отдельно
      // если есть комментарий к автоматическому принятию решения сервером - выводим
      if ($rec['comment'])                     $_arr[]='<div class=red>'.$rec['comment'].'</div>' ;
      if (_sizeof($_arr)) $rec['_comment']=implode('',$_arr) ;

      if (!$options['no_get_MO_image'])
      {   $img_name='' ;
      if ($rec['member_id'])
          if ($rec['member_img'])   $img_name=$rec['member_img'] ;
              //else                      $img_name=execSQL_value('select file_name from '.PERSONAL()->table_personal.'_image where parent='.$rec['member_id'].' order by indx limit 1') ; ;
      if ($img_name) $rec['_member_img']=_DOT(PERSONAL()->table_personal.'_image')->patch_to_file.'400/'.$img_name ; else  $rec['_member_img']=_PATH_TO_SITE.'/images/no-avatar-62.png' ;
      if (file_exists(_DIR_TO_ROOT.'/public/kt_photo/'.$rec['pkey'].'_auth.jpg')) $rec['_member_img_auth']=_PATH_TO_SITE.'/public/kt_photo/'.$rec['pkey'].'_auth.jpg' ; else   $rec['_member_img_auth']=_PATH_TO_SITE.'/images/no-avatar-62.png' ;
      if (file_exists(_DIR_TO_ROOT.'/public/kt_photo/'.$rec['pkey'].'_alco.jpg')) $rec['_member_img_alco']=_PATH_TO_SITE.'/public/kt_photo/'.$rec['pkey'].'_alco.jpg' ; else   $rec['_member_img_alco']=_PATH_TO_SITE.'/images/no-avatar-62.png' ;
      }

     $rec['_work_name']=_IL('IL_works')->recs[$rec['working']]['obj_name'] ;

      /*{?><tr><td>Подпись сотрудника:</td><td colspan="2" class="left"><img src="http://<?echo _MAIN_DOMAIN?>/services/esmo_pp/graf_signature/?mo_id=<?echo $this->rec_mo['pkey']?>" width="150"></td></tr><?}*/
      // переделать по поле res_n, поле _pp_id берется из въювера

      // озвучиваем решение по алкоголю
      if ($rec['alcotester'])
      {   if ($rec['alko']==-1 and !$rec['equipment']=='alcotester')                        $text='Не додул/ошибка' ;
          else if ($rec['equipment']=='alcotester' and $rec['reason']=='equipmentError')    $text='Сбой замера' ;
          else if ($rec['equipment']=='alcotester' and $rec['reason']=='equipmentFailure')  $text='Неисправность оборудования' ;
          else if ($rec['res_a']==2)                                                        $text='<span class="red bold">Есть</span>' ;
          else if ($rec['res_a']==1)                                                        $text='Нет' ;
          else                                                                              $text='-' ;
          if ($rec['alko_value']>0 and $GLOBALS['LS_view_alcotest_value'])   $text='<span class=nowrap>'.$text.' (<span class="red">'.$rec['alko_value'].'</span>)</span>' ;
          $rec['_alko']=$text ;
      }
   }

    // создаем МО на основе данных формы проверки врачем
      function fixed_hand_check($data,$allow=0)
      { $rec_personal=PERSONAL()->get_personal_by_id($data['personal_id']) ;
	    $rules_info=ESMO_RULES()->get_mo_rules_to_personal($rec_personal,array('rmv_mo'=>1,'esmo_group'=>MEMBER()->cur_group_id)) ;
        $rules=$rules_info['_rules'] ; // критерии проверки сотрудника
        if (!$rec_personal['pkey']) return(0) ;

	    $last_kt_rec=$this->check_active_dopusk($rec_personal['pkey']) ;
	    if ($last_kt_rec['pkey'])
         { $now=getdate($last_kt_rec['dopusk_time']) ;
           $start_check=mktime($now['hours'],$now['minutes']+$GLOBALS['LS_kt_time_rmv_after_tkt'],$now['seconds'],$now['mon'],$now['mday'],$now['year']);
           if ($start_check>=time())
           { //echo '<div style="font-size:16px;text-align:center;color:#272727;">Данные прошлого КТ будут аннулированы,<br> если данная проверка будет выполнена до<br><div style="font-size:22px;margin:20px 0;">'.date('d.m.Y H:i:s',$start_check).'</div></div>' ;
	         $this->hand_dopusk_clear($last_kt_rec['pkey'],array('a'=>$data['a'],'mess'=>'Автоматическое аннулирование результута прошлого КТ при проверке на РМВ')) ;
           }
         }

        $_dopusk_time_S=(float)$GLOBALS['LS_setting_auto_kt_allow_interval']*60 ; // срок действия меддопуска в секундах
        $_nedopusk_time_S=(float)$GLOBALS['LS_setting_auto_kt_denited_interval']*60; // срок действия меддопуска в секундах
        $time_dopusk_S=($allow)?  $_dopusk_time_S:$_nedopusk_time_S ;



        { $res_session=array('member_id'          =>$rec_personal['pkey'],
                             'doctor_id'          =>MEMBER()->id,         // по идее одного doctor_id достаточно
                             'zone_id'           => MEMBER()->cur_zone_id,
                             'creator_id'         =>MEMBER()->id,
                             'hand_check_user_id' =>MEMBER()->id,
                             'dopusk_user_id'     =>MEMBER()->id,
                             'dopusk_time'        =>time(),
                             'dopusk_time_end'    =>time()+$time_dopusk_S,
                             'message_terminal'   =>'success', /// ????? зачем
                             'alcotester'         =>($rules['a'] or $data['a'])? 1:0,
                             'alko'               =>($data['a'])? $data['a']:0,
                             'alko_value'         =>($data['alko_value'])? $data['alko_value']:0,
                             'question'           =>($data['q'])? $data['q']:0,
                             'question_comment'   =>$data['qc'],
                             'doctor_comment'     =>$data['qw']
                            );

          $mo_session_id=$this->open_mo_session($res_session) ; // id записи по проведению МО ;

          // проверяем результат МО врачем, как при автоматической проверке
          $mo_result=$this->get_mo_result_to_personal($rules,$data,array())  ;
          // по  get_mo_result_to_personal будут заполнены поля status,res_s,res_d,res_p,res_t,res_a

          // дополняем служебной информацией
          $mo_result['e_data']=time() ;
          $mo_result['dopusk']=($allow)? 1:2 ; // 1 = Допуск есть, 2 - допуска нет

          // сохраняем данные измерений в запись МО
          $this->update_mo_session($mo_session_id,$mo_result) ; // id записи по проведению МО

          //$mo_session_url='/cab/kt/'.$mo_session_id.'/' ;
          $mo_session_url='/cab/kt/hand/' ;
          // сохраняем в логе
          $result=($allow)? 'Доступ разрешен':'Доступ запрещен' ;
          LOGS()->reg_log('Ручной контроль трезвости',$result,array('member_id'=>$rec_personal['pkey'],'mo_id'=>$mo_session_id)) ;

          $xmpp_message=array() ;
          $xmpp_message['time']=date('d.m.y H:i:s') ; //  подгатавливаем массив информации по всем терминалам текущей группы
          $xmpp_message['from']='c_server::check_access' ;
          $xmpp_message['mo_tr_id']=$mo_session_id ;  ;
          $xmpp_message['mo_tr']=$this->get_mo_session_view_table_tr($mo_session_id) ;  ;
          KT()->reg_monitor_mess(MEMBER()->cur_zone_id,$xmpp_message) ;

          // инициируем событие
          if ($allow) ENGINE()->on_event('kt_fixed_hand_check_allow',array('mo_id'=>$mo_session_id)) ;
          else        ENGINE()->on_event('kt_fixed_hand_check_denited',array('mo_id'=>$mo_session_id)) ;

         return(array($mo_session_id,$mo_session_url)) ;
      }
    }

      // отмена ранее выданного мед.допуска
      function hand_dopusk_clear($mo_id,$data)
      { $rec_mo=$this->get_mo_by_id($mo_id) ;

        $res_session=array('dopusk'   =>0,
                           'status'   =>4,        // 4 - МО не пройден
                           'error'   =>5,         // по идее одного doctor_id достаточно
                           'res_a'=>$data['a'],
                           'error_reason'=>$data['mess'],
                           'dopusk_user_id'=>MEMBER()->id,
                           'dopusk_time'=>time(),
                           'dopusk_time_end'=>0
                          ) ;
        $this->update_mo_session($mo_id,$res_session) ;
        LOGS()->reg_log('Аннулирование допуска доктором',$data['mess'],array('member_id'=>$rec_mo['member_id'],'mo_id'=>$mo_id,'data'=>$data)) ;

        $xmpp_message=array() ;
        $xmpp_message['time']=date('d.m.y H:i:s') ;
        $xmpp_message['from']='hand_dopusk_denited' ;
        $xmpp_message['mo_tr_id']=$mo_id ;  ;
        $xmpp_message['mo_tr']=$this->get_mo_session_view_table_tr($mo_id) ;  ;
        KT()->reg_monitor_mess(MEMBER()->cur_zone_id,$xmpp_message) ;

        ENGINE()->on_event('kt_hand_check_clear',array('mo_id'=>$mo_id)) ;

      }

      // отмена ранее выданного мед.допуска
      function hand_nedopusk_clear($mo_id,$data)
      { $rec_mo=$this->get_mo_by_id($mo_id) ;

        $res_session=array('dopusk'   =>0,
                           'status'   =>4,        // 4 - МО не пройден
                           'error'   =>6,         // по идее одного doctor_id достаточно
                           'dopusk_user_id'=>MEMBER()->id,
                           'dopusk_time'=>time(),
                           'dopusk_time_end'=>0
                          ) ;

        $this->update_mo_session($mo_id,$res_session) ;

        LOGS()->reg_log('Отмена запрета допуска фельдшером',$data['mess'],array('member_id'=>$rec_mo['member_id'],'mo_id'=>$mo_id,'data'=>$data)) ;

        $xmpp_message=array() ;
        $xmpp_message['time']=date('d.m.y H:i:s') ;
        $xmpp_message['from']='hand_nedopusk_clear' ;
        $xmpp_message['mo_tr_id']=$mo_id ;  ;
        $xmpp_message['mo_tr']=$this->get_mo_session_view_table_tr($mo_id) ;  ;
        KT()->reg_monitor_mess(MEMBER()->cur_zone_id,$xmpp_message) ;

        ENGINE()->on_event('kt_hand_check_clear',array('mo_id'=>$mo_id)) ;

    }


   function get_usl_select_mo_by_filter($options=array())
   {   $_usl=array() ; $usl='' ;
       //damp_array($options,1,-1) ;
        $_usl[]='clss=240'  ;
        if ($options['zone_id'] and isset(SKD()->tree[$options['zone_id']])) $_usl[]=(isset(SKD()->tree[$options['zone_id']]))?  'zone_id in ('.SKD()->tree[$options['zone_id']]->get_list_child().')':'zone_id in ('.$options['zone_id'].')' ;
        if ($options['member_id']) $_usl[]='member_id='.$options['member_id'] ;
        // предвыборка по имени сотрудника, номеру пропуска или вод.удостоверения
        if ($options['text_info'])
        {   $arr_ids=execSQL_line('select pkey from obj_site_personals where clss=211 and obj_name like "%'.addslashes($options['text_info']).'%" or propusk like "'.addslashes($options['text_info']).'" or driving like "'.addslashes($options['text_info']).'" or tab_number like "'.addslashes($options['text_info']).'"') ;
            if (_sizeof($arr_ids))  $_usl[]='member_id in ('.implode(',',$arr_ids).')' ;
            else                   $_usl[]='member_id=-1' ;
        }
        if ($options['name'])
        {   $arr_ids=execSQL_line('select pkey from obj_site_personals where clss=211 and obj_name like "%'.addslashes($options['name']).'%"') ;
            if (_sizeof($arr_ids))  $_usl[]='member_id in ('.implode(',',$arr_ids).')' ;
            else                   $_usl[]='member_id=-1' ;
        }
        if ($options['propusk'])
        {   $arr_ids=execSQL_line('select pkey from obj_site_personals where clss=211 and propusk like "'.addslashes($options['propusk']).'"') ;
            if (_sizeof($arr_ids))  $_usl[]='member_id in ('.implode(',',$arr_ids).')' ;
            else                   $_usl[]='member_id=-1' ;
        }
        // номера сессий MO
        if ($options['tk'])     $_usl[]='tk='.($options['tk']-1) ;
        if ($options['mo_ids'])     $_usl[]='pkey in ('.$options['mo_ids'].')' ;
        if ($options['to_mo_id'])     $_usl[]='pkey< '.$options['to_mo_id'].'' ;
        // время передаваемое в unix формате
        if ($options['time_from'])     { $_usl[]='c_data>='.$options['time_from'] ; if ($options['debug']) echo 'Дата от '.date('d.m.Y H:i:s',$options['time_from']).'<br>' ; }
        if ($options['time_to'])       { $_usl[]='c_data<='.$options['time_to'] ; if ($options['debug']) echo 'Дата до '.date('d.m.Y H:i:s',$options['time_to']).'<br>' ; }
         //echo 'time_from='.date('d.m.Y H:i',$options['time_from']).'<br>' ;

        // время передаваемое в текстовом формате
        if ($options['data_from'])     { $_usl[]='c_data>='.strtotime($options['data_from']) ; if ($options['debug']) echo 'Дата от '.date('d.m.Y H:i:s',strtotime($options['data_from'])).'<br>' ; }
        if ($options['data_to'])       { $arr=explode(' ',trim($options['data_to'])) ;
                                         $time_to=(!$arr[1])? strtotime($options['data_to'].' 23:59:59'):strtotime($options['data_to']) ;
                                         $_usl[]='c_data<='.$time_to ;
                                         if ($options['debug']) echo 'Дата до '.date('d.m.Y H:i:s',$time_to) ;
                                       }
        // терминал
        if ($options['terminal_id'])  $_usl[]='(terminal_id in ('.$options['terminal_id'].') or terminal_id is null)' ;
        if ($options['terminal_id_only'])  $_usl[]='(terminal_id in ('.$options['terminal_id_only'].'))' ;

        // допуск
        if (isset($options['dopusk_arr'])) $_usl[]='dopusk in ('.implode(',',array_keys($options['dopusk_arr'])).')' ;
        elseif (isset($options['dopusk']))     $_usl[]='dopusk in ('.$options['dopusk'].')' ;

        // статус МО - начат, пройден, не пройден, прерван
        if ($options['status'])         $_usl[]='status in ('.$options['status'].')' ;
        //
        if ($options['only_check_success'])        $_usl[]='message_terminal="success"'  ;
        //
        if ($options['only_member_enabled'])        $_usl[]='member_enabled=1'  ;
        if ($options['only_member_disabled'])        $_usl[]='member_enabled=0'  ;

        // отдел или организация сотрудника
        if ($options['otdel_id'])      $_usl[]='member_parent="'.$options['otdel_id'].'"' ;
        elseif ($options['org_id'])    { $otdels_ids=PERSONAL()->get_org_otdel_ids($options['org_id']) ;
                                         $otdels_ids[]=$options['org_id'] ;
                                         $_usl[]='member_parent in ('.implode(',',$otdels_ids).')' ;
                                       }
       if ($options['personal_id'])   $_usl[]='personal_id in ('.$options['personal_id'].')' ;
       if (is_array($options['otdel_ids']) and _sizeof($options['otdel_ids']))   $_usl[]='member_parent in ('.implode(',',$options['otdel_ids']).')' ;
       if ($options['dep_id'])
       {  $dep_level=execSQL_value('select level from obj_site_personals where pkey='.$options['dep_id']) ;
          $_usl[]='personal_parent'.$dep_level.'='.$options['dep_id'] ;

       }
       if ($options['org_ids'])  $_usl[]='personal_parent2 in ('.$options['org_ids'].')' ;
       if (!is_array($options['otdel_ids']) and $options['otdel_ids'])  $_usl[]='personal_parent3 in ('.$options['otdel_ids'].')' ;
        // причина непрохождения МО
        if ($options['res_stat']['no_a']) $_usl[]='res_a!=2' ;
        if ($options['res_stat']['a']) $_usl[]='res_a=2' ;

        // условие по ошибке оборудования
        if ($options['res_stat']['e_dev']) $_usl[]='reason="equipmentFailure"' ;
        if ($options['otkaz_mo']) $_usl[]='reason="equipmentError"' ;

        if (isset($options['reason']))    $_usl[]=$this->get_usl_from_array($options['reason']) ;
        if (isset($options['no_reason'])) $_usl[]='reason!="'.$options['no_reason'].'"' ;
        if (isset($options['equipment'])) $_usl[]=$this->get_usl_from_array($options['equipment']) ;

       // применяем фильтры по выборке персонала к вьюверу на МО
       if (!$options['dont_use_member_personal_filter'] and MEMBER()->personal_viewer_name) $_usl['account_personal_filter']='personal_id in (select pkey from '.MEMBER()->personal_viewer_name.')' ;


        if ($options['use_usl'])   $_usl[]=$options['use_usl'] ;
        //damp_array($_usl,1,-1) ;
        if (_sizeof($_usl)) $usl=implode(' and ',$_usl) ;
        return($usl) ;
   }

   function get_usl_from_array($arr)
   {  if (is_array($arr) and _sizeof($arr))
      {  $_tt=array() ;
         foreach($arr as $tt) $_tt[]='reason="'.$tt.'"' ;
         $str='('.implode(' or ',$_tt).' )' ;
      }
      else $str='reason="'.$arr.'"' ;
      return($str) ;
   }

   function get_mo_recs($options=array())
   { $order=($options['order'])? $options['order']:'pkey desc' ;
     $limit='' ;
     if ($options['limit'])   $limit=' limit '.$options['limit'] ;
     //$join = '';
     //if ($options['join'])   $join=' left join '.$options['join'] ;
     $usl=$this->get_usl_select_mo_by_filter($options);
     if ($options['debug']) echo 'usl='.$usl.'<br>' ;
     // поле sign_id включено в вьювер
     $fields=($options['fields'])? $options['fields']:'*' ;
     $recs=execSQL('select '.$fields.' from '.$this->view_mo_session.' where '.$usl.' order by '.$order.$limit,array('debug'=>$options['debug'])) ;
     if (_sizeof($recs) and !$options['no_public_info']) foreach($recs as $id=>$rec) $this->prepare_public_info_to_mo($recs[$id],$options) ;
     return($recs) ;
   }

    // возвращает последний МО с терминала в пределах срока действия мед.допуска
    function get_last_mo_rec_from_terminal_in_allow_time($member_id)
    { $now=getdate(time()) ; $rec=array() ;
      $from=mktime($now['hours']-$GLOBALS['LS_setting_auto_mo_allow_interval'],$now['minutes'],$now['seconds'],$now['mon'],$now['mday'],$now['year']);
      $last_mo_id=execSQL_value('select pkey from obj_site_mo_session where member_id="'.$member_id.'" and terminal_id>0 and c_data>='.$from.' and status in (2,3) order by c_data desc limit 1') ;
      if ($last_mo_id)
      {   $rec=execSQL_van('select * from view_mo_session where pkey='.$last_mo_id) ;
          $this->prepare_public_info_to_mo($rec) ;
      }
      return($rec) ;
    }

    function check_active_dopusk($member_id,$options=array())
    { $rec=array() ;
      if ($options['debug']) echo 'Получаем активные допуски к КТ свыше текущено времени - '.date('d.m.Y H:i:s',time()).'<br>' ;
      $usl=array() ;
      $usl[]='member_id='.$member_id ;
      $usl[]='dopusk in (1,2)' ;   // важно найти менно последний МО с допуском/недопуском
      $usl_select=implode(' and ',$usl) ;
	  $rec=execSQL_van('select pkey,dopusk,dopusk_time,dopusk_time_end,comment from '.$this->table_mo_sessions.' where '.$usl_select.' order by pkey desc limit 1',array('debug'=>$options['debug'])) ;
	  // если время допуска/запрета допуска уже вышло - сбрасываем информацию по МО
	  if ($rec['dopusk_time_end']<time()) $rec=array() ;
      return($rec) ;
    }


    function get_mo_by_id($id,$options=array())
    {   $rec=array() ;
        if ($id)
        { $rec=execSQL_van('select * from '.$this->view_mo_session.' where pkey='.$id,array('debug'=>$options['debug'])) ;
          if ($rec['pkey'] and !$options['no_public_info']) $this->prepare_public_info_to_mo($rec) ;
        }
        return($rec) ;
    }

    function get_mo_by_ids($ids,$options=array())
    {   $recs=array() ;
        if ($ids)
        { $recs=execSQL('select * from '.$this->view_mo_session.' where pkey in ('.implode(',',$ids).')',array('debug'=>$options['debug'])) ;
            if (_sizeof($recs) and !$options['no_public_info']) foreach($recs as $id=>$rec) $this->prepare_public_info_to_mo($recs[$id],$options) ;
        }
        return($recs) ;
    }


    function get_mo_recs_to_personal($member_id,$options=array())
    {   $options['member_id']=$member_id ;
        $mo_recs=$this->get_mo_recs($options) ;
        return($mo_recs) ;
    }

    // используется в РМТ
    function get_last_mo_rec_to_personal($member_id,$options=array())
    {   $options['member_id']=$member_id ;
        $options['limit']=1 ;
        $mo_recs=$this->get_mo_recs($options) ;
        $rec=array() ;
        if (_sizeof($mo_recs)) list($id,$rec)=each($mo_recs) ;
        return($mo_recs) ;
    }

    // обрабочик события прошедшего МО
    // выяснить чей клиент, и если у клиента стоит флаг отправки результатов МО на PUSH - отправить ему данные
    function on_event_examination_result_kt($options=array())
    {
        //ob_start() ; $rec_client=array() ; $rec_mo=array() ;
      //if ($options['mo_id']) $rec_mo=ESMO()->get_mo_by_id($options['mo_id']) ;
        //$rec_mo['member_uid']='777' ;

      //$text=ob_get_clean() ;
      //LOGS()->reg_log('on_event_examination_result',$text) ;

        $rec_kt=$this->get_mo_by_id($options['mo_id']) ;
        // отправка уведомления, если был выявлен алкоголь
        if ($GLOBALS['LS_kt_notife_alco'])
        {
            if ($rec_kt['alcotester'] and $rec_kt['res_a']==2 and ($rec_kt['dopusk']==2 or $rec_kt['dopusk']==3))  $this->send_email_notice_by_alco($rec_kt) ;
        }

        // синхронная отправка данных на шлюз
        if ($GLOBALS['LS_kt_push_sync'] and ($rec_kt['dopusk']==1 or $rec_kt['dopusk']==2))  $this->send_push_kt_result_sync($options['mo_id']) ;
    }

    function send_push_kt_result_sync($kt_id)
    {   if (!$GLOBALS['LS_kt_push_server']) return ; // не задан сервер - выход
        if (!$this->check_push_kt_fields()) return ; // не заданы настройки полей - выход

        include(_DIR_EXT.'/esmo_gateway/i_push_kt.php') ;
        $push_obj=new i_push_kt() ;
        $push_obj->send_sync($kt_id) ;
    }

    function check_push_kt_fields()
    {
        //проверка что $GLOBALS['LS_mo_push_fields'] не пустой массив
        $kt_push_fields=$GLOBALS['LS_kt_push_fields'];
        if (!is_array($kt_push_fields)) $kt_push_fields=unserialize($kt_push_fields);
        if (!_sizeof($kt_push_fields)) return false;
        return true;
    }

    function send_email_notice_by_alco($rec_kt)
    { // отправляем уведомление о наличии алкоголя
        ob_start();

        ?><strong>Добрый день!</strong><br>
        При прохождении КТ был выявлен алкоголь:<br>
        <table>
            <tr><td style="text-align:left;">Показания прибора</td><td><?echo $rec_kt['alko_value']?></td></tr>
            <tr><td style="text-align:left;">ФИО сотрудника</td><td><?echo $rec_kt['personal_name']?> [UID: <?echo $rec_kt['member_uid']?>]</td></tr>
            <tr><td style="text-align:left;">Место работы</td><td><?echo $rec_kt['_org_name']?>, <?echo $rec_kt['_otdel_name']?></td></tr>
            <tr><td style="text-align:left;">Дата/время контроля трезвости</td><td><?echo $rec_kt['_data']?></td></tr>
            <tr><td style="text-align:left;">Номер терминала</td><td><?echo ($rec_kt['terminal_id'])? $rec_kt['terminal_id']:'РМВ'?></td></tr>
            <tr><td style="text-align:left;">ID контроля трезвости</td><td><?echo $rec_kt['pkey']?></td></tr>
        </table>
        <?
        $text = ob_get_clean();
        $rec_org=PERSONAL()->get_org_by_id($rec_kt['personal_parent2']) ;
        $rec_otdel=PERSONAL()->get_otdel_by_id($rec_kt['personal_parent3']) ;
        $arr_str_email=array() ;
        echo 'основной email для отправки уведомлений по алкоголю: '.$GLOBALS['LS_kt_notife_alco_email'].'<br>' ;
        if ($GLOBALS['LS_kt_notife_alco_email']) $arr_str_email[]=$GLOBALS['LS_kt_notife_alco_email'] ;
        if ($rec_org['_ext_info']['notify_email'] ) $arr_str_email[]=$rec_org['_ext_info']['notify_email'] ;
        echo 'email организации для отправки уведомлений по алкоголю: '.$rec_org['_ext_info']['notify_email'].'<br>' ;
        if ($rec_otdel['_ext_info']['notify_email']) $arr_str_email[]=$rec_otdel['_ext_info']['notify_email'] ;
        echo 'email подразделения для отправки уведомлений по алкоголю: '.$rec_otdel['_ext_info']['notify_email'].'<br>' ;
        $str_email=implode(',',$arr_str_email) ;

        $str_email=str_replace(array(' ',';'),',',$str_email) ;
        $arr_emails=explode(',',$str_email) ;
        if (_sizeof($arr_emails))
        { $email=trim($arr_emails[0]) ; unset($arr_emails[0]) ;
            $mail_options['cc']=array() ;
            $mail_options['debug']=1;
            $mail_options['no_asyns_send_mail']=1;
            if (_sizeof($arr_emails)) foreach($arr_emails as $cc_email) if (trim($cc_email)) $mail_options['cc'][trim($cc_email)]=trim($cc_email) ;
            MAILS()->send_mail($email,'Автоматическое уведомление о выявлении алкоголя на КТ',$text,$mail_options);
        }

        $text = ob_get_clean();
        echo $text;
        $name = LOGS()->reg_file_log('send_email_alco_notife',$text);
        LOGS()->reg_log('Автоматическое уведомление о выявлении алкоголя на КТ','<a target=_blank href="' . $name . '">Отчет</a>'.$text);
        LOG_JSON('mo_session')->reg('Автоматическое уведомление о выявлении алкоголя на КТ','<a target=_blank href="' . $name . '">Отчет</a>'.$text);
    }


    function reg_monitor_mess($group,$arr_mess)
    {   // пишем событие для HTML версии
        // получаяем очередной ID события
	    ob_start() ;
	    if (!is_dir(_DIR_TO_ROOT._STORAGE_DIR._MONITOR_KT_DIR)) check_exists_dir(_STORAGE_DIR._MONITOR_KT_DIR) ;
	    execSQL_update('update obj_site_setting set value=value+1 where comment="LS_kt_event_id"') ;
        $event_id=execSQL_value('select value from obj_site_setting where comment="LS_kt_event_id"') ;
	    //$fname=$this->dir_monitor.'/evt_'.$group.'_'.$event_id.'.json' ;
	    $fname=_DIR_TO_ROOT._STORAGE_DIR._MONITOR_KT_DIR.'/evt_'.$event_id.'.json' ;
	    $arr_mess['zone_id']=$group ;
	    //echo 'dir_monitor='.$this->dir_monitor.'<br>' ;
	    echo 'fname='.$fname.'<br>' ;
        file_put_contents($fname,json_encode($arr_mess)) ;
        $text=ob_get_clean() ;
        LOGS()->reg_log('reg_monitor_mess',$text,array('data'=>$arr_mess)) ;
	    return($fname) ;
    }

    function get_last_monitor_mess_id_HTML($group=0)
    {   //$last_id=execSQL_value("SELECT last_kt_event from obj_site_skd where pkey=".$group) ;
	    $last_id=execSQL_value('select value from obj_site_setting where comment="LS_kt_event_id"') ;
        return($last_id) ;
    }

    function cron_send_push_kt_result_async()
    {
        if ($GLOBALS['LS_kt_push_async']) $this->send_push_kt_result_async() ;
    }

    function send_push_kt_result_async()
    {
        if (!$GLOBALS['LS_kt_push_server']) return ; // не задан сервер - выход
        if (!$this->check_push_kt_fields()) return ; // не заданы настройки полей - выход

        include_once(_DIR_EXT.'/esmo_gateway/i_push_kt.php') ;
        $push_obj=new i_push_kt() ;
        $kt_ids=$push_obj->get_kt_ids_to_async_send() ;

        echo _sizeof($kt_ids).' КТ для отправки<br>' ;
        if (_sizeof($kt_ids))
        {   $result=$push_obj->send_async($kt_ids) ;
            ?><p><strong>Статус ответа:</strong> <?echo '<span style="font-size:22px;" class="'.(($result['status']==200)? 'green':'red').'">'.$result['status']?></span></p><?
            if ($result['send_result']!='success')
            {    ?><p><strong>Ошибка:</strong> <?echo '<span style="font-size:16px;color:red;">'.$result['send_error']?></span></p><p>Подробный отчет: <a href="<? echo $result['log_url']?>" target="_blank">перейти</a></p><?
                ?><p><strong>Время ответа:</strong> <?echo round($result['time_exec'],4).' сек.'?></p><?
                ?><p><strong>Ответ:</strong></p><?
                echo nl2br($result['send_response']) ;
            }
        }
    }

}

?>
