<?
/*базовый класс для создания документов в системе и хранения их в PDF
  на его основе будет создан класс c_report для создания отчетов
*/

function DOC() { if (!isset($GLOBALS['def_doc_obj'])) $GLOBALS['def_doc_obj']=new c_doc ; return($GLOBALS['def_doc_obj']); } ;


class c_doc //extends c_system
{ public $editing=false ;

  public $filter=array() ;
  public $default_filter=array() ;
  public $report_code='' ;
  public $report_class='' ;
  public $cnt_items ;
  public $first_obj=1 ;
  public $report_paginator=1 ;
  public $no_view_title=0 ;
  public $view_panel_info=1 ;
  public $show_sign_stamp=0 ;

  public $use_datepicker=1 ;
  public $use_jwplayer=0 ;
  public $use_fusioncharts=0 ;


    public $PDF_page_orientation='L' ; // L P
    public $PDF_page_format='A4' ;
    public $PDF_page_keepmargins=false ;
    public $PDF_page_tocpage=false ;
    public $PDF_show_header=true ;
    public $is_signed=false ;
    public $doc_code='' ; // код документа, если не задан, то будет получен из наименования класса
    public $report_script='' ; // код документа, если не задан, то будет получен из наименования класса
    public $db_report_code='' ; // Имя директории в таблице документов для сохранения докумена. Если не задать, будет использован код отчета. Необходимо задать, если требуется чтобы несколько отчетов имели общую нумерацию
    public $doc_id ;

  public $view_h1_title=true ;
  public $url_report='' ;
  public $rec_doc=array() ;
  public $content=array() ;
  public $copies=1 ;
  var $footer_right='' ;
  var $required_fields=array() ;


  function __construct($create_options=array())
  {
      $this->report_class=get_class($this) ;
      if (!$this->doc_code) $this->doc_code=str_replace('doc_','',$this->report_class) ;
      $this->report_code=$this->doc_code ;

      // в режиме инсталятора далее не идем
      if (ESMO_STATUS=='SETUP_FIRST' or ESMO_STATUS=='SETUP_SECOND') return ;



     if ($create_options['filter']) $this->filter=$create_options['filter'] ;
     elseif (_CUR_FILTER)           $this->filter=ENGINE()->parse_url(_CUR_FILTER);
     if ($create_options['default_filter']) $this->default_filter=$create_options['default_filter'] ;
     if (_sizeof($this->default_filter))
      { $this->filter=array_merge($this->filter,$this->default_filter) ;
        foreach($this->default_filter as $name=>$value)  if (!isset($this->$name)) $this->$name=$value ; // проставляем значения типа personal_id=121
      }

    // пока определяем report_code через URL, но в принципе должно задаваться в классе
    // проверить переменные $url_report
    //$this->report_code=(defined('_CUR_FILTER') and _CUR_FILTER!="")? _CUR_FILTER:'';
    //if (!$this->doc_code) $this->doc_code=str_replace('doc_','',get_class($this));
    //$this->report_class=get_class($this) ;
    if (!$this->report_script and isset(ENGINE()->docs_list[$this->doc_code])) $this->report_script=hide_server_dir(_DIR_EXT.'/'.ENGINE()->docs_list[$this->doc_code]['script_dir']) ;
    $this->url_report=(defined('_CUR_REPORT_DIR') and _CUR_REPORT_DIR!="")? _CUR_REPORT_DIR:_CUR_CAB_DIR;


    if ($this->filter['doc_id']) $this->rec_doc=DOCS()->get_doc_by_id($this->filter['doc_id']) ;
    if ($this->rec_doc['pkey']) $this->content=unserialize($this->rec_doc['content']) ;
    if (ESMO_STATUS!='SETUP_FIRST' and ESMO_STATUS!='SETUP_SECOND' and !$create_options['no_init_after_create']) $this->init() ;

  }

  function init($options=array()) {}
  function setting() {}


  /**************************************************************************************************************************************/
  //
  // РАБОТА с URL, разбор параметров
  //
  /**************************************************************************************************************************************/

   // prepare_url by POST
   function prepare_url($filter,$options=array())
     {   $res_url=ENGINE()->prepare_url($filter,$options) ;
       return($res_url) ;
   }

  function prepare_url_by_filter($filter,$options=array())
     {   $res_url=ENGINE()->prepare_url_by_filter($filter,$options) ;
       return($res_url) ;
   }

   // меняем местами ключи со значениями в массивах фильтра
   function filter_array_flip($filter)
        { $res=ENGINE()->filter_array_flip($filter) ;
          return($res) ;
        }

     // меняем местами ключи со значениями в массивах фильтра
     function clear_space_value($filter)
        { $res=ENGINE()->clear_space_value($filter) ;
        return($res) ;
      }

   function get_filter_to_params($params,$options=array())
     { if (!$options['url_report']) $options['url_report']=$this->url_report  ;
       $res=ENGINE()->get_filter_to_params($this->filter,$params,$options) ;
       return($res) ;
   }

   function get_time_range_by_filter_to_cur_day()
     { $res=ENGINE()->get_time_range_by_filter_to_cur_day($this->filter) ;
       return($res) ;
   }

  /**************************************************************************************************************************************/
  //
  // ВЫВОД СТРАНИЦЫ
  //
  /**************************************************************************************************************************************/

  function view($options=array())
  {  switch($this->filter['view'])
       { case 'prePDF': $this->prepare_PDF($options) ; break ;
         case 'PDF': $this->view_as_PDF($options) ; break ;
         case 'print': $this->prepare_to_print($options) ; break ;
         default:    $this->view_as_HTML($options) ;
       }
  }

  function panel_buttons()
     { ?><div id="panel_buttons"><input type="submit" class="button v2" cmd="set_filter" value="<?echo ($this->editing)? 'Получить данные':'Сформировать отчет'?>">&nbsp;&nbsp;<?
       if (!$this->editing)
       {?><button class="button v2" cmd="docs/doc_create">Сохранить в документах</button>&nbsp;&nbsp;<??>
                            <button class="button v2" cmd="report/view_as_html">HTML</button>&nbsp;&nbsp;
                            <button class="button v2" cmd="report/view_as_pdf" mode="HTML2PDF">PDF</button>&nbsp;&nbsp;
                            <button class="button v2" cmd="report/to_print">Печать</button>&nbsp;&nbsp;
                          <?}
       ?></div><?
     }

 function panel_button_apply()
 { ?><div id="panel_buttons"><input type="submit" class="button v2" cmd="set_filter" value="<?echo ($this->editing)? 'Получить данные':'Применить'?>"></div><?
 }

 function panel_buttons_action()
 { ?><div id="panel_buttons"><?
   if ($this->filter and !$this->editing)
   {?><button class="button v2" cmd="docs/doc_create"><i class="fa fa-floppy-o"></i></button>&nbsp;&nbsp;
                        <button class="button v2" cmd="report/view_as_html"><i class="fa fa-file-text-o"></i></button>&nbsp;&nbsp;
                        <button class="button v2" cmd="report/view_as_pdf" mode="HTML2PDF"><i class="fa fa-file-pdf-o"></i></button>&nbsp;&nbsp;
                        <button class="button v2" cmd="report/to_print"><i class="fa fa-print"></i></button>&nbsp;&nbsp;
                      <?}
   ?></div><?

 }

 function panel_info_filter()
 { $_str=array() ; $info=array() ; $title='' ;
   //if ($this->filter['member'])                           $info['механик']=ACCOUNTS()->get_member_name_by_id($this->filter['member'] )  ;
   if ($this->filter['data_from'])                        $info['c']=$this->filter['data_from'] ;
   if ($this->filter['data_to'])                          $info['по']=$this->filter['data_to'] ;
   if (_sizeof($info)) foreach($info as $title=>$value) $_str[]=$title.': <strong>'.$value.'</strong>' ;
   if (_sizeof($_str)) $title='<div class=center>'.implode(' ',$_str).'</div>' ;
   return $title ;
   }

/**************************************************************************************************************************************/
//
// формирование HTML
//
/**************************************************************************************************************************************/


    function view_as_HTML($options=array())
    { if (!$options['template_name']) $result=$this->HTML_report_body($options) ;
      else                            $result=$this->$options['template_name']($options) ;
      return($result) ;
    }

    // основная функция в которорой будет фрмироваться тело отчета
    function HTML_report_body($options=array())
    {
      return(1) ;
    }

/**************************************************************************************************************************************/
//
// генерация PDF
//
/**************************************************************************************************************************************/

    //  подготавливаем PDF файл. Вызывается при передаче параметра в URL [view=prePDF]
    function prepare_PDF($options=array())
    {
        ob_start() ;
            $this->view_as_HTML($options) ;
        $html=ob_get_clean() ;
        $file_name=($options['file_name'])? $options['file_name']:'report_'.md5(rand(1,100000)) ;
        $result=$this->HTML2PDF_create_PDF_file($file_name,$this->title,$html) ;
        // формируем URL, на который будет переход после формирования документа
        $temp_filter=$this->filter ;
        $temp_filter['view']='PDF' ;
        $temp_filter['file_pdf']=$result['PDF_file_name'] ;
        $url_page_doc_view=_PATH_TO_SITE._CUR_REPORT_DIR.$this->prepare_url_by_filter($temp_filter) ;
        //echo '$url_page_doc_view='.$url_page_doc_view.'<br>' ;
        //damp_array($temp_filter) ;
        //echo $url_report.'<br>' ;
        $this->panel_view_pdf_convert($result['cmd_uid'],$url_page_doc_view) ;


    }

    function HTML2PDF_create_PDF_file($doc_name,$report_title,$html)
    { ob_start() ;
      $source_html=_TEMP_DIR.$doc_name.'.html' ;
      $target_pdf=_TEMP_DIR.$doc_name.'.pdf' ;

      // обертываем в теги и сохраняем в файл
      $this->prepare_HTML_to_PDF_convert($html,$report_title,$source_html,array()) ;

      // отдаем HTML2PDF для преобразования
      $result_convert=$this->execHTML2PDF($source_html,$target_pdf) ;

      $text=ob_get_clean()  ;    echo $text ;
      LOGS()->reg_log('HTML2PDF',$text,array('data'=>$result_convert)) ;
      return($result_convert) ;
    }

    // подготовка HTML файла для преобразования в PDF
    // 1. Надо обернуть html в стандартные теги
    // 2. Дописать внуть содержимое файла стилей
    // 3. Убрать из текста ссылки
    // 4. Сохранить HTML во временный файл, вернуть путь к времененному файлу
    function prepare_HTML_to_PDF_convert($html,$title,$temp_file,$options=array())
    {    $text='<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"><html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">' ;
         $text.='<head>';
         $text.='<title>'.$title.'</title>';
         $text.='<META http-equiv="Content-Type" content="text/html; charset=utf-8">';
         $text.='<style type="text/css">'.file_get_contents(_DIR_TO_CLASS.'/style.css').'</style>' ;
         //$text.='<link rel="stylesheet" type="text/css" href="/'._CLASS_.'/style_pdf.css" charset="utf-8">';
         $text.='</head>';
         $text.='<body>';
         $text.=$html ;
         if ($this->show_sign_stamp)
         { ob_start() ;
           ?><div style="border:3px solid black;border-radius:20px;text-align:center;padding:10px;margin:50px;font-size:20px;line-height:1.8em;float:left;">
                <strong>ДОКУМЕНТ ПОДПИСАН<br>УСИЛЕННОЙ КВАЛИФИЦИРОВАННОЙ<br>ЭЛЕКТРОННОЙ ПОДПИСЬЮ</strong><br>
                <div style="font-size:15px;">Сведения о сертификате ЭП<br>
                Сертификат: <?echo MEMBER()->certificate['SerialNumber']?><br>
                Владелец: <?echo MEMBER()->name?><br>
                Срок действия с <?echo MEMBER()->certificate['ValidFromDate']?> по <?echo MEMBER()->certificate['ValidToDate']?>
             </div></div><div class="clear"></div><?
           $text.=ob_get_clean() ;
         }
         $text.='</body>';
         $text.='</html>';
         if ($GLOBALS['LS_use_localhost_in_pdf']) $text=str_replace(_PATH_TO_SITE,_MAIN_PROTOCOL.'127.0.0.1',$text);
         $text=preg_replace('/<a\s+.*?href=[\"\']?([^\"\' >]*)[\"\']?[^>]*>(.*?)<\/a>/i','\2',$text) ;                  // удаляем все ссылкм
         $text=preg_replace ("!<a.*?href=\"?'?([^ \"'>]+)\"?'?.*?>(.*?)</a>!is", "\\2", $text);    // удаляем все ссылкм
         file_put_contents($temp_file,$text) ;
    }


    function execHTML2PDF($from,$to,$options=array())
    {   $_PDF_options=array() ;
        $_PDF_options[]='--footer-font-size 10';
        $_PDF_options[]='--page-size '.$this->PDF_page_format;
        if ($this->footer_right) $_PDF_options[]='--footer-right '.$this->footer_right ;
        if ($this->PDF_page_orientation=='L') $_PDF_options[]='-O Landscape' ;
        if ($this->PDF_page_orientation=='P') $_PDF_options[]='-O Portrait' ;
        if ($options['pdf_options'])          $_PDF_options[]=$options['pdf_options'] ;
        $PDF_options=implode(' ',$_PDF_options) ;

        $cmd=_HTML2PDF_.' '.$PDF_options.' '.$from.' '.$to ;

        $cmd_uid=md5(uniqid(rand(),true)) ;

        $outputfile=_TEMP_DIR.'log_'.$cmd_uid.'.txt' ;
        $pidfile=_TEMP_DIR.'exec_'.$cmd_uid.'.txt' ;
        if (file_exists($outputfile)) unlink($outputfile) ;
        if (file_exists($pidfile)) unlink($pidfile) ;
        if (file_exists($to)) unlink($to) ;
        $bash_cmd=sprintf("%s > '%s' 2>&1 & echo $! >> '%s'", $cmd, $outputfile, $pidfile) ;
        exec($bash_cmd)   ;



        $res=array('from'=>$from,
                     'to'=>$to,
                     'outputfile'=>$outputfile,
                     'pidfile'=>$pidfile,
                     'cmd_uid'=>$cmd_uid,
                     'bash_cmd'=>$bash_cmd,
                     'HTML_file_name'=>basename($from),
                     'HTML_file_name_url'=>_PATH_TO_SITE.hide_server_dir($from),
                     'HTML_file_name_link'=>'<a href="'._PATH_TO_SITE.hide_server_dir($from).'" target=_blank>'._PATH_TO_SITE.hide_server_dir($from).'</a>',
                     'PDF_file_name'=>basename($to),
                     'PDF_file_name_url'=>_PATH_TO_SITE.hide_server_dir($to),
                     'PDF_file_name_link'=>'<a href="'._PATH_TO_SITE.hide_server_dir($to).'" target=_blank>'._PATH_TO_SITE.hide_server_dir($to).'</a>',

                )  ;

        $arr_from=explode(' ',$from) ;
        if (_sizeof($arr_from)>1)
        {   $res_from=array() ;
            foreach($arr_from as $from_item)
            {  $res_from['HTML_file_name'][]=basename($from_item) ;
               $res_from['HTML_file_name_url'][]=_PATH_TO_SITE.hide_server_dir($from_item) ;
               $res_from['HTML_file_name_link'][]='<a href="'._PATH_TO_SITE.hide_server_dir($from_item).'" target=_blank>'._PATH_TO_SITE.hide_server_dir($from_item).'</a>' ;
            }
            $res['HTML_file_name']=implode('<br>',$res_from['HTML_file_name']) ;
            $res['HTML_file_name_url']=implode('<br>',$res_from['HTML_file_name_url']) ;
            $res['HTML_file_name_link']=implode('<br>',$res_from['HTML_file_name_link']) ;
        }

        return($res) ;

    }



    function panel_view_pdf_convert($cmd_uid,$url_page_doc_view)
    {  ?><div class="green">Ожидайте, идет формирование документа PDF</div><div id="log_view"></div><div class="center" id="buttons777"><button class="button cancel">Отмена</button></div>
          <script type="text/javascript">
         var panel_messages=$j('#log_view') ;
         $j('#log_view').everyTime(1000,'update_log_view',function()
         {  send_ajax_request({cmd:'report/update_log_view',cmd_uid:'<?echo $cmd_uid?>',url_page_doc_view:'<?echo $url_page_doc_view?>'}) ;
            //console.log(panel_messages[0].scrollHeight+' - '+panel_messages[0].clientHeight);
            // scroll animate небходимо переставить в функцию, которая выводит текст, сейчас анимация опазывает за выводом
            panel_messages.animate({scrollTop:panel_messages[0].scrollHeight-panel_messages[0].clientHeight+20});
         });
        </script>
        <style type="text/css">
          #log_view{height:400px;overflow-y: scroll;margin-bottom:15px;border-top:1px solid #dddddd;border-left:1px solid #dddddd;border-bottom:1px solid #dddddd; padding:10px 0 10px 10px;margin-top:20px;}
        </style>
        <?
    }

/**************************************************************************************************************************************/
//
// показ PDF
//
/**************************************************************************************************************************************/


   function view_as_PDF($options=array())
   { if ($this->filter['file_pdf'])
     { $doc_file_name=$this->filter['file_pdf'] ;
       $doc_file_path=_TEMP_PATH.$doc_file_name;
       ?><iframe src="<?echo $doc_file_path?>"  style="width:100%; height:1300px;margin-top:20px;" frameborder="0"></iframe><?
     }
     else echo 'Не указано имя PDF-файла' ;
    }

/**************************************************************************************************************************************/
//
// подпись PDF документа
//
/**************************************************************************************************************************************/

   function sign_pdf($pdf,$options=array())
   {

   }

/**************************************************************************************************************************************/
//
// сохранение PDF
//
/**************************************************************************************************************************************/


    function save_as_PDF($options=array())
    { ob_start() ;
      $this->view_as_HTML($options) ;
      $html=ob_get_clean() ;
      $file_name=($options['file_name'])? $options['file_name']:'report_'.md5(rand(1,100000)) ;
      $result=$this->HTML2PDF_create_PDF_file($file_name,$this->title,$html) ;
      return($result) ;
    }

/**************************************************************************************************************************************/
//
// PRINT
//
/**************************************************************************************************************************************/

    function prepare_to_print($options=array())
    { // сохраняем HTML  во временный файл
      ob_start() ;
        $this->view_as_HTML($options) ;
      $html=ob_get_clean() ;
      $html=preg_replace ("!<a.*?href=\"?'?([^ \"'>]+)\"?'?.*?>(.*?)</a>!is", "\\2", $html);    // удаляем все ссылкм
      $file_name='temp_'.md5(rand(1,100000)) ;
      $doc_file_name=$this->create_HTML_file($file_name,$html,'',$this->panel_info_filter()) ;
      $doc_file_path=_TEMP_PATH.$doc_file_name;
      // показываем  этот временный файл в отдельном фрейме
      ?><iframe src="<?echo $doc_file_path?>"  style="width:100%; height:700px;margin-top:20px;" frameborder="0"></iframe><div id="div_backgroudPrint"></div><?
      // отправляем фрейм на печать
      _CUR_PAGE()->use_printPage=1 ;
      ?><script type="text/javascript">
        $j(document).ready(function()
           {  $j('div#div_backgroudPrint').printPage({url:'<?echo $doc_file_path?>'}) ;
                       $j('div#div_backgroudPrint').click() ;
           }) ;
                     </script><?
      }


    function create_HTML_file($doc_name,$html,$report_title='',$report_info='',$options=array())
    {   $html_css ='<style>'.file_get_contents(_DIR_TO_CLASS.'/style_print.css').'</style>' ;
        $title=($report_title)? $title='<h2 class="center">'.$report_title.'</h2><p class="center">'.$report_info.'</p>':'' ;

        $doc_file_name=$doc_name.'.html' ;
        $doc_dir=_TEMP_DIR.$doc_file_name ;
        file_put_contents($doc_dir,$html_css.$title.$html);
        return($doc_file_name) ;
    }


    function check_doc_fields($filter)
        {  $arr_errors=array() ;
           if (_sizeof($this->required_fields)) foreach($this->required_fields as $required_field=>$title)
             if (!$filter[$required_field]) $arr_errors[]=$title ;
           if (_sizeof($arr_errors)) $result['error']='Не заполнено поле: '.implode(', ',$arr_errors) ;
           return($result) ;
        }



}

?>
